/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.Attribute;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.core.compiler.ast.nodes.IAttributed;
import org.eclipse.php.core.compiler.ast.nodes.ReturnType;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class LambdaFunctionDeclaration
extends Expression
implements IAttributed {
    private final boolean isReference;
    private final boolean isStatic;
    private final List<? extends Expression> lexicalVars;
    protected List<FormalParameter> arguments = new LinkedList<FormalParameter>();
    private Block body;
    private ReturnType returnType;
    private List<Attribute> attributes;

    public LambdaFunctionDeclaration(int start, int end, List<FormalParameter> formalParameters, List<? extends Expression> lexicalVars, Block body, boolean isReference) {
        this(start, end, formalParameters, lexicalVars, body, isReference, false);
    }

    public LambdaFunctionDeclaration(int start, int end, List<FormalParameter> formalParameters, List<? extends Expression> lexicalVars, Block body, boolean isReference, boolean isStatic) {
        this(start, end, formalParameters, lexicalVars, body, isReference, isStatic, null);
    }

    public LambdaFunctionDeclaration(int start, int end, List<FormalParameter> formalParameters, List<? extends Expression> lexicalVars, Block body, boolean isReference, boolean isStatic, TypeReference returnType) {
        super(start, end);
        if (formalParameters != null) {
            this.arguments = formalParameters;
        }
        this.body = body;
        this.lexicalVars = lexicalVars;
        this.isReference = isReference;
        this.isStatic = isStatic;
        this.setReturnType(returnType);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            if (this.attributes != null) {
                for (Attribute attribute : this.attributes) {
                    attribute.traverse(visitor);
                }
            }
            for (FormalParameter formalParameter : this.arguments) {
                formalParameter.traverse(visitor);
            }
            if (this.lexicalVars != null) {
                for (Expression expression : this.lexicalVars) {
                    expression.traverse(visitor);
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(visitor);
            }
            if (this.body != null) {
                this.body.traverse(visitor);
            }
            visitor.endvisit((Expression)this);
        }
    }

    public Collection<? extends Expression> getLexicalVars() {
        return this.lexicalVars;
    }

    public Collection<FormalParameter> getArguments() {
        return this.arguments;
    }

    public Block getBody() {
        return this.body;
    }

    public void setBody(Block body) {
        this.body = body;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public TypeReference getReturnType() {
        if (this.returnType != null) {
            return this.returnType.getReturnType();
        }
        return null;
    }

    public void setReturnType(TypeReference returnType) {
        if (returnType != null) {
            this.returnType = new ReturnType(returnType);
        }
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }

    public int getKind() {
        return 73;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }
}

