/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.ArrayList;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.codeassist.CompletionCompanion;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.codeassist.IElementFilter;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionCallParameterContext;
import org.eclipse.php.internal.core.codeassist.strategies.AbstractCompletionStrategy;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class FunctionCallParameterNameStrategy
extends AbstractCompletionStrategy {
    private static String ELLIPSIS = "...";

    public FunctionCallParameterNameStrategy(ICompletionContext context, IElementFilter elementFilter) {
        super(context, elementFilter);
    }

    public FunctionCallParameterNameStrategy(ICompletionContext context) {
        super(context);
    }

    @Override
    public void init(CompletionCompanion companion) {
        super.init(companion);
    }

    @Override
    public void apply(ICompletionReporter reporter) throws Exception {
        if (PHPVersion.PHP8_0.isGreaterThan(this.getCompanion().getPHPVersion())) {
            return;
        }
        FunctionCallParameterContext context = (FunctionCallParameterContext)this.getContext();
        Object prefix = context.getPrefix();
        if (!(((String)prefix).isEmpty() || ((String)prefix).charAt(0) != '&' && ((String)prefix).charAt(0) != '$')) {
            return;
        }
        TextSequence statement = context.getStatementText();
        int pos = statement.length() - ((String)prefix).length();
        if ((pos = PHPTextSequenceUtilities.readBackwardSpaces(statement, pos)) < 1) {
            return;
        }
        char start = statement.charAt(--pos);
        boolean hasDot = false;
        while (start == '.') {
            start = statement.charAt(--pos);
            hasDot = true;
            prefix = "." + (String)prefix;
        }
        pos = PHPTextSequenceUtilities.readBackwardSpaces(statement, pos);
        if (start == '(' && !context.isConstructor() && PHPVersion.PHP8_0.isLessThan(this.getCompanion().getPHPVersion()) && ELLIPSIS.startsWith((String)prefix)) {
            int s = this.getCompanion().getOffset() - ((String)prefix).length();
            reporter.reportKeyword(ELLIPSIS, "", (ISourceRange)new SourceRange(s, context.getReplacementEnd() - s));
        }
        if (hasDot || start != '(' && start != ',') {
            return;
        }
        IMethod[] method = context.getMethod();
        if (method.length == 0) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = method[0].getParameterNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.substring(1).startsWith((String)prefix)) {
                names.add(name);
            }
            ++n2;
        }
        stringArray = method[0].getChildren();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String el = stringArray[n2];
            if (el instanceof IField && names.contains(el.getElementName())) {
                reporter.reportField((IField)el, ": ", this.getReplacementRange(context), true, 10000000, (Object)2048);
                names.remove(el.getElementName());
            }
            ++n2;
        }
    }
}

