/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.evaluation.types;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class MultiTypeType
implements IEvaluatedType {
    private List<IEvaluatedType> fTypes = new ArrayList<IEvaluatedType>();

    public void addType(IEvaluatedType type) {
        for (IEvaluatedType ltype : this.fTypes) {
            if (!ltype.equals(type)) continue;
            return;
        }
        this.fTypes.add(type);
    }

    @Override
    public String getTypeName() {
        Object names = "";
        for (IEvaluatedType type : this.fTypes) {
            names = (String)names + type.getTypeName() + " ";
        }
        return "multitype:" + (String)names;
    }

    public List<IEvaluatedType> getTypes() {
        return this.fTypes;
    }

    public int size() {
        if (this.fTypes != null) {
            return this.fTypes.size();
        }
        return 0;
    }

    public IEvaluatedType get(int i) {
        if (this.fTypes != null) {
            return this.fTypes.get(i);
        }
        return null;
    }

    @Override
    public boolean subtypeOf(IEvaluatedType type) {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fTypes == null ? 0 : this.fTypes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiTypeType other = (MultiTypeType)obj;
        return !(this.fTypes == null ? other.fTypes != null : !this.fTypes.equals(other.fTypes));
    }
}

