/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.text.quicksearch.internal.core.priority.DefaultPriorityFunction;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchActivator;

public class QuickSearchPreferences {
    public static final String IGNORED_EXTENSIONS = "ignored.extensions";
    public static final String IGNORED_NAMES = "ignored.names";
    public static final String IGNORED_PREFIXES = "ignored.prefixes";
    public static final String MAX_LINE_LEN = "LineReader.MAX_LINE_LEN";
    public static final String MAX_RESULTS = "QuickTextSearcher.MAX_RESULTS";
    private static boolean initializedDefaults;
    private final IPreferenceStore store;

    public QuickSearchPreferences(IPreferenceStore preferenceStore) {
        this.store = preferenceStore;
        QuickSearchPreferences.initializeDefaults();
    }

    public String[] getIgnoredExtensions() {
        return this.getAndParseStringList(IGNORED_EXTENSIONS);
    }

    public String[] getIgnoredPrefixes() {
        return this.getAndParseStringList(IGNORED_PREFIXES);
    }

    public String[] getIgnoredNames() {
        return this.getAndParseStringList(IGNORED_NAMES);
    }

    public int getMaxLineLen() {
        return this.store.getInt(MAX_LINE_LEN);
    }

    public int getMaxResults() {
        return this.store.getInt(MAX_RESULTS);
    }

    private String[] getAndParseStringList(String key) {
        String raw = this.store.getString(key);
        if (raw != null) {
            return this.parseStringList(raw);
        }
        return null;
    }

    private String[] parseStringList(String raw) {
        String[] elements = raw.split("[,\n]");
        ArrayList<String> list = new ArrayList<String>(elements.length);
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (!(e = e.trim()).isEmpty()) {
                list.add(e);
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static void initializeDefaults() {
        if (!initializedDefaults) {
            initializedDefaults = true;
            IPreferenceStore store = QuickSearchActivator.getDefault().getPreferenceStore();
            store.setDefault(MAX_LINE_LEN, 1000);
            store.setDefault(MAX_RESULTS, 200);
            DefaultPriorityFunction dpf = new DefaultPriorityFunction();
            store.setDefault(IGNORED_EXTENSIONS, QuickSearchPreferences.encode(dpf.ignoredExtensions));
            store.setDefault(IGNORED_NAMES, QuickSearchPreferences.encode(dpf.ignoredNames));
            store.setDefault(IGNORED_PREFIXES, QuickSearchPreferences.encode(dpf.ignoredPrefixes));
        }
    }

    private static String encode(String[] strings) {
        return String.join((CharSequence)", ", strings);
    }
}

