/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core.operations;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.mylyn.commons.core.operations.ICancellableOperation;

public class CancellableOperationMonitorThread
extends Thread {
    private static final int DEFAULT_POLLING_INTERVAL = 1000;
    private static CancellableOperationMonitorThread instance;
    private final List<ICancellableOperation> operations = new CopyOnWriteArrayList<ICancellableOperation>();
    private final long pollingInterval;
    private boolean shutdown;

    public static synchronized CancellableOperationMonitorThread getInstance() {
        if (instance == null) {
            instance = new CancellableOperationMonitorThread();
        }
        return instance;
    }

    public CancellableOperationMonitorThread() {
        this(1000L);
    }

    public CancellableOperationMonitorThread(long pollingInterval) {
        this.pollingInterval = pollingInterval;
        this.setDaemon(true);
    }

    public synchronized void addOperation(ICancellableOperation operation) {
        this.checkShutdown();
        this.operations.add(operation);
        if (!this.isAlive() && !this.shutdown) {
            this.start();
        } else {
            this.notify();
        }
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public synchronized void processOperations() throws InterruptedException {
        if (this.operations.isEmpty()) {
            throw new IllegalStateException("The list of operations is empty");
        }
        this.checkShutdown();
        this.notify();
        this.wait();
        this.notify();
        this.wait();
    }

    public synchronized void removeOperation(ICancellableOperation operation) {
        this.checkShutdown();
        this.operations.remove(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block5: while (true) {
                Iterator<ICancellableOperation> iterator = this.operations.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        CancellableOperationMonitorThread cancellableOperationMonitorThread = this;
                        synchronized (cancellableOperationMonitorThread) {
                            this.notifyAll();
                            if (this.shutdown) {
                                return;
                            }
                            if (this.operations.isEmpty()) {
                                this.wait();
                            } else {
                                this.wait(this.pollingInterval);
                            }
                            continue block5;
                        }
                    }
                    ICancellableOperation opertion = iterator.next();
                    if (!opertion.isCanceled()) continue;
                    opertion.abort();
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void shutdown() throws InterruptedException {
        this.shutdown = true;
        this.notify();
        if (this.isAlive()) {
            this.join();
        }
    }

    @Override
    public synchronized void start() {
        this.checkShutdown();
        super.start();
    }

    private void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("Already shutdown");
        }
    }
}

