/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.internal.hppc.LongHashSet;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOConsumer;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;

final class BufferedUpdatesStream
implements Accountable {
    private final Set<FrozenBufferedUpdates> updates = new HashSet<FrozenBufferedUpdates>();
    private long nextGen = 1L;
    private final FinishedSegments finishedSegments;
    private final InfoStream infoStream;
    private final AtomicLong bytesUsed = new AtomicLong();

    BufferedUpdatesStream(InfoStream infoStream) {
        this.infoStream = infoStream;
        this.finishedSegments = new FinishedSegments(infoStream);
    }

    synchronized long push(FrozenBufferedUpdates packet) {
        packet.setDelGen(this.nextGen++);
        assert (packet.any());
        assert (this.checkDeleteStats());
        this.updates.add(packet);
        this.bytesUsed.addAndGet(packet.bytesUsed);
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "push new packet (%s), packetCount=%d, bytesUsed=%.3f MB", packet, this.updates.size(), (double)this.bytesUsed.get() / 1024.0 / 1024.0));
        }
        assert (this.checkDeleteStats());
        return packet.delGen();
    }

    synchronized int getPendingUpdatesCount() {
        return this.updates.size();
    }

    synchronized void clear() {
        this.updates.clear();
        this.nextGen = 1L;
        this.finishedSegments.clear();
        this.bytesUsed.set(0L);
    }

    boolean any() {
        return this.bytesUsed.get() != 0L;
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitApplyAll(IndexWriter writer) throws IOException {
        HashSet<FrozenBufferedUpdates> waitFor;
        assert (!Thread.holdsLock(writer));
        BufferedUpdatesStream bufferedUpdatesStream = this;
        synchronized (bufferedUpdatesStream) {
            waitFor = new HashSet<FrozenBufferedUpdates>(this.updates);
        }
        this.waitApply(waitFor, writer);
    }

    boolean stillRunning(long delGen) {
        return this.finishedSegments.stillRunning(delGen);
    }

    void finishedSegment(long delGen) {
        this.finishedSegments.finishedSegment(delGen);
    }

    synchronized void finished(FrozenBufferedUpdates packet) {
        assert (packet.applied.getCount() == 1L) : "packet=" + String.valueOf(packet);
        packet.applied.countDown();
        this.updates.remove(packet);
        this.bytesUsed.addAndGet(-packet.bytesUsed);
        this.finishedSegment(packet.delGen());
    }

    long getCompletedDelGen() {
        return this.finishedSegments.getCompletedDelGen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitApplyForMerge(List<SegmentCommitInfo> mergeInfos, IndexWriter writer) throws IOException {
        long maxDelGen = Long.MIN_VALUE;
        for (SegmentCommitInfo info : mergeInfos) {
            maxDelGen = Math.max(maxDelGen, info.getBufferedDeletesGen());
        }
        HashSet<FrozenBufferedUpdates> waitFor = new HashSet<FrozenBufferedUpdates>();
        BufferedUpdatesStream bufferedUpdatesStream = this;
        synchronized (bufferedUpdatesStream) {
            for (FrozenBufferedUpdates packet : this.updates) {
                if (packet.delGen() > maxDelGen) continue;
                waitFor.add(packet);
            }
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "waitApplyForMerge: " + waitFor.size() + " packets, " + mergeInfos.size() + " merging segments");
        }
        this.waitApply(waitFor, writer);
    }

    private void waitApply(Set<FrozenBufferedUpdates> waitFor, IndexWriter writer) throws IOException {
        long startNS = System.nanoTime();
        int packetCount = waitFor.size();
        if (waitFor.isEmpty()) {
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "waitApply: no deletes to apply");
            }
            return;
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "waitApply: " + waitFor.size() + " packets: " + String.valueOf(waitFor));
        }
        ArrayList<FrozenBufferedUpdates> pendingPackets = new ArrayList<FrozenBufferedUpdates>();
        long totalDelCount = 0L;
        for (FrozenBufferedUpdates packet : waitFor) {
            if (!writer.tryApply(packet)) {
                pendingPackets.add(packet);
            }
            totalDelCount += packet.totalDelCount;
        }
        for (FrozenBufferedUpdates packet : pendingPackets) {
            writer.forceApply(packet);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", String.format(Locale.ROOT, "waitApply: done %d packets; totalDelCount=%d; totBytesUsed=%d; took %.2f msec", packetCount, totalDelCount, this.bytesUsed.get(), (double)(System.nanoTime() - startNS) / (double)TimeUnit.MILLISECONDS.toNanos(1L)));
        }
    }

    synchronized long getNextGen() {
        return this.nextGen++;
    }

    private boolean checkDeleteStats() {
        long bytesUsed2 = 0L;
        for (FrozenBufferedUpdates packet : this.updates) {
            bytesUsed2 += (long)packet.bytesUsed;
        }
        assert (bytesUsed2 == this.bytesUsed.get()) : "bytesUsed2=" + bytesUsed2 + " vs " + String.valueOf(this.bytesUsed);
        return true;
    }

    private static class FinishedSegments {
        private long completedDelGen;
        private final LongHashSet finishedDelGens = new LongHashSet();
        private final InfoStream infoStream;

        FinishedSegments(InfoStream infoStream) {
            this.infoStream = infoStream;
        }

        synchronized void clear() {
            this.finishedDelGens.clear();
            this.completedDelGen = 0L;
        }

        synchronized boolean stillRunning(long delGen) {
            return delGen > this.completedDelGen && !this.finishedDelGens.contains(delGen);
        }

        synchronized long getCompletedDelGen() {
            return this.completedDelGen;
        }

        synchronized void finishedSegment(long delGen) {
            this.finishedDelGens.add(delGen);
            while (this.finishedDelGens.contains(this.completedDelGen + 1L)) {
                this.finishedDelGens.remove(this.completedDelGen + 1L);
                ++this.completedDelGen;
            }
            if (this.infoStream.isEnabled("BD")) {
                this.infoStream.message("BD", "finished packet delGen=" + delGen + " now completedDelGen=" + this.completedDelGen);
            }
        }
    }

    static final class SegmentState
    implements Closeable {
        final long delGen;
        final ReadersAndUpdates rld;
        final SegmentReader reader;
        final int startDelCount;
        private final IOConsumer<ReadersAndUpdates> onClose;
        TermsEnum termsEnum;
        PostingsEnum postingsEnum;
        BytesRef term;

        SegmentState(ReadersAndUpdates rld, IOConsumer<ReadersAndUpdates> onClose, SegmentCommitInfo info) throws IOException {
            this.rld = rld;
            this.reader = rld.getReader(IOContext.DEFAULT);
            this.startDelCount = rld.getDelCount();
            this.delGen = info.getBufferedDeletesGen();
            this.onClose = onClose;
        }

        public String toString() {
            return "SegmentState(" + String.valueOf(this.rld.info) + ")";
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(() -> this.rld.release(this.reader), () -> this.onClose.accept(this.rld));
        }
    }

    record ApplyDeletesResult(boolean anyDeletes, List<SegmentCommitInfo> allDeleted) {
    }
}

