/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.log;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.eclipse.scout.sdk.core.log.FormattingTuple;

public final class MessageFormatter {
    public static final String ARG_REPLACE_PATTERN = "{}";

    private MessageFormatter() {
    }

    public static FormattingTuple arrayFormat(CharSequence msg, Object ... args) {
        int curIndex;
        int nextIndex;
        CharSequence rawMessage = msg;
        if (rawMessage == null) {
            rawMessage = "";
        }
        if (args == null || args.length == 0) {
            return new FormattingTuple(rawMessage.toString(), Collections.emptyList());
        }
        int lastPos = 0;
        StringBuilder messageBuilder = new StringBuilder(rawMessage);
        for (nextIndex = 0; (curIndex = messageBuilder.indexOf(ARG_REPLACE_PATTERN, lastPos)) >= 0 && nextIndex < args.length; ++nextIndex) {
            int endPos = curIndex + ARG_REPLACE_PATTERN.length();
            String replacement = MessageFormatter.toString(args[nextIndex]);
            messageBuilder.replace(curIndex, endPos, replacement);
            lastPos = curIndex + replacement.length();
        }
        return new FormattingTuple(messageBuilder.toString(), MessageFormatter.extractThrowables(nextIndex, args));
    }

    static List<Throwable> extractThrowables(int startIndex, Object ... args) {
        if (args == null || args.length <= startIndex) {
            return Collections.emptyList();
        }
        ArrayList<Throwable> result = new ArrayList<Throwable>(args.length - startIndex);
        for (int i = startIndex; i < args.length; ++i) {
            Object cur = args[i];
            MessageFormatter.searchForThrowables(cur, result);
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        return result;
    }

    static void searchForThrowables(Object o, Collection<Throwable> collector) {
        block4: {
            block5: {
                Object[] elements;
                block3: {
                    if (o == null) {
                        return;
                    }
                    if (!(o instanceof Throwable)) break block3;
                    collector.add((Throwable)o);
                    break block4;
                }
                if (!o.getClass().isArray()) break block5;
                for (Object element : elements = (Object[])o) {
                    MessageFormatter.searchForThrowables(element, collector);
                }
                break block4;
            }
            if (!(o instanceof Iterable)) break block4;
            Iterable it = (Iterable)o;
            for (Object element : it) {
                MessageFormatter.searchForThrowables(element, collector);
            }
        }
    }

    static String toString(Object o) {
        if (o == null || !o.getClass().isArray()) {
            return MessageFormatter.safeObjectToString(o);
        }
        Object[] arr = MessageFormatter.toObjectArray(o);
        if (arr.length < 1) {
            return "[]";
        }
        int maxSize = 100;
        int printSize = Math.min(arr.length, maxSize);
        StringBuilder b = new StringBuilder();
        b.append('[');
        b.append(MessageFormatter.toString(arr[0]));
        for (int i = 1; i < printSize; ++i) {
            b.append(", ");
            b.append(MessageFormatter.toString(arr[i]));
        }
        if (arr.length > maxSize) {
            b.append(",...");
        }
        b.append(']');
        return b.toString();
    }

    static Object[] toObjectArray(Object arr) {
        if (arr instanceof Object[]) {
            return (Object[])arr;
        }
        int len = Array.getLength(arr);
        return IntStream.range(0, len).mapToObj(i -> Array.get(arr, i)).toArray();
    }

    static String safeObjectToString(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            return o.toString();
        }
        catch (Throwable t) {
            System.err.println(MessageFormatter.class.getSimpleName() + ": Failed toString() invocation on an object of type [" + o.getClass().getName() + "]");
            t.printStackTrace();
            return "[FAILED toString() of " + String.valueOf(o.getClass()) + "]";
        }
    }
}

