/*******************************************************************************
 * Copyright (c) 2005, 2012 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.ui.tests.performance.views;

import junit.framework.Test;

import org.eclipse.test.OrderedTestSuite;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;

import org.eclipse.core.resources.ResourcesPlugin;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import org.eclipse.jdt.ui.tests.performance.JdtPerformanceTestCase;

public class PackageExplorerColdPerfTest extends JdtPerformanceTestCase {

	public static Test suite() {
		return new OrderedTestSuite(PackageExplorerColdPerfTest.class, new String[] {
			"testOpen"
		});
	}

	public PackageExplorerColdPerfTest(String name) {
		super(name);
	}

	public final void finishMeasurements() {
		stopMeasuring();
		commitMeasurements();
		Performance.getDefault().assertPerformanceInAbsoluteBand(fPerformanceMeter, Dimension.ELAPSED_PROCESS, 0, 80);
	}

	public final void startMeasuring() {
		super.startMeasuring();
	}

	public void testOpen() throws Exception {
		IWorkbenchWindow activeWorkbenchWindow= PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		IWorkbenchPage page= activeWorkbenchWindow.getActivePage();
		page.close();
		page= activeWorkbenchWindow.openPage("org.eclipse.ui.resourcePerspective", ResourcesPlugin.getWorkspace().getRoot());
		joinBackgroudActivities();
		MockupPackageExplorerPart.fgTest= this;
		page.showView("org.eclipse.jdt.ui.tests.MockPackageExplorer");
	}
}