/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import java.io.IOException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeErrorHandler;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.Automakefile;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMakefile;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMakefileDocumentProvider;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;

public class AutomakeDocumentProvider
extends TextFileDocumentProvider
implements IMakefileDocumentProvider {
    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new AutomakefileFileInfo();
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        IFileEditorInput input;
        IMakefile original = null;
        if (element instanceof IFileEditorInput) {
            input = (IFileEditorInput)element;
            if (input.getFile().exists()) {
                original = this.createMakefile(input.getFile().getLocation().toOSString());
            }
        } else if (element instanceof IURIEditorInput) {
            input = (IURIEditorInput)element;
            original = this.createMakefile(input.getURI().getPath().toString());
        }
        if (original == null) {
            return null;
        }
        TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
        if (!(info instanceof AutomakefileFileInfo)) {
            return null;
        }
        AutomakefileFileInfo makefileInfo = (AutomakefileFileInfo)info;
        this.setUpSynchronization(makefileInfo);
        makefileInfo.fCopy = original;
        return makefileInfo;
    }

    private IMakefile createMakefile(String fileName) {
        Automakefile makefile = null;
        Automakefile automakefile = new Automakefile();
        try {
            automakefile.parse(fileName);
        }
        catch (IOException iOException) {}
        makefile = automakefile;
        return makefile;
    }

    public IMakefile getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo instanceof AutomakefileFileInfo) {
            AutomakefileFileInfo info = (AutomakefileFileInfo)fileInfo;
            return info.fCopy;
        }
        return null;
    }

    public void shutdown() {
        Iterator e = this.getConnectedElementsIterator();
        while (e.hasNext()) {
            this.disconnect(e.next());
        }
    }

    public void connect(Object element) throws CoreException {
        super.connect(element);
        IMakefile makefile = this.getWorkingCopy(element);
        IDocument document = this.getDocument(element);
        AutomakeErrorHandler errorHandler = new AutomakeErrorHandler(document);
        errorHandler.update(makefile);
    }

    public IDocument getDocument(Object element) {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info != null) {
            return info.fTextFileBuffer.getDocument();
        }
        return this.getParentProvider().getDocument(element);
    }

    protected class AutomakefileFileInfo
    extends TextFileDocumentProvider.FileInfo {
        public IMakefile fCopy;

        protected AutomakefileFileInfo() {
        }
    }
}

