/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.dataengine;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.AbstractGroupedDataRowExpressionEvaluator;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultIterator;

public class GroupedRowExpressionsEvaluator
extends AbstractGroupedDataRowExpressionEvaluator {
    private static ILogger sLogger = Logger.getLogger((String)"org.eclipse.birt.chart.examples/trace");
    private IResultIterator fResultIterator;
    private boolean fIsGrouped = false;
    private int fGroupCount;
    private List[] faGroupBreaks;
    private int fCountOfAvaiableRows = 0;
    private boolean fHasAggregation = false;

    public GroupedRowExpressionsEvaluator(IResultIterator resultIterator, boolean hasAggregation) throws ChartException {
        this.fHasAggregation = hasAggregation;
        this.fResultIterator = resultIterator;
        List groupDefinitions = this.fResultIterator.getQueryResults().getPreparedQuery().getReportQueryDefn().getGroups();
        if (groupDefinitions != null && groupDefinitions.size() > 0) {
            this.fIsGrouped = true;
            this.fGroupCount = groupDefinitions.size();
            this.faGroupBreaks = new List[groupDefinitions.size()];
            int i = 0;
            while (i < this.faGroupBreaks.length) {
                this.faGroupBreaks[i] = new ArrayList();
                ++i;
            }
        }
    }

    private List getGroupBreaksList(int groupLevel) {
        if (this.faGroupBreaks == null || groupLevel < 0 || groupLevel > this.faGroupBreaks.length - 1) {
            return new ArrayList();
        }
        return this.faGroupBreaks[groupLevel];
    }

    public int[] getGroupBreaks(int groupLevel) {
        Object[] breaksArray = this.getGroupBreaksList(groupLevel).toArray();
        int[] breaks = new int[breaksArray.length];
        int i = 0;
        while (i < breaksArray.length) {
            breaks[i] = (Integer)breaksArray[i];
            ++i;
        }
        return breaks;
    }

    public void close() {
        try {
            this.fResultIterator.close();
        }
        catch (BirtException e) {
            sLogger.log((Exception)((Object)e));
        }
    }

    public Object evaluate(String expression) {
        try {
            return this.fResultIterator.getValue(expression);
        }
        catch (BirtException e) {
            sLogger.log((Exception)((Object)e));
            return null;
        }
    }

    public Object evaluateGlobal(String expression) {
        return this.evaluate(expression);
    }

    public boolean first() {
        block5: {
            this.fCountOfAvaiableRows = 0;
            if (this.fIsGrouped) break block5;
            if (this.fResultIterator.next()) {
                return true;
            }
        }
        try {
            if (this.findFirst()) {
                return true;
            }
        }
        catch (BirtException e) {
            sLogger.log((Exception)((Object)e));
        }
        return false;
    }

    private boolean findFirst() throws BirtException {
        if (!this.fResultIterator.next()) {
            return false;
        }
        int groupLevel = this.fResultIterator.getStartingGroupLevel();
        if (groupLevel == 0) {
            return true;
        }
        return this.findFirst();
    }

    private boolean findNext() throws BirtException {
        while (this.fResultIterator.next()) {
            int startIndex = this.fResultIterator.getStartingGroupLevel();
            if (startIndex > 0 && startIndex <= this.fGroupCount) {
                ++this.fCountOfAvaiableRows;
                this.getGroupBreaksList(startIndex - 1).add(new Integer(this.fCountOfAvaiableRows));
                int i = startIndex;
                while (i < this.fGroupCount) {
                    this.getGroupBreaksList(i).add(new Integer(this.fCountOfAvaiableRows));
                    ++i;
                }
                return true;
            }
            if (this.fHasAggregation) continue;
            ++this.fCountOfAvaiableRows;
            return true;
        }
        return false;
    }

    public boolean next() {
        block4: {
            if (this.fIsGrouped) break block4;
            if (this.fResultIterator.next()) {
                ++this.fCountOfAvaiableRows;
                return true;
            }
        }
        try {
            return this.findNext();
        }
        catch (BirtException e) {
            sLogger.log((Exception)((Object)e));
        }
        return false;
    }
}

