/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gcov.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.gcov.Activator;
import org.eclipse.linuxtools.gcov.dialog.OpenGCDialog;
import org.eclipse.linuxtools.gcov.view.CovView;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.PlatformUI;

public class OpenGCAction
implements IEditorLauncher {
    public void open(IPath file) {
        String msg;
        File gcda;
        File gcno;
        IPath file2;
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        String extension = file.getFileExtension();
        if ("gcno".equals(extension)) {
            file2 = file.removeFileExtension().addFileExtension("gcda");
            gcno = file.toFile();
            gcda = file2.toFile();
        } else if ("gcda".equals(extension)) {
            file2 = file.removeFileExtension().addFileExtension("gcno");
            gcda = file.toFile();
            gcno = file2.toFile();
        } else {
            return;
        }
        if (gcda == null || !gcda.isFile()) {
            msg = "File " + gcda + " does not exist.";
            msg = String.valueOf(msg) + "\nPlease run your application at least once.";
            MessageDialog.openError((Shell)shell, (String)"gcov Error", (String)msg);
            return;
        }
        if (gcno == null || !gcno.isFile()) {
            msg = "File " + gcno + " does not exist.";
            msg = String.valueOf(msg) + "\nPlease recompile your application.";
            MessageDialog.openError((Shell)shell, (String)"gcov Error", (String)msg);
            return;
        }
        String s = this.getDefaultBinary(file);
        OpenGCDialog d = new OpenGCDialog(shell, s, file);
        if (d.open() != 0) {
            return;
        }
        String binaryPath = d.getBinaryFile();
        if (d.isCompleteCoverageResultWanted()) {
            CovView.displayCovResults(binaryPath, gcda.getAbsolutePath());
        } else {
            CovView.displayCovDetailedResult(binaryPath, gcda.getAbsolutePath());
        }
    }

    private String getDefaultBinary(IPath file) {
        block9: {
            File gmonFile = file.toFile();
            File parent = gmonFile.getParentFile();
            File info = new File(parent, "AnalysisInfo.txt");
            IProject project = null;
            IFile ifile = null;
            try {
                ICProject cproject;
                if (info.exists()) {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(info.toString()));
                    while ((line = br.readLine()) != null) {
                        String[] tab = line.split("=");
                        String name = "";
                        String value = "";
                        if (tab.length <= 1) continue;
                        name = tab[0];
                        value = tab[1].trim();
                        if (name.equals("Project Name ")) {
                            project = ResourcesPlugin.getWorkspace().getRoot().getProject(value);
                            continue;
                        }
                        if (!name.equals("Program Name ") || project == null) continue;
                        ifile = project.getFile(value);
                        br.close();
                        if (!ifile.exists()) continue;
                        return ifile.getLocation().toString();
                    }
                    break block9;
                }
                IFile c = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
                if (c == null || (project = c.getProject()) == null || !project.exists() || (cproject = CoreModel.getDefault().create(project)) == null) break block9;
                try {
                    IBinary[] b = cproject.getBinaryContainer().getBinaries();
                    if (b != null && b.length > 0 && b[0] != null) {
                        IResource r = b[0].getResource();
                        return r.getLocation().toOSString();
                    }
                }
                catch (CModelException cModelException) {}
            }
            catch (FileNotFoundException e) {
                Status status = new Status(2, "org.eclipse.linuxtools.gcov", 2, e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.linuxtools.gcov", 4, e.getMessage(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return "";
    }
}

