/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.tracecontrol.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TargetResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.config.TraceConfig;
import org.eclipse.linuxtools.lttng.tracecontrol.service.ILttControllerService;
import org.eclipse.linuxtools.lttng.tracecontrol.service.LttControllerServiceProxy;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.dialogs.NewTraceDialog;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CreateNewTrace
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private TargetResource fSelectedTarget;
    private List<TargetResource> fSelectedFiles = new ArrayList<TargetResource>();
    private String fTraceName;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    protected TargetResource getFirstSelectedTarget() {
        if (this.fSelectedFiles.size() > 0) {
            return this.fSelectedFiles.get(0);
        }
        return null;
    }

    public void run(IAction action) {
        Shell shell = this.getShell();
        this.fSelectedTarget = this.getFirstSelectedTarget();
        TraceSubSystem subSystem = (TraceSubSystem)this.fSelectedTarget.getSubSystem();
        NewTraceDialog dialog = new NewTraceDialog(shell, subSystem, this.fSelectedTarget);
        TraceConfig traceConfig = dialog.open();
        if (traceConfig != null) {
            this.fTraceName = traceConfig.getTraceName();
            try {
                boolean ok;
                LttControllerServiceProxy service = subSystem.getControllerService();
                if (this.fSelectedTarget.isUst() && !(ok = this.setupUstLocation((ILttControllerService)service, this.fSelectedTarget, traceConfig))) {
                    return;
                }
                Boolean cfr_ignored_0 = (Boolean)new TCFTask<Boolean>((ILttControllerService)service, traceConfig){
                    private final /* synthetic */ ILttControllerService val$service;
                    private final /* synthetic */ TraceConfig val$traceConfig;
                    {
                        this.val$service = iLttControllerService;
                        this.val$traceConfig = traceConfig;
                    }

                    public void run() {
                        this.val$service.setupTrace(CreateNewTrace.this.fSelectedTarget.getParent().getName(), CreateNewTrace.this.fSelectedTarget.getName(), this.val$traceConfig.getTraceName(), new ILttControllerService.DoneSetupTrace(){

                            public void doneSetupTrace(IToken token, Exception error, Object str) {
                                if (error != null) {
                                    this.error(error);
                                    return;
                                }
                                this.done(true);
                            }
                        });
                    }
                }.get(10L, TimeUnit.SECONDS);
                this.setChannelEnable((ILttControllerService)service, this.fSelectedTarget, traceConfig, "all", true);
            }
            catch (Exception e) {
                SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(LTTngUiPlugin.getDefault().getMessage(e));
                SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorNewTrace) + " (" + Messages.Lttng_Resource_Trace + ": " + traceConfig.getTraceName() + ")"), (Throwable)sysExp);
                return;
            }
            TraceResource trace = new TraceResource(this.fSelectedTarget.getSubSystem());
            trace.setName(this.fTraceName);
            trace.setParent(this.fSelectedTarget);
            if (trace.isUst()) {
                trace.setTraceState(TraceResource.TraceState.STARTED);
            } else {
                trace.setTraceState(TraceResource.TraceState.CONFIGURED);
            }
            trace.setTraceConfig(traceConfig);
            this.fSelectedTarget.addTrace(trace);
            ISystemRegistry registry = SystemStartHere.getSystemRegistry();
            registry.fireRemoteResourceChangeEvent(1, (Object)trace, (Object)this.fSelectedTarget, (ISubSystem)subSystem, null);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelectedFiles.clear();
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof TargetResource)) continue;
                this.fSelectedFiles.add((TargetResource)obj);
            }
        }
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }

    private boolean setupUstLocation(final ILttControllerService service, final TargetResource targetResource, final TraceConfig traceConfig) throws Exception {
        if (traceConfig.isNetworkTrace()) {
            boolean success;
            File localDir = new File(traceConfig.getTracePath());
            if (!localDir.exists() && !(success = localDir.mkdirs())) {
                return false;
            }
            boolean ok = (Boolean)new TCFTask<Boolean>(){

                public void run() {
                    service.writeTraceNetwork(targetResource.getParent().getName(), targetResource.getName(), traceConfig.getTraceName(), traceConfig.getNumChannel(), Boolean.valueOf(traceConfig.getIsAppend()), Boolean.valueOf(traceConfig.getMode() == 1), Boolean.valueOf(traceConfig.getMode() == 2), new ILttControllerService.DoneWriteTraceNetwork(){

                        public void doneWriteTraceNetwork(IToken token, Exception error, Object str) {
                            if (error != null) {
                                this.error(error);
                                return;
                            }
                            this.done(true);
                        }
                    });
                }
            }.get(10L, TimeUnit.SECONDS);
            return ok;
        }
        boolean ok = (Boolean)new TCFTask<Boolean>(){

            public void run() {
                service.writeTraceLocal(targetResource.getParent().getName(), targetResource.getName(), traceConfig.getTraceName(), traceConfig.getTracePath(), traceConfig.getNumChannel(), Boolean.valueOf(traceConfig.getIsAppend()), Boolean.valueOf(traceConfig.getMode() == 2), Boolean.valueOf(traceConfig.getMode() == 1), new ILttControllerService.DoneWriteTraceLocal(){

                    public void doneWriteTraceLocal(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
        return ok;
    }

    private void setChannelEnable(final ILttControllerService service, final TargetResource targetResource, final TraceConfig traceConfig, final String channelName, final boolean enabled) throws Exception {
        new TCFTask<Boolean>(){

            public void run() {
                service.setChannelEnable(targetResource.getParent().getName(), targetResource.getName(), traceConfig.getTraceName(), channelName, Boolean.valueOf(enabled), new ILttControllerService.DoneSetChannelEnable(){

                    public void doneSetChannelEnable(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS);
    }
}

