/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.controlflow.model;

import org.eclipse.linuxtools.lttng.TraceDebug;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEventProcess;

class ProcessKey {
    private TimeRangeEventProcess valueRef = null;
    private Long pid = null;
    private Long cpuId = null;
    private String traceId = null;
    private Long creationtime = null;

    private ProcessKey() {
    }

    public ProcessKey(TimeRangeEventProcess newRef) {
        this.valueRef = newRef;
    }

    public ProcessKey(Long newPid, Long newCpuId, String newTraceId, Long newCreationTime) {
        this.pid = newPid;
        this.cpuId = newCpuId;
        this.traceId = newTraceId;
        this.creationtime = newCreationTime;
    }

    public boolean equals(Object obj) {
        boolean isSame = false;
        if (obj instanceof ProcessKey) {
            ProcessKey procKey = (ProcessKey)obj;
            if (this.valueRef != null) {
                if (procKey.getPid().equals(this.valueRef.getPid()) && procKey.getTraceId().equals(this.valueRef.getTraceID()) && procKey.getCreationtime().equals(this.valueRef.getCreationTime())) {
                    isSame = this.valueRef.getPid() != 0L || procKey.getCpuId().equals(this.valueRef.getCpu());
                }
            } else if (procKey.getPid().equals(this.pid) && procKey.getTraceId().equals(this.traceId) && procKey.getCreationtime().equals(this.creationtime)) {
                isSame = this.pid != 0L || procKey.getCpuId().equals(this.cpuId);
            }
        } else {
            TraceDebug.debug((String)("ERROR : The given key is not of the type ProcessKey!" + obj.getClass().toString()));
        }
        return isSame;
    }

    public Long getPid() {
        if (this.valueRef != null) {
            return this.valueRef.getPid();
        }
        return this.pid;
    }

    public Long getCpuId() {
        if (this.valueRef != null) {
            return this.valueRef.getCpu();
        }
        return this.cpuId;
    }

    public String getTraceId() {
        if (this.valueRef != null) {
            return this.valueRef.getTraceID();
        }
        return this.traceId;
    }

    public Long getCreationtime() {
        if (this.valueRef != null) {
            return this.valueRef.getCreationTime();
        }
        return this.creationtime;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.valueRef != null) {
            return String.valueOf(this.valueRef.getPid().toString()) + ":" + this.valueRef.getTraceID().toString() + ":" + this.valueRef.getCreationTime().toString();
        }
        return String.valueOf(this.pid.toString()) + ":" + this.traceId.toString() + ":" + this.creationtime.toString();
    }
}

