/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramContent;

public class HistogramSelectedWindow {
    private long timestampOfLeftPosition = 0L;
    private long timestampOfCenterPosition = 0L;
    private long timestampOfRightPosition = 0L;
    private long windowTimeWidth = 0L;
    private int windowXPositionLeft = 0;
    private int windowXPositionCenter = 0;
    private int windowXPositionRight = 0;
    private Boolean isSelectedWindowVisible = false;

    public HistogramSelectedWindow(HistogramContent newTraceContent, long timestampOfLeftPosition, long newWindowWidth) {
        if (newTraceContent != null) {
            this.setWindowTimeWidth(newWindowWidth);
            this.setTimestampOfLeftPosition(timestampOfLeftPosition);
            this.setTimestampOfRightPosition(timestampOfLeftPosition + newWindowWidth);
            this.setTimestampOfCenterPosition(timestampOfLeftPosition + newWindowWidth / 2L);
        }
    }

    public boolean getSelectedWindowVisible() {
        return this.isSelectedWindowVisible;
    }

    public void setSelectedWindowVisible(Boolean newIsSelectedWindowVisible) {
        this.isSelectedWindowVisible = newIsSelectedWindowVisible;
    }

    public long getWindowTimeWidth() {
        return this.windowTimeWidth;
    }

    public void setWindowTimeWidth(long newWindowTimeWidth) {
        this.windowTimeWidth = newWindowTimeWidth;
    }

    public long getTimestampOfLeftPosition() {
        return this.timestampOfLeftPosition;
    }

    public void setTimestampOfLeftPosition(long timestampOfLeftPosition) {
        this.timestampOfLeftPosition = timestampOfLeftPosition;
    }

    public long getTimestampOfCenterPosition() {
        return this.timestampOfCenterPosition;
    }

    public void setTimestampOfCenterPosition(long timestampOfCenterPosition) {
        this.timestampOfCenterPosition = timestampOfCenterPosition;
    }

    public void setTimestampOfLeftCenterRightPositions(long timestampOfCenterPosition) {
        this.timestampOfLeftPosition = timestampOfCenterPosition - this.windowTimeWidth / 2L;
        this.timestampOfCenterPosition = timestampOfCenterPosition;
        this.timestampOfRightPosition = timestampOfCenterPosition + this.windowTimeWidth / 2L;
    }

    public long getTimestampOfRightPosition() {
        return this.timestampOfRightPosition;
    }

    public void setTimestampOfRightPosition(long timestampOfRightPosition) {
        this.timestampOfRightPosition = timestampOfRightPosition;
    }

    public int getWindowXPositionLeft() {
        return this.windowXPositionLeft;
    }

    public void setWindowXPositionLeft(int windowXPositionLeft) {
        this.windowXPositionLeft = windowXPositionLeft;
    }

    public int getWindowXPositionCenter() {
        return this.windowXPositionCenter;
    }

    public void setWindowXPositionCenter(int windowXPositionCenter) {
        this.windowXPositionCenter = windowXPositionCenter;
    }

    public int getWindowXPositionRight() {
        return this.windowXPositionRight;
    }

    public void setWindowXPositionRight(int windowXPositionRight) {
        this.windowXPositionRight = windowXPositionRight;
    }
}

