/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.lttng.ui.views.project.model.ILTTngProjectTreeNode;

public abstract class LTTngProjectTreeNode
implements ILTTngProjectTreeNode {
    protected ILTTngProjectTreeNode fParent = null;
    protected List<ILTTngProjectTreeNode> fChildren = null;

    public LTTngProjectTreeNode(ILTTngProjectTreeNode parent) {
        this.fParent = parent;
        this.fChildren = new ArrayList<ILTTngProjectTreeNode>();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ILTTngProjectTreeNode getParent() {
        return this.fParent;
    }

    @Override
    public boolean hasChildren() {
        return this.fChildren.size() > 0;
    }

    @Override
    public List<ILTTngProjectTreeNode> getChildren() {
        return this.fChildren;
    }

    @Override
    public abstract void refreshChildren();

    @Override
    public void refresh() {
        this.fParent.refresh();
    }

    @Override
    public void removeChild(ILTTngProjectTreeNode child) {
        for (ILTTngProjectTreeNode node : this.fChildren) {
            if (node != child) continue;
            node.removeChildren();
            this.fChildren.remove(node);
            return;
        }
    }

    @Override
    public void removeChildren() {
        for (ILTTngProjectTreeNode node : this.fChildren) {
            node.removeChildren();
        }
        this.fChildren.clear();
    }
}

