/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.model;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.linuxtools.oprofile.core.model.OpModelSample;
import org.eclipse.linuxtools.oprofile.core.model.OpModelSymbol;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSample;
import org.eclipse.swt.graphics.Image;

public class UiModelSymbol
implements IUiModelElement {
    private IUiModelElement _parent;
    private OpModelSymbol _symbol;
    private UiModelSample[] _samples;
    private int _totalCount;

    public UiModelSymbol(IUiModelElement parent, OpModelSymbol symbol, int totalCount) {
        this._parent = parent;
        this._symbol = symbol;
        this._samples = null;
        this._totalCount = totalCount;
        this.refreshModel();
    }

    private void refreshModel() {
        ArrayList<UiModelSample> sampleList = new ArrayList<UiModelSample>();
        OpModelSample[] dataModelSamples = this._symbol.getSamples();
        int i = 0;
        while (i < dataModelSamples.length) {
            if (dataModelSamples[i].getLine() != 0) {
                sampleList.add(new UiModelSample(this, dataModelSamples[i], this._totalCount));
            }
            ++i;
        }
        this._samples = new UiModelSample[sampleList.size()];
        sampleList.toArray(this._samples);
    }

    public String toString() {
        double countPercentage = (double)this._symbol.getCount() / (double)this._totalCount;
        String percentage = OprofileUiPlugin.getPercentageString(countPercentage);
        String fileName = new File(this._symbol.getFile()).getName();
        return String.valueOf(percentage) + " " + OprofileUiMessages.getString("uimodel.percentage.in") + this._symbol.getName() + (fileName.length() == 0 ? "" : " [" + fileName + "]");
    }

    public String getFileName() {
        return this._symbol.getFile();
    }

    public String getFunctionName() {
        return this._symbol.getName();
    }

    public String getLabelText() {
        return this.toString();
    }

    public IUiModelElement[] getChildren() {
        return this._samples;
    }

    public boolean hasChildren() {
        return this._samples != null && this._samples.length != 0;
    }

    public IUiModelElement getParent() {
        return this._parent;
    }

    public Image getLabelImage() {
        return OprofileUiPlugin.getImageDescriptor("icons/symbol.gif").createImage();
    }
}

