/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.oprofile.ui.view;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.oprofile.core.Oprofile;
import org.eclipse.linuxtools.oprofile.ui.OprofileUiMessages;

class LogReader
implements Runnable,
IRunnableWithProgress {
    private static long _lastModified = -1L;
    private static String _contents = null;

    LogReader() {
    }

    public void run() {
        File logFile = new File(Oprofile.getLogFile());
        long modified = logFile.lastModified();
        if (modified != _lastModified) {
            _lastModified = modified;
            _contents = new String();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(logFile));
                while ((line = reader.readLine()) != null) {
                    _contents = String.valueOf(_contents) + line + "\n";
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                _contents = OprofileUiMessages.getString("oprofiled.logreader.error.fileNotFound");
            }
            catch (IOException iOException) {
                _lastModified = 0L;
                _contents = OprofileUiMessages.getString("oprofiled.logreader.error.io");
            }
        }
    }

    public String getLogContents() {
        return _contents;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.run();
    }
}

