/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui.propertypage;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.rpm.core.utils.RPMQuery;
import org.eclipse.linuxtools.rpm.ui.propertypage.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class InstallScriptsPage
extends PropertyPage {
    private static final String RPM_PRE_INSTALL = Messages.getString("InstallScriptsPage.PreinstallScript");
    private static final String RPM_POST_INSTALL = Messages.getString("InstallScriptsPage.PostinstallScript");
    private static final String RPM_PRE_UNINSTALL = Messages.getString("InstallScriptsPage.PreuninstallScript");
    private static final String RPM_POST_UNINSTALL = Messages.getString("InstallScriptsPage.PostuninstallScript");
    private static final int SCRIPT_ENTRIES_FIELD_WIDTH = 80;
    private static final int SCRIPT_ENTRIES_FIELD_HEIGHT = 20;
    private Text rpm_PreInstallText;
    private Text rpm_PostInstallText;
    private Text rpm_PreUnInstallText;
    private Text rpm_PostUnInstallText;

    private void addScriptFields(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label rpmPreInstallLabel = new Label(composite, 0);
        rpmPreInstallLabel.setText(RPM_PRE_INSTALL);
        this.rpm_PreInstallText = new Text(composite, 2634);
        GridData gdPreInst = new GridData();
        gdPreInst.widthHint = this.convertWidthInCharsToPixels(80);
        gdPreInst.heightHint = this.convertWidthInCharsToPixels(20);
        this.rpm_PreInstallText.setLayoutData((Object)gdPreInst);
        Label rpmPostInstallLabel = new Label(composite, 0);
        rpmPostInstallLabel.setText(RPM_POST_INSTALL);
        this.rpm_PostInstallText = new Text(composite, 2634);
        GridData gdPostInst = new GridData();
        gdPostInst.widthHint = this.convertWidthInCharsToPixels(80);
        gdPostInst.heightHint = this.convertWidthInCharsToPixels(20);
        this.rpm_PostInstallText.setLayoutData((Object)gdPostInst);
        Label rpmPreUnInstallLabel = new Label(composite, 0);
        rpmPreUnInstallLabel.setText(RPM_PRE_UNINSTALL);
        this.rpm_PreUnInstallText = new Text(composite, 2634);
        GridData gdPreUnInst = new GridData();
        gdPreUnInst.widthHint = this.convertWidthInCharsToPixels(80);
        gdPreUnInst.heightHint = this.convertWidthInCharsToPixels(20);
        this.rpm_PreUnInstallText.setLayoutData((Object)gdPreUnInst);
        Label rpmPostUnInstallLabel = new Label(composite, 0);
        rpmPostUnInstallLabel.setText(RPM_POST_UNINSTALL);
        this.rpm_PostUnInstallText = new Text(composite, 2634);
        GridData gdPostUnInst = new GridData();
        gdPostUnInst.widthHint = this.convertWidthInCharsToPixels(80);
        gdPostUnInst.heightHint = this.convertWidthInCharsToPixels(20);
        this.rpm_PostUnInstallText.setLayoutData((Object)gdPostUnInst);
        try {
            IFile rpmFile = (IFile)this.getElement();
            String rpm_PreInstall = RPMQuery.getPreInstallScript((IFile)rpmFile);
            this.rpm_PreInstallText.setText(rpm_PreInstall);
            String rpm_PostInstall = RPMQuery.getPostInstallScript((IFile)rpmFile);
            this.rpm_PostInstallText.setText(rpm_PostInstall);
            String rpm_PreUnInstall = RPMQuery.getPreUninstallScript((IFile)rpmFile);
            this.rpm_PreUnInstallText.setText(rpm_PreUnInstall);
            String rpm_PostUnInstall = RPMQuery.getPostUninstallScript((IFile)rpmFile);
            this.rpm_PostUnInstallText.setText(rpm_PostUnInstall);
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(new StatusAdapter(e.getStatus()), 3);
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addScriptFields(composite);
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }
}

