/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.events;

import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentDisposedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.swt.widgets.Composite;

public class TmfEventsView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.events";
    private TmfExperiment<TmfEvent> fExperiment;
    private TmfEventsTable fEventsTable;
    private static final int DEFAULT_CACHE_SIZE = 100;
    private final int fCacheSize;
    private String fTitlePrefix;

    public TmfEventsView(int cacheSize) {
        super("TmfEventsView");
        this.fCacheSize = cacheSize;
    }

    public TmfEventsView() {
        this(100);
    }

    @Override
    public void createPartControl(Composite parent) {
        this.fEventsTable = this.createEventsTable(parent, this.fCacheSize);
        this.fTitlePrefix = this.getTitle();
        this.fExperiment = TmfExperiment.getCurrentExperiment();
        if (this.fExperiment != null) {
            this.experimentSelected((TmfExperimentSelectedSignal<TmfEvent>)new TmfExperimentSelectedSignal((Object)this.fEventsTable, this.fExperiment));
        }
    }

    @Override
    public void dispose() {
        if (this.fEventsTable != null) {
            this.fEventsTable.dispose();
        }
        super.dispose();
    }

    protected TmfEventsTable createEventsTable(Composite parent, int cacheSize) {
        return new TmfEventsTable(parent, cacheSize);
    }

    @Override
    public void setFocus() {
        this.fEventsTable.setFocus();
    }

    public String toString() {
        return "[TmfEventsView]";
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<TmfEvent> signal) {
        TmfExperiment exp = signal.getExperiment();
        if (!exp.equals(this.fExperiment)) {
            this.fExperiment = exp;
            this.setPartName(String.valueOf(this.fTitlePrefix) + " - " + this.fExperiment.getName());
            if (this.fEventsTable != null) {
                this.fEventsTable.setTrace((ITmfTrace)this.fExperiment, false);
            }
        }
    }

    @TmfSignalHandler
    public void experimentDisposed(TmfExperimentDisposedSignal<TmfEvent> signal) {
        TmfExperiment experiment = signal.getExperiment();
        if (experiment.equals(this.fExperiment)) {
            this.fEventsTable.setTrace(null, false);
        }
        TmfUiPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TmfEventsView.this.setPartName(TmfEventsView.this.fTitlePrefix);
            }
        });
    }
}

