/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.core;

import java.util.Comparator;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.AsyncMessageReturn;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.BaseMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.ITimeRange;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Metrics;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.drawings.IGC;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SortAsyncForBackward;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SortAsyncMessageComparator;

public class AsyncMessage
extends BaseMessage
implements ITimeRange {
    protected boolean hasTime = false;
    protected TmfTimestamp endTime = new TmfTimestamp();
    protected TmfTimestamp startTime = new TmfTimestamp();
    protected AsyncMessageReturn messageReturn = null;
    public static final String ASYNC_MESS_TAG = "AsyncMessage";

    public AsyncMessage() {
        this.prefId = "PREF_ASYNC_MESS";
    }

    @Override
    public int getX() {
        int x = super.getX(true);
        int activationWidth = 4;
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline.getX() > this.endLifeline.getX()) {
            activationWidth = -activationWidth;
        }
        if (this.isMessageStartInActivation(this.startEventOccurrence)) {
            x += activationWidth;
        }
        return x;
    }

    @Override
    public int getY() {
        if (this.startLifeline != null && this.endLifeline != null) {
            return this.endLifeline.getY() + this.endLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.startEventOccurrence;
        }
        return super.getY();
    }

    @Override
    public int getWidth() {
        int width = super.getWidth(true);
        int activationWidth = 4;
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline.getX() > this.endLifeline.getX()) {
            activationWidth = -activationWidth;
        }
        if (this.isMessageStartInActivation(this.startEventOccurrence)) {
            width -= activationWidth;
        }
        if (this.isMessageEndInActivation(this.endEventOccurrence)) {
            width -= activationWidth;
        }
        return width;
    }

    @Override
    public int getHeight() {
        if (this.startLifeline != null && this.endLifeline != null) {
            return this.endLifeline.getY() + this.endLifeline.getHeight() + (Metrics.getMessageFontHeigth() + Metrics.getMessagesSpacing()) * this.endEventOccurrence - this.getY();
        }
        return super.getHeight();
    }

    protected void setMessageReturn(AsyncMessageReturn message) {
        this.messageReturn = message;
    }

    public void setEndOccurrence(int occurrence) {
        this.endEventOccurrence = occurrence;
        if (this.getStartLifeline() == null) {
            this.startEventOccurrence = occurrence;
        }
        this.informFrame(this.getEndLifeline(), occurrence);
    }

    protected void informFrame(Lifeline lifeLine, int occurrence) {
        if (lifeLine != null && lifeLine.getFrame() != null && lifeLine.getFrame().getMaxEventOccurrence() < occurrence) {
            lifeLine.getFrame().setMaxEventOccurrence(occurrence);
        }
    }

    public void setStartOccurrence(int occurrence) {
        this.startEventOccurrence = occurrence;
        if (this.getEndLifeline() == null) {
            this.endEventOccurrence = this.startEventOccurrence;
        }
        this.informFrame(this.getStartLifeline(), occurrence);
    }

    public void autoSetStartLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setStartLifeline(lifeline);
    }

    public void autoSetEndLifeline(Lifeline lifeline) {
        lifeline.getNewEventOccurrence();
        this.setEndLifeline(lifeline);
    }

    @Override
    public void setStartLifeline(Lifeline lifeline) {
        super.setStartLifeline(lifeline);
        this.setStartOccurrence(this.getStartLifeline().getEventOccurrence());
        if (this.getEndLifeline() == null) {
            this.endEventOccurrence = this.startEventOccurrence;
        }
    }

    @Override
    public void setEndLifeline(Lifeline lifeline) {
        super.setEndLifeline(lifeline);
        this.setEventOccurrence(this.getEndLifeline().getEventOccurrence());
    }

    protected boolean isNearSegment(int xA, int yA, int xB, int yB, int xC, int yC) {
        if (xA > xB && xC > xA) {
            return false;
        }
        if (xA < xB && xC > xB) {
            return false;
        }
        if (xA < xB && xC < xA) {
            return false;
        }
        if (xA > xB && xC < xB) {
            return false;
        }
        double distAB = Math.sqrt((xB - xA) * (xB - xA) + (yB - yA) * (yB - yA));
        double scalar = (double)((xB - xA) * (xC - xA) + (yB - yA) * (yC - yA)) / distAB;
        double distAC = Math.sqrt((xC - xA) * (xC - xA) + (yC - yA) * (yC - yA));
        double distToSegment = Math.sqrt(Math.abs(distAC * distAC - scalar * scalar));
        return distToSegment <= 30.0;
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.startLifeline == this.endLifeline) {
            return super.contains(x, y);
        }
        if (this.isNearSegment(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), x, y)) {
            return true;
        }
        int messageMaxWidth = Metrics.swimmingLaneWidth() - 8;
        int nameWidth = this.getName().length() * Metrics.getAverageCharWidth();
        return this.getName().length() * Metrics.getAverageCharWidth() > messageMaxWidth ? Frame.contains(this.getX(), this.getY() - 10 - Metrics.getMessageFontHeigth(), messageMaxWidth, Metrics.getMessageFontHeigth(), x, y) : Frame.contains(this.getX() + (messageMaxWidth - nameWidth) / 2, this.getY() + this.getHeight() / 2 - 10 - Metrics.getMessageFontHeigth(), nameWidth, Metrics.getMessageFontHeigth(), x, y);
    }

    protected void drawAsyncMessage(IGC context) {
        if (this.startLifeline != null && this.endLifeline != null && this.startLifeline == this.endLifeline && this.startEventOccurrence != this.endEventOccurrence) {
            int x = this.getX();
            int y = this.getY();
            int height = this.getHeight();
            int tempx = 0;
            boolean startInActivation = this.isMessageStartInActivation(this.startEventOccurrence);
            boolean endInActivation = this.isMessageEndInActivation(this.endEventOccurrence);
            if (endInActivation && !startInActivation) {
                tempx = 4;
            }
            if (startInActivation && !endInActivation) {
                tempx = -4;
            }
            int tempy = 10;
            if (this.getHeight() <= 20) {
                tempy = this.getHeight() / 2;
            }
            context.drawLine(x, y, x + 10, y);
            context.drawLine(x + 20, y + tempy, x + 20, y + height - tempy);
            context.drawLine(x + tempx, y + height, x + 10, y + height);
            Double xt = new Double(Math.cos(0.75) * 7.0);
            Double yt = new Double(Math.sin(0.75) * 7.0);
            context.drawLine(x + xt.intValue() + tempx, y + height + yt.intValue(), x + tempx, y + height);
            context.drawArc(x, y, 20, 2 * tempy, 0, 90);
            context.drawArc(x, y + height, 20, -2 * tempy, 0, -90);
            context.drawLine(x + xt.intValue() + tempx, y + height - yt.intValue(), x + tempx, y + height);
            context.drawTextTruncated(this.getName(), x + 20 + 10, y, Metrics.swimmingLaneWidth() - 8 + -20, 10 - Metrics.getMessageFontHeigth(), !this.isSelected());
        } else {
            super.draw(context);
        }
    }

    @Override
    public void draw(IGC context) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isSelected() && this.startLifeline != null && this.endLifeline != null && this.startLifeline == this.endLifeline && this.startEventOccurrence != this.endEventOccurrence) {
            context.setForeground(Frame.getUserPref().getBackGroundColorSelection());
            context.setLineWidth(5);
            this.drawAsyncMessage(context);
            context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
            context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
        } else {
            context.setBackground(Frame.getUserPref().getBackGroundColor(this.prefId));
            context.setForeground(Frame.getUserPref().getForeGroundColor(this.prefId));
        }
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(true);
        }
        context.setLineWidth(1);
        this.drawAsyncMessage(context);
        if (this.hasFocus()) {
            context.setDrawTextWithFocusStyle(false);
        }
    }

    public void setEndTime(TmfTimestamp time) {
        this.endTime = time.clone();
        this.hasTime = true;
        if (this.getStartLifeline() != null && this.getStartLifeline().getFrame() != null) {
            this.getStartLifeline().getFrame().setHasTimeInfo(true);
        } else if (this.getEndLifeline() != null && this.getEndLifeline().getFrame() != null) {
            this.getEndLifeline().getFrame().setHasTimeInfo(true);
        }
    }

    public void setStartTime(TmfTimestamp time) {
        this.startTime = time.clone();
        this.hasTime = true;
        if (this.getStartLifeline() != null && this.getStartLifeline().getFrame() != null) {
            this.getStartLifeline().getFrame().setHasTimeInfo(true);
        } else if (this.getEndLifeline() != null && this.getEndLifeline().getFrame() != null) {
            this.getEndLifeline().getFrame().setHasTimeInfo(true);
        }
    }

    @Override
    public TmfTimestamp getEndTime() {
        return this.endTime;
    }

    @Override
    public TmfTimestamp getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean hasTimeInfo() {
        return this.hasTime;
    }

    @Override
    public boolean isVisible(int x, int y, int width, int height) {
        int toDrawY = this.getY();
        int toDrawHeight = this.getHeight();
        if (toDrawY > y + height + 10 + Metrics.getMessageFontHeigth() && toDrawY + toDrawHeight > y + height + 10 + Metrics.getMessageFontHeigth()) {
            return false;
        }
        if (toDrawY < y && toDrawY + toDrawHeight < y) {
            return false;
        }
        return super.isVisible(x, y, width, height);
    }

    @Override
    public Comparator<GraphNode> getComparator() {
        return new SortAsyncMessageComparator();
    }

    @Override
    public String getArrayId() {
        return ASYNC_MESS_TAG;
    }

    @Override
    public Comparator<GraphNode> getBackComparator() {
        return new SortAsyncForBackward();
    }

    @Override
    public boolean positiveDistanceToPoint(int x, int y) {
        int mY = this.getY();
        int mH = this.getHeight();
        return mY > y || mY + mH > y;
    }
}

