/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.actions;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.dataviewers.charts.Activator;
import org.eclipse.linuxtools.dataviewers.charts.ChartConstants;
import org.eclipse.linuxtools.dataviewers.charts.view.ChartView;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SaveChartAction
extends Action {
    private FileDialog dialog;
    private Shell shell;
    private Chart cm;
    private IDeviceRenderer idr;
    private Bounds bo;
    private ChartView chartView;

    public SaveChartAction(Shell shell, ChartView cview) {
        super("Save chart as...", Activator.getImageDescriptor("icons/save_chart.gif"));
        this.chartView = cview;
        this.setEnabled(false);
        this.shell = shell;
        this.dialog = new FileDialog(shell, 8192);
        this.dialog.setFileName(".");
        this.dialog.setFilterPath(".");
        this.dialog.setFilterExtensions(ChartConstants.saveAsImageExt);
        this.dialog.setFilterNames(ChartConstants.saveAsImageExtNames);
        this.dialog.setText("Select an image file (extension will be set to \".jpeg\" if not recognized).");
        this.restoreState();
    }

    public void setChart(Chart chart) {
        try {
            if (chart != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.cm = chart;
        }
        catch (Throwable _) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, "Error when creating \"save as image\" action...", _);
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }

    public void setBounds(Bounds bo) {
        this.bo = bo;
    }

    public void run() {
        String path = this.dialog.open();
        if (path == null) {
            return;
        }
        String ext = "";
        int dotIdx = path.lastIndexOf(".");
        if (dotIdx > 0) {
            ext = path.substring(dotIdx);
        }
        try {
            if (ext.equals(".gif")) {
                this.idr = PluginSettings.instance().getDevice("dv.GIF");
            } else if (ext.equals(".jpeg")) {
                this.idr = PluginSettings.instance().getDevice("dv.JPEG");
            } else if (ext.equals(".jpg")) {
                this.idr = PluginSettings.instance().getDevice("dv.JPG");
            } else if (ext.equals(".png")) {
                this.idr = PluginSettings.instance().getDevice("dv.PNG");
            } else {
                path = String.valueOf(path) + ".jpeg";
                this.idr = PluginSettings.instance().getDevice("dv.JPG");
            }
        }
        catch (ChartException e) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)s);
        }
        final File file = new File(path);
        if (file.exists()) {
            boolean overwrite = MessageDialog.openQuestion((Shell)this.shell, (String)"Confirm overwrite", (String)"File already exists. Overwrite?");
            if (overwrite) {
                file.delete();
            } else {
                return;
            }
        }
        Job saveAsImage = new Job("Save chart as " + file.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask("Saving chart as " + file.getName() + "...", -1);
                    file.createNewFile();
                    SaveChartAction.this.generateImageFile(file);
                    return Status.OK_STATUS;
                }
                catch (IOException e) {
                    return new Status(4, "org.eclipse.linuxtools.dataviewers.charts", "Error saving chart to \"" + file.getAbsolutePath() + "\":" + e.getMessage(), (Throwable)e);
                }
            }
        };
        saveAsImage.setUser(true);
        saveAsImage.schedule();
        this.saveState();
    }

    public void restoreState() {
        try {
            IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("birtcharts_saveasimg_section");
            if (settings == null) {
                settings = Activator.getDefault().getDialogSettings().addNewSection("birtcharts_saveasimg_section");
                return;
            }
            this.dialog.setFileName(settings.get("IMG_FILE_NAME"));
            this.dialog.setFilterPath(settings.get("IMG_FILTER_PATH"));
        }
        catch (Exception e) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }

    public void saveState() {
        try {
            IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("birtcharts_saveasimg_section");
            if (settings == null) {
                settings = Activator.getDefault().getDialogSettings().addNewSection("birtcharts_saveasimg_section");
            }
            settings.put("IMG_FILE_NAME", this.dialog.getFileName());
            settings.put("IMG_FILTER_PATH", this.dialog.getFilterPath());
        }
        catch (Exception e) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }

    protected void generateImageFile(File file) {
        Status s;
        RunTimeContext rtc = new RunTimeContext();
        rtc.setULocale(ULocale.getDefault());
        Generator gr = Generator.instance();
        GeneratedChartState gcs = null;
        Bounds boFile = null;
        this.bo = this.chartView.getChartViewer().getBounds();
        boFile = this.bo != null ? BoundsImpl.create((double)this.bo.getLeft(), (double)this.bo.getTop(), (double)this.bo.getWidth(), (double)this.bo.getHeight()) : BoundsImpl.create((double)0.0, (double)0.0, (double)800.0, (double)600.0);
        try {
            gcs = gr.build(this.idr.getDisplayServer(), this.cm, boFile, null, rtc, null);
        }
        catch (ChartException e) {
            s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)s);
        }
        this.idr.setProperty("device.file.identifier", (Object)file.getAbsolutePath());
        try {
            gr.render(this.idr, gcs);
        }
        catch (ChartException e) {
            s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }
}

