/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.connectorservice;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.ILttControllerService;
import org.eclipse.linuxtools.internal.lttng.core.tracecontrol.service.LttControllerServiceProxy;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.linuxtools.internal.lttng.ui.tracecontrol.utility.DownloadProxy;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.subsystems.StandardConnectorService;
import org.eclipse.tm.tcf.core.AbstractPeer;
import org.eclipse.tm.tcf.protocol.IChannel;
import org.eclipse.tm.tcf.protocol.IPeer;
import org.eclipse.tm.tcf.protocol.IService;
import org.eclipse.tm.tcf.protocol.Protocol;
import org.eclipse.tm.tcf.services.ILocator;

public class TraceConnectorService
extends StandardConnectorService {
    private static final int INVOCATION_TIMEOUT = 1000;
    private boolean fIsConnected = false;
    private IChannel fChannel;
    private Throwable fChannelError;
    private final List<Runnable> fWaitList = new ArrayList<Runnable>();
    private boolean fPollTimerStarted;
    private DownloadProxy fDownloadProxy = null;

    public TraceConnectorService(IHost host, int port) {
        super(Messages.Trace_Connector_Service_Name, Messages.Trace_Connector_Service_Description, host, port);
    }

    public boolean isConnected() {
        return this.fIsConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalConnect(final IProgressMonitor monitor) throws Exception {
        assert (!Protocol.isDispatchThread());
        final Exception[] res = new Exception[1];
        this.fireCommunicationsEvent(1);
        monitor.beginTask(String.valueOf(Messages.Trace_Connector_Service_Connect_Msg) + " " + this.getHostName(), 1);
        Exception[] exceptionArray = res;
        synchronized (res) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!TraceConnectorService.this.connectTCFChannel(res, monitor)) {
                        TraceConnectorService.this.add_to_wait_list(this);
                    }
                }
            });
            res.wait();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            monitor.done();
            if (res[0] != null) {
                throw res[0];
            }
            this.fIsConnected = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalDisconnect(final IProgressMonitor monitor) throws Exception {
        assert (!Protocol.isDispatchThread());
        final Exception[] res = new Exception[1];
        this.fireCommunicationsEvent(3);
        monitor.beginTask(String.valueOf(Messages.Trace_Connector_Service_Disconnect_Msg) + " " + this.getHostName(), 1);
        Exception[] exceptionArray = res;
        synchronized (res) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!TraceConnectorService.this.disconnectTCFChannel(res, monitor)) {
                        TraceConnectorService.this.add_to_wait_list(this);
                    }
                }
            });
            res.wait();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            monitor.done();
            if (res[0] != null) {
                throw res[0];
            }
            this.fIsConnected = false;
            return;
        }
    }

    public boolean supportsRemoteServerLaunching() {
        return false;
    }

    public boolean supportsServerLaunchProperties() {
        return false;
    }

    private void add_to_wait_list(Runnable cb) {
        this.fWaitList.add(cb);
        if (this.fPollTimerStarted) {
            return;
        }
        Protocol.invokeLater((long)1000L, (Runnable)new Runnable(){

            @Override
            public void run() {
                TraceConnectorService.this.fPollTimerStarted = false;
                TraceConnectorService.this.run_wait_list();
            }
        });
        this.fPollTimerStarted = true;
    }

    private void run_wait_list() {
        if (this.fWaitList.isEmpty()) {
            return;
        }
        Runnable[] runnables = this.fWaitList.toArray(new Runnable[this.fWaitList.size()]);
        this.fWaitList.clear();
        int i = 0;
        while (i < runnables.length) {
            runnables[i].run();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectTCFChannel(Exception[] res, IProgressMonitor monitor) {
        if (this.fChannel != null) {
            switch (this.fChannel.getState()) {
                case 1: 
                case 2: {
                    Exception[] exceptionArray = res;
                    synchronized (res) {
                        res[0] = this.fChannelError instanceof Exception ? (Exception)this.fChannelError : (this.fChannelError != null ? new Exception(this.fChannelError) : null);
                        res.notifyAll();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return true;
                    }
                }
            }
        }
        if (monitor.isCanceled()) {
            Exception[] exceptionArray = res;
            synchronized (res) {
                res[0] = new Exception(Messages.Trace_Connector_Service_Canceled_Msg);
                if (this.fChannel != null) {
                    this.fChannel.terminate((Throwable)res[0]);
                }
                res.notifyAll();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return true;
            }
        }
        if (this.fChannel == null) {
            String host = this.getHostName().toLowerCase();
            int port = this.getConnectPort();
            if (port <= 0) {
                port = 1534;
            }
            IPeer peer = null;
            String port_str = Integer.toString(port);
            ILocator locator = Protocol.getLocator();
            for (IPeer p : locator.getPeers().values()) {
                Map attrs = p.getAttributes();
                if (!"TCP".equals(attrs.get("TransportName")) || !host.equalsIgnoreCase((String)attrs.get("Host")) || !port_str.equals(attrs.get("Port"))) continue;
                peer = p;
                break;
            }
            if (peer == null) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("ID", "RSE:" + host + ":" + port_str);
                attrs.put("Name", this.getName());
                attrs.put("TransportName", "TCP");
                attrs.put("Host", host);
                attrs.put("Port", port_str);
                peer = new AbstractPeer(attrs);
            }
            this.fChannel = peer.openChannel();
            this.fChannel.addChannelListener(new IChannel.IChannelListener(){

                public void onChannelOpened() {
                    if (!$assertionsDisabled && TraceConnectorService.this.fChannel == null) {
                        throw new AssertionError();
                    }
                    if (TraceConnectorService.this.fChannel.getRemoteService("ltt_control") == null) {
                        return;
                    }
                    LttControllerServiceProxy controllerService = new LttControllerServiceProxy(TraceConnectorService.this.fChannel);
                    TraceConnectorService.this.fChannel.setServiceProxy(ILttControllerService.class, (IService)controllerService);
                    ISubSystem[] subSystems = TraceConnectorService.this.getSubSystems();
                    int i = 0;
                    while (i < subSystems.length) {
                        if (subSystems[i] instanceof TraceSubSystem) {
                            TraceConnectorService.this.fDownloadProxy = new DownloadProxy((TraceSubSystem)subSystems[i]);
                        }
                        ++i;
                    }
                    IChannel.IEventListener listener = new IChannel.IEventListener(){

                        public void event(String name, byte[] data) {
                            if (TraceConnectorService.this.fDownloadProxy != null) {
                                if (name.compareTo("new_trace_data") == 0) {
                                    TraceConnectorService.this.fDownloadProxy.writeDownloadedTrace(data);
                                } else if (name.compareTo("unwrite_trace_data") != 0) {
                                    if (name.compareTo("trace_done") == 0) {
                                        TraceConnectorService.this.fDownloadProxy.handleTraceDoneEvent(data);
                                    } else {
                                        try {
                                            throw new IOException("ltt_control: " + Messages.Lttng_Control_Unknown_Event_Msg + ": " + name);
                                        }
                                        catch (IOException e) {
                                            SystemBasePlugin.logError((String)"TraceConnectorService", (Throwable)e);
                                        }
                                    }
                                }
                            }
                        }
                    };
                    TraceConnectorService.this.fChannel.addEventListener((IService)controllerService, listener);
                    TraceConnectorService.this.run_wait_list();
                }

                public void congestionLevel(int level) {
                }

                public void onChannelClosed(Throwable error) {
                    if (!$assertionsDisabled && TraceConnectorService.this.fChannel == null) {
                        throw new AssertionError();
                    }
                    TraceConnectorService.this.fChannel.removeChannelListener((IChannel.IChannelListener)this);
                    TraceConnectorService.this.fChannelError = error;
                    if (TraceConnectorService.this.fWaitList.isEmpty()) {
                        TraceConnectorService.this.fireCommunicationsEvent(5);
                    } else {
                        TraceConnectorService.this.run_wait_list();
                    }
                    TraceConnectorService.this.fChannel = null;
                    TraceConnectorService.this.fChannelError = null;
                }
            });
            assert (this.fChannel.getState() == 0);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disconnectTCFChannel(Exception[] res, IProgressMonitor monitor) {
        if (this.fChannel == null || this.fChannel.getState() == 2) {
            Exception[] exceptionArray = res;
            synchronized (res) {
                res[0] = null;
                res.notifyAll();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
        }
        if (monitor.isCanceled()) {
            Exception[] exceptionArray = res;
            synchronized (res) {
                res[0] = new Exception("Canceled");
                res.notifyAll();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return true;
            }
        }
        if (this.fChannel.getState() == 1) {
            this.fChannel.close();
        }
        return false;
    }

    public <V extends IService> V getService(Class<V> service_interface) throws Exception {
        if (this.fChannel == null || this.fChannel.getState() != 1) {
            throw new Exception(String.valueOf(Messages.Ltt_Controller_Service_Not_Connected_Msg) + ": " + service_interface.getName());
        }
        IService service = this.fChannel.getRemoteService(service_interface);
        if (service == null) {
            throw new Exception(String.valueOf(Messages.Ltt_Controller_Service_Unsupported_Msg) + ": " + service_interface.getName());
        }
        return (V)service;
    }

    public LttControllerServiceProxy getControllerService() throws Exception {
        return (LttControllerServiceProxy)this.getService(ILttControllerService.class);
    }
}

