/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.parsers.custom;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomEventContent;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtEvent;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtEventType;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTraceContext;
import org.eclipse.linuxtools.internal.tmf.ui.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfEventType;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;
import org.eclipse.linuxtools.tmf.core.trace.TmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;

public class CustomTxtTrace
extends TmfTrace<CustomTxtEvent>
implements ITmfEventParser<CustomTxtEvent> {
    private static final TmfLocation<Long> NULL_LOCATION = new TmfLocation(null);
    private static final int DEFAULT_CACHE_SIZE = 100;
    private final CustomTxtTraceDefinition fDefinition;
    private final CustomTxtEventType fEventType;

    public CustomTxtTrace(CustomTxtTraceDefinition definition) {
        this.fDefinition = definition;
        this.fEventType = new CustomTxtEventType(this.fDefinition);
    }

    public CustomTxtTrace(IResource resource, CustomTxtTraceDefinition definition, String path, int pageSize) throws TmfTraceException {
        super(resource, CustomTxtEvent.class, path, pageSize > 0 ? pageSize : 100);
        this.fDefinition = definition;
        this.fEventType = new CustomTxtEventType(this.fDefinition);
    }

    public void initTrace(IResource resource, String path, Class<CustomTxtEvent> eventType) throws TmfTraceException {
        super.initTrace(resource, path, eventType);
    }

    /*
     * Exception decompiling
     */
    public TmfContext seekEvent(ITmfLocation<?> location) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    public TmfContext seekEvent(double ratio) {
        TmfContext tmfContext;
        BufferedRandomAccessFile raFile;
        block16: {
            raFile = null;
            raFile = new BufferedRandomAccessFile(this.getPath(), "r");
            long pos = (long)(ratio * (double)raFile.length());
            while (pos > 0L) {
                raFile.seek(pos - 1L);
                if (raFile.read() == 10) break;
                --pos;
            }
            TmfLocation location = new TmfLocation((Comparable)Long.valueOf(pos));
            TmfContext context = this.seekEvent((ITmfLocation<?>)location);
            context.setRank(-1L);
            tmfContext = context;
            if (raFile == null) break block16;
            try {
                raFile.close();
            }
            catch (IOException iOException) {}
        }
        return tmfContext;
        catch (FileNotFoundException e) {
            CustomTxtTraceContext customTxtTraceContext;
            block17: {
                e.printStackTrace();
                customTxtTraceContext = new CustomTxtTraceContext((ITmfLocation<?>)NULL_LOCATION, -1L);
                if (raFile == null) break block17;
                try {
                    raFile.close();
                }
                catch (IOException iOException) {}
            }
            return customTxtTraceContext;
        }
        catch (IOException e2) {
            CustomTxtTraceContext customTxtTraceContext;
            block18: {
                e2.printStackTrace();
                customTxtTraceContext = new CustomTxtTraceContext((ITmfLocation<?>)NULL_LOCATION, -1L);
                if (raFile == null) break block18;
                {
                    catch (Throwable throwable) {
                        if (raFile != null) {
                            try {
                                raFile.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                }
                try {
                    raFile.close();
                }
                catch (IOException iOException) {}
            }
            return customTxtTraceContext;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double getLocationRatio(ITmfLocation<?> location) {
        BufferedRandomAccessFile raFile;
        block16: {
            raFile = null;
            if (!(location.getLocation() instanceof Long)) break block16;
            raFile = new BufferedRandomAccessFile(this.getPath(), "r");
            double d = (double)((Long)location.getLocation()).longValue() / (double)raFile.length();
            if (raFile == null) return d;
            try {
                raFile.close();
                return d;
            }
            catch (IOException iOException) {}
            return d;
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (raFile == null) return 0.0;
                try {
                    raFile.close();
                    return 0.0;
                }
                catch (IOException iOException) {}
                return 0.0;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                if (raFile == null) return 0.0;
                {
                    catch (Throwable throwable) {
                        if (raFile == null) throw throwable;
                        try {
                            raFile.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {
                    raFile.close();
                    return 0.0;
                }
                catch (IOException iOException) {}
                return 0.0;
            }
        }
        if (raFile == null) return 0.0;
        try {
            raFile.close();
            return 0.0;
        }
        catch (IOException iOException) {}
        return 0.0;
    }

    public ITmfLocation<?> getCurrentLocation() {
        return null;
    }

    public synchronized TmfEvent readNextEvent(ITmfContext context) {
        ITmfContext savedContext = context.clone();
        CustomTxtEvent event = this.parseEvent(context);
        if (event != null) {
            this.updateAttributes(savedContext, event.getTimestamp());
            context.increaseRank();
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomTxtEvent parseEvent(ITmfContext tmfContext) {
        if (!(tmfContext instanceof CustomTxtTraceContext)) {
            return null;
        }
        CustomTxtTraceContext context = (CustomTxtTraceContext)tmfContext;
        if (!(context.getLocation().getLocation() instanceof Long) || NULL_LOCATION.equals((Object)context.getLocation())) {
            return null;
        }
        CustomTxtEvent event = this.parseFirstLine(context);
        HashMap<CustomTxtTraceDefinition.InputLine, Integer> countMap = new HashMap<CustomTxtTraceDefinition.InputLine, Integer>();
        CustomTxtTraceDefinition.InputLine currentInput = null;
        if (context.inputLine.childrenInputs != null && context.inputLine.childrenInputs.size() > 0) {
            currentInput = context.inputLine.childrenInputs.get(0);
            countMap.put(currentInput, 0);
        }
        BufferedRandomAccessFile bufferedRandomAccessFile = context.raFile;
        synchronized (bufferedRandomAccessFile) {
            try {
                String line;
                if (context.raFile.getFilePointer() != context.nextLineLocation) {
                    context.raFile.seek(context.nextLineLocation);
                }
                long rawPos = context.raFile.getFilePointer();
                while ((line = context.raFile.getNextLine()) != null) {
                    boolean processed = false;
                    if (currentInput == null) {
                        for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                            Matcher matcher = input.getPattern().matcher(line);
                            if (!matcher.find()) continue;
                            context.setLocation((ITmfLocation)new TmfLocation((Comparable)Long.valueOf(rawPos)));
                            context.firstLineMatcher = matcher;
                            context.firstLine = line;
                            context.nextLineLocation = context.raFile.getFilePointer();
                            context.inputLine = input;
                            return event;
                        }
                    } else {
                        if ((Integer)countMap.get(currentInput) >= currentInput.getMinCount()) {
                            Matcher matcher;
                            List<CustomTxtTraceDefinition.InputLine> nextInputs = currentInput.getNextInputs(countMap);
                            if (nextInputs.size() == 0 || nextInputs.get(nextInputs.size() - 1).getMinCount() == 0) {
                                for (CustomTxtTraceDefinition.InputLine input : this.getFirstLines()) {
                                    matcher = input.getPattern().matcher(line);
                                    if (!matcher.find()) continue;
                                    context.setLocation((ITmfLocation)new TmfLocation((Comparable)Long.valueOf(rawPos)));
                                    context.firstLineMatcher = matcher;
                                    context.firstLine = line;
                                    context.nextLineLocation = context.raFile.getFilePointer();
                                    context.inputLine = input;
                                    return event;
                                }
                            }
                            for (CustomTxtTraceDefinition.InputLine input : nextInputs) {
                                CustomTxtTraceDefinition.InputLine inputLine;
                                matcher = input.getPattern().matcher(line);
                                if (!matcher.find()) continue;
                                event.processGroups(input, matcher);
                                currentInput = input;
                                if (countMap.get(currentInput) == null) {
                                    countMap.put(currentInput, 1);
                                } else {
                                    countMap.put(currentInput, countMap.get(currentInput) + 1);
                                }
                                Iterator<CustomTxtTraceDefinition.InputLine> iter = countMap.keySet().iterator();
                                while (iter.hasNext()) {
                                    inputLine = iter.next();
                                    if (inputLine.level <= currentInput.level) continue;
                                    iter.remove();
                                }
                                if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                    currentInput = currentInput.childrenInputs.get(0);
                                    countMap.put(currentInput, 0);
                                } else if (countMap.get(currentInput) >= currentInput.getMaxCount()) {
                                    if (currentInput.getNextInputs(countMap).size() > 0) {
                                        if (countMap.get(currentInput = currentInput.getNextInputs(countMap).get(0)) == null) {
                                            countMap.put(currentInput, 0);
                                        }
                                        iter = countMap.keySet().iterator();
                                        while (iter.hasNext()) {
                                            inputLine = iter.next();
                                            if (inputLine.level <= currentInput.level) continue;
                                            iter.remove();
                                        }
                                    } else {
                                        currentInput = null;
                                    }
                                }
                                processed = true;
                                break;
                            }
                        }
                        if (!processed) {
                            Matcher matcher = currentInput.getPattern().matcher(line);
                            if (matcher.find()) {
                                event.processGroups(currentInput, matcher);
                                countMap.put(currentInput, countMap.get(currentInput) + 1);
                                if (currentInput.childrenInputs != null && currentInput.childrenInputs.size() > 0) {
                                    currentInput = currentInput.childrenInputs.get(0);
                                    countMap.put(currentInput, 0);
                                } else if (countMap.get(currentInput) >= currentInput.getMaxCount()) {
                                    if (currentInput.getNextInputs(countMap).size() > 0) {
                                        if (countMap.get(currentInput = currentInput.getNextInputs(countMap).get(0)) == null) {
                                            countMap.put(currentInput, 0);
                                        }
                                        Iterator<CustomTxtTraceDefinition.InputLine> iter = countMap.keySet().iterator();
                                        while (iter.hasNext()) {
                                            CustomTxtTraceDefinition.InputLine inputLine = iter.next();
                                            if (inputLine.level <= currentInput.level) continue;
                                            iter.remove();
                                        }
                                    } else {
                                        currentInput = null;
                                    }
                                }
                            }
                            ((StringBuffer)event.getContent().getValue()).append("\n").append(line);
                        }
                    }
                    rawPos = context.raFile.getFilePointer();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry entry : countMap.entrySet()) {
            if ((Integer)entry.getValue() >= ((CustomTxtTraceDefinition.InputLine)entry.getKey()).getMinCount()) continue;
            event = null;
        }
        context.setLocation((ITmfLocation)NULL_LOCATION);
        return event;
    }

    public List<CustomTxtTraceDefinition.InputLine> getFirstLines() {
        return this.fDefinition.inputs;
    }

    public CustomTxtEvent parseFirstLine(CustomTxtTraceContext context) {
        CustomTxtEvent event = new CustomTxtEvent(this.fDefinition, (ITmfTrace<?>)this, TmfTimestamp.ZERO, "", (TmfEventType)this.fEventType, "");
        event.processGroups(context.inputLine, context.firstLineMatcher);
        event.setContent((ITmfEventField)new CustomEventContent(event, context.firstLine));
        return event;
    }

    public CustomTraceDefinition getDefinition() {
        return this.fDefinition;
    }

    public boolean validate(IProject project, String path) {
        return this.fileExists(path);
    }
}

