/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph;

import java.util.Map;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public abstract class TimeGraphPresentationProvider
implements ITimeGraphPresentationProvider {
    private static final int DEFAULT_ITEM_HEIGHT = 19;

    @Override
    public String getStateTypeName() {
        return Messages.TmfTimeLegend_TRACE_STATES;
    }

    @Override
    public void postDrawControl(Rectangle bounds, GC gc) {
    }

    @Override
    public void postDrawEntry(ITimeGraphEntry entry, Rectangle bounds, GC gc) {
    }

    @Override
    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
    }

    @Override
    public StateItem[] getStateTable() {
        return null;
    }

    @Override
    public int getEventTableIndex(ITimeEvent event) {
        return 0;
    }

    @Override
    public int getItemHeight(ITimeGraphEntry entry) {
        return 19;
    }

    @Override
    public String getTraceClassName(ITimeGraphEntry trace) {
        return null;
    }

    @Override
    public abstract String getEventName(ITimeEvent var1);

    @Override
    public String composeTraceName(ITimeGraphEntry trace, boolean inclState) {
        String name = trace.getName();
        String threadClass = this.getTraceClassName(trace);
        if (threadClass != null && threadClass.length() > 0) {
            name = String.valueOf(name) + " [" + threadClass + "]";
        }
        return name;
    }

    @Override
    public String composeEventName(ITimeEvent event) {
        String name = event.getEntry().getName();
        String threadClass = this.getTraceClassName(event.getEntry());
        if (threadClass != null && threadClass.length() > 0) {
            name = String.valueOf(name) + " [" + threadClass + "]";
        }
        name = String.valueOf(name) + " (" + this.getEventName(event) + ")";
        return name;
    }

    @Override
    public abstract Map<String, String> getEventHoverToolTipInfo(ITimeEvent var1);

    @Override
    public Image getItemImage(Object obj) {
        return null;
    }
}

