/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.graphs;

import java.util.LinkedList;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.internal.systemtap.ui.graphingapi.ui.GraphingAPIUIPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.graphingapi.ui.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.IGraphColorConstants;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.DataPoint;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.graphs.AChart;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.graphs.IGraph;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets.GraphAxis;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets.GraphAxis2;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.widgets.GraphComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;

public abstract class AGraph
extends AChart
implements IGraph {
    private final Preferences.IPropertyChangeListener propertyChangeListener = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            IPreferenceStore store = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
            if (event.getProperty().equals("MaxDataItems")) {
                maxItems = store.getInt("MaxDataItems");
            } else if (event.getProperty().equals("ViewableDataItems")) {
                viewableItems = store.getInt("ViewableDataItems");
            } else if (event.getProperty().equals("XSeriesTicks")) {
                xSeriesTicks = store.getInt("XSeriesTicks");
                int i = 0;
                while (i < AGraph.this.axes.size()) {
                    GraphAxis a = AGraph.this.axes.get(i);
                    if (1 == a.getType()) {
                        a.setTickCount(xSeriesTicks);
                    }
                    ++i;
                }
            } else if (event.getProperty().equals("YSeriesTicks")) {
                ySeriesTicks = store.getInt("YSeriesTicks");
                int i = 0;
                while (i < AGraph.this.axes.size()) {
                    GraphAxis a = AGraph.this.axes.get(i);
                    if (a.getType() == 0) {
                        a.setTickCount(ySeriesTicks);
                    }
                    ++i;
                }
            } else if (event.getProperty().equals("ShowXGridLines")) {
                AGraph.this.showXGrid = store.getBoolean("ShowXGridLines");
                AGraph.this.showGrid = AGraph.this.showXGrid || AGraph.this.showYGrid;
            } else if (event.getProperty().equals("ShowXGridLines")) {
                AGraph.this.showYGrid = store.getBoolean("ShowXGridLines");
                AGraph.this.showGrid = AGraph.this.showXGrid || AGraph.this.showYGrid;
            }
            AGraph.this.repaint();
        }
    };
    private SelectionListener gridListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            AGraph.this.showGrid = ((Button)e.getSource()).getSelection();
            AGraph.this.repaint();
        }
    };
    private SelectionListener normalizeListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            AGraph.this.normalize = ((Button)e.getSource()).getSelection();
            if (!AGraph.this.normalize) {
                AGraph.this.removeSeriesAxis();
            }
            AGraph.this.handleUpdateEvent();
        }
    };
    protected LinkedList<GraphAxis> axes;
    private IAdapter adapter;
    private boolean showYGrid;
    private boolean showXGrid;
    protected static int xSeriesTicks;
    protected static int ySeriesTicks;
    protected static int maxItems;
    protected static int viewableItems;
    protected int removedItems;
    public boolean showGrid;
    public boolean normalize;
    protected int selectedSeries;
    protected GraphAxis seriesAxis;

    public AGraph(GraphComposite parent, int style, String title, IAdapter adapt) {
        super(parent, style, title, adapt);
        this.adapter = adapt;
        this.axes = new LinkedList();
        IPreferenceStore store = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
        xSeriesTicks = store.getInt("XSeriesTicks");
        ySeriesTicks = store.getInt("YSeriesTicks");
        maxItems = store.getInt("MaxDataItems");
        viewableItems = store.getInt("ViewableDataItems");
        this.createAxis(Localization.getString("AGraph.xAxis"), xSeriesTicks, 1);
        this.createAxis(Localization.getString("AGraph.yAxis"), ySeriesTicks, 0);
        GraphingAPIUIPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.propertyChangeListener);
        parent.addCheckOption(Localization.getString("AGraph.GridLines"), this.gridListener);
        if (this.adapter.getSeriesCount() > 1) {
            parent.addCheckOption(Localization.getString("AGraph.Normalize"), this.normalizeListener);
        }
    }

    protected void createAxis(String title, int tickCount, int style) {
        this.axes.add(new GraphAxis(this, title, tickCount, style));
    }

    protected void createAxis2(String title, int tickCount, int style) {
        this.axes.add(new GraphAxis2(this, title, tickCount, style, this.axisColor));
    }

    public Rectangle getArea(int items) {
        int uBound = this.elementList[0].size();
        int lBound = uBound > items ? uBound - items : 0;
        int maxX = Integer.MIN_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int j = 0;
        while (j < this.elementList.length) {
            int i = lBound;
            while (i < uBound) {
                Object o = this.elementList[j].get(i);
                DataPoint p = (DataPoint)o;
                if (p.x < (double)minX) {
                    minX = (int)p.x;
                }
                if (p.x > (double)maxX) {
                    maxX = (int)p.x;
                }
                if (p.y < (double)minY) {
                    minY = (int)p.y;
                }
                if (p.y > (double)maxY) {
                    maxY = (int)p.y;
                }
                ++i;
            }
            ++j;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    private synchronized void rebound() {
        this.getDisplay().syncExec(new Runnable(){
            boolean stop = false;

            public void run() {
                if (this.stop) {
                    return;
                }
                try {
                    AGraph.this.setGlobalArea(AGraph.this.getArea(maxItems));
                    AGraph.this.setLocalArea(AGraph.this.getArea(viewableItems));
                }
                catch (Exception exception) {
                    this.stop = true;
                }
            }
        });
    }

    public synchronized void repaint() {
        this.rebound();
        super.repaint();
    }

    public void addSeriesAxis(int series) {
        if (this.selectedSeries != series + 1) {
            this.removeSeriesAxis();
            this.seriesAxis = new GraphAxis2(this, Localization.getString("AGraph.SeriesAxis"), ySeriesTicks, 46, new Color((Device)this.getDisplay(), IGraphColorConstants.COLORS[series]));
            this.selectedSeries = series + 1;
            this.axes.add(this.seriesAxis);
            this.repaint();
        }
    }

    public void removeSeriesAxis() {
        if (this.seriesAxis != null) {
            this.axes.remove(this.seriesAxis);
            this.seriesAxis = null;
            this.selectedSeries = -1;
            this.repaint();
        }
    }

    protected void paintAll(GC gc) {
        int i = 0;
        while (i < this.axes.size()) {
            this.axes.get(i).paint(gc);
            ++i;
        }
        super.paintAll(gc);
    }

    public void dispose() {
        GraphingAPIUIPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.propertyChangeListener);
        this.parent.removeCheckOption(Localization.getString("AGraph.Normalize"));
        this.parent.removeCheckOption(Localization.getString("AGraph.GridLines"));
        this.normalizeListener = null;
        this.gridListener = null;
        this.parent = null;
        super.dispose();
    }
}

