/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.widgets;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.ITimeAnalysisViewer;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.model.ITimeEvent;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class Utils {
    public static final int IMG_THREAD_RUNNING = 0;
    public static final int IMG_THREAD_SUSPENDED = 1;
    public static final int IMG_THREAD_STOPPED = 2;
    public static final int IMG_METHOD_RUNNING = 3;
    public static final int IMG_METHOD = 4;
    public static final int IMG_NUM = 5;
    public static final Object[] _empty = new Object[0];
    private static final SimpleDateFormat stimeformat = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat sdateformat = new SimpleDateFormat("yyyy-MM-dd");

    public static void init(Rectangle rect) {
        rect.x = 0;
        rect.y = 0;
        rect.width = 0;
        rect.height = 0;
    }

    public static void init(Rectangle rect, int x, int y, int width, int height) {
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
    }

    public static void init(Rectangle rect, Rectangle source) {
        rect.x = source.x;
        rect.y = source.y;
        rect.width = source.width;
        rect.height = source.height;
    }

    public static void deflate(Rectangle rect, int x, int y) {
        rect.x += x;
        rect.y += y;
        rect.width -= x + x;
        rect.height -= y + y;
    }

    public static void inflate(Rectangle rect, int x, int y) {
        rect.x -= x;
        rect.y -= y;
        rect.width += x + x;
        rect.height += y + y;
    }

    static void dispose(Color col) {
        if (col != null) {
            col.dispose();
        }
    }

    public static Color mixColors(Device display, Color c1, Color c2, int w1, int w2) {
        return new Color(display, (w1 * c1.getRed() + w2 * c2.getRed()) / (w1 + w2), (w1 * c1.getGreen() + w2 * c2.getGreen()) / (w1 + w2), (w1 * c1.getBlue() + w2 * c2.getBlue()) / (w1 + w2));
    }

    public static Color getSysColor(int id) {
        Color col = Display.getCurrent().getSystemColor(id);
        return new Color(col.getDevice(), col.getRGB());
    }

    public static Color mixColors(Color col1, Color col2, int w1, int w2) {
        return Utils.mixColors((Device)Display.getCurrent(), col1, col2, w1, w2);
    }

    public static int drawText(GC gc, String text, Rectangle rect, boolean transp) {
        Point size = gc.stringExtent(text);
        gc.drawText(text, rect.x, rect.y, transp);
        return size.x;
    }

    public static int drawText(GC gc, String text, int x, int y, boolean transp) {
        Point size = gc.stringExtent(text);
        gc.drawText(text, x, y, transp);
        return size.x;
    }

    public static String formatTime(long time, ITimeAnalysisViewer.TimeFormat format, Resolution resolution) {
        boolean neg;
        if (format == ITimeAnalysisViewer.TimeFormat.ABSOLUTE) {
            return Utils.formatTimeAbs(time, resolution);
        }
        StringBuffer str = new StringBuffer();
        boolean bl = neg = time < 0L;
        if (neg) {
            time = -time;
            str.append('-');
        }
        long sec = (long)((double)time * 1.0E-9);
        str.append(sec);
        String ns = Utils.formatNs(time, resolution);
        if (!ns.equals("")) {
            str.append(':');
            str.append(ns);
        }
        return str.toString();
    }

    public static String formatDate(long absTime) {
        String sdate = sdateformat.format(new Date((long)((double)absTime * 1.0E-6)));
        return sdate;
    }

    public static String formatTimeAbs(long time, Resolution res) {
        StringBuffer str = new StringBuffer();
        String stime = stimeformat.format(new Date((long)((double)time * 1.0E-6)));
        str.append(String.valueOf(stime) + " ");
        str.append(Utils.formatNs(time, res));
        return str.toString();
    }

    public static String formatNs(long time, Resolution res) {
        boolean neg;
        StringBuffer temp = new StringBuffer();
        boolean bl = neg = time < 0L;
        if (neg) {
            time = -time;
        }
        int segments = 0;
        switch (res) {
            case MILLISEC: {
                segments = 1;
                break;
            }
            case MICROSEC: {
                segments = 2;
                break;
            }
            case NANOSEC: {
                segments = 3;
                break;
            }
        }
        long ns = time;
        if ((ns %= 1000000000L) < 10L) {
            temp.append("00000000");
        } else if (ns < 100L) {
            temp.append("0000000");
        } else if (ns < 1000L) {
            temp.append("000000");
        } else if (ns < 10000L) {
            temp.append("00000");
        } else if (ns < 100000L) {
            temp.append("0000");
        } else if (ns < 1000000L) {
            temp.append("000");
        } else if (ns < 10000000L) {
            temp.append("00");
        } else if (ns < 100000000L) {
            temp.append("0");
        }
        temp.append(ns);
        StringBuffer str = new StringBuffer();
        if (segments > 0) {
            str.append(temp.substring(0, 3));
        }
        if (segments > 1) {
            str.append(".");
            str.append(temp.substring(3, 6));
        }
        if (segments > 2) {
            str.append(".");
            str.append(temp.substring(6));
        }
        return str.toString();
    }

    public static int loadIntOption(String opt, int def, int min, int max) {
        return def;
    }

    public static void saveIntOption(String opt, int val) {
    }

    static ITimeEvent getFirstEvent(ITmfTimeAnalysisEntry thread) {
        if (thread == null) {
            return null;
        }
        Iterator iterator = thread.getTraceEventsIterator();
        if (iterator.hasNext()) {
            return (ITimeEvent)iterator.next();
        }
        return null;
    }

    static ITimeEvent findEvent(ITmfTimeAnalysisEntry thread, long time, int n) {
        if (thread == null) {
            return null;
        }
        Iterator iterator = thread.getTraceEventsIterator();
        ITimeEvent nextEvent = null;
        ITimeEvent currEvent = null;
        ITimeEvent prevEvent = null;
        while (iterator.hasNext()) {
            nextEvent = (ITimeEvent)iterator.next();
            long nextStartTime = nextEvent.getTime();
            if (nextStartTime > time) break;
            if (currEvent != null && currEvent.getTime() == nextStartTime) continue;
            prevEvent = currEvent;
            currEvent = nextEvent;
        }
        if (n == -1) {
            if (currEvent != null && currEvent.getTime() + currEvent.getDuration() >= time) {
                return prevEvent;
            }
            return currEvent;
        }
        if (n == 0) {
            if (currEvent != null && currEvent.getTime() + currEvent.getDuration() >= time) {
                return currEvent;
            }
            return null;
        }
        if (n == 1) {
            return nextEvent;
        }
        if (n == 2) {
            return currEvent;
        }
        return null;
    }

    public static String fixMethodSignature(String sig) {
        int pos = sig.indexOf(40);
        if (pos >= 0) {
            String ret = sig.substring(0, pos);
            sig = sig.substring(pos);
            sig = String.valueOf(sig) + " " + ret;
        }
        return sig;
    }

    public static String restoreMethodSignature(String sig) {
        String ret = "";
        int pos = sig.indexOf(40);
        if (pos >= 0) {
            ret = sig.substring(0, pos);
            sig = sig.substring(pos + 1);
        }
        if ((pos = sig.indexOf(41)) >= 0) {
            sig = sig.substring(0, pos);
        }
        String[] args = sig.split(",");
        StringBuffer result = new StringBuffer("(");
        int i = 0;
        while (i < args.length) {
            String arg = args[i].trim();
            if (arg.length() == 0 && args.length == 1) break;
            result.append(Utils.getTypeSignature(arg));
            ++i;
        }
        result.append(")").append(Utils.getTypeSignature(ret));
        return result.toString();
    }

    public static String getTypeSignature(String type) {
        int dim = 0;
        int j = 0;
        while (j < type.length()) {
            if (type.charAt(j) == '[') {
                ++dim;
            }
            ++j;
        }
        int pos = type.indexOf(91);
        if (pos >= 0) {
            type = type.substring(0, pos);
        }
        StringBuffer sig = new StringBuffer("");
        int j2 = 0;
        while (j2 < dim) {
            sig.append("[");
            ++j2;
        }
        if (type.equals("boolean")) {
            sig.append("Z");
        } else if (type.equals("byte")) {
            sig.append("B");
        } else if (type.equals("char")) {
            sig.append("C");
        } else if (type.equals("short")) {
            sig.append("S");
        } else if (type.equals("int")) {
            sig.append("I");
        } else if (type.equals("long")) {
            sig.append("J");
        } else if (type.equals("float")) {
            sig.append("F");
        } else if (type.equals("double")) {
            sig.append("D");
        } else if (type.equals("void")) {
            sig.append("V");
        } else {
            sig.append("L").append(type.replace('.', '/')).append(";");
        }
        return sig.toString();
    }

    public static int compare(double d1, double d2) {
        if (d1 > d2) {
            return 1;
        }
        if (d1 < d2) {
            return 1;
        }
        return 0;
    }

    public static int compare(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.compareToIgnoreCase(s2);
        }
        if (s1 != null) {
            return 1;
        }
        if (s2 != null) {
            return -1;
        }
        return 0;
    }

    static enum Resolution {
        SECONDS,
        MILLISEC,
        MICROSEC,
        NANOSEC;

    }
}

