/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.KernelStatisticsData;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.StatisticsData;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.StatisticsTreeNode;

public class StatisticsTreeRootFactory {
    private static final Map<String, StatisticsData> fTreeInstances = new HashMap<String, StatisticsData>();

    public static StatisticsTreeNode getStatTreeRoot(String traceUniqueId) {
        return StatisticsTreeRootFactory.getStatTree(traceUniqueId).getOrCreate(StatisticsData.ROOT);
    }

    public static StatisticsData getStatTree(String traceUniqueId) {
        if (traceUniqueId == null) {
            return null;
        }
        StatisticsData tree = fTreeInstances.get(traceUniqueId);
        if (tree == null) {
            tree = new KernelStatisticsData(traceUniqueId);
            fTreeInstances.put(traceUniqueId, tree);
        }
        return tree;
    }

    public static boolean containsTreeRoot(String traceUniqueId) {
        return fTreeInstances.containsKey(traceUniqueId);
    }

    public static void removeStatTreeRoot(String traceUniqueId) {
        if (traceUniqueId != null && fTreeInstances.containsKey(traceUniqueId)) {
            fTreeInstances.remove(traceUniqueId);
        }
    }

    public static void removeAll() {
        fTreeInstances.clear();
    }
}

