/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.resources;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.common.EventIterator;
import org.eclipse.linuxtools.lttng2.kernel.core.trace.CtfKernelTrace;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class ResourcesEntry
implements ITimeGraphEntry {
    private int fQuark;
    private CtfKernelTrace fTrace;
    private ITimeGraphEntry fParent = null;
    private ITimeGraphEntry[] children = null;
    private String fName;
    private Type fType;
    private int fId;
    private long fStartTime;
    private long fEndTime;
    private List<ITimeEvent> fEventList = new ArrayList<ITimeEvent>();
    private List<ITimeEvent> fZoomedEventList = null;

    public ResourcesEntry(int quark, CtfKernelTrace trace, Type type, int id) {
        this.fQuark = quark;
        this.fTrace = trace;
        this.fType = type;
        this.fId = id;
        this.fName = String.valueOf(type.toString()) + ' ' + Integer.toString(id);
    }

    public ITimeGraphEntry getParent() {
        return this.fParent;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.length > 0;
    }

    public ITimeGraphEntry[] getChildren() {
        return this.children;
    }

    public String getName() {
        return this.fName;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public long getEndTime() {
        return this.fEndTime;
    }

    public boolean hasTimeEvents() {
        return true;
    }

    public Iterator<ITimeEvent> getTimeEventsIterator() {
        return new EventIterator(this.fEventList, this.fZoomedEventList);
    }

    public Iterator<ITimeEvent> getTimeEventsIterator(long startTime, long stopTime, long visibleDuration) {
        return new EventIterator(this.fEventList, this.fZoomedEventList, startTime, stopTime);
    }

    public void setParent(ITimeGraphEntry parent) {
        this.fParent = parent;
    }

    public int getQuark() {
        return this.fQuark;
    }

    public CtfKernelTrace getTrace() {
        return this.fTrace;
    }

    public Type getType() {
        return this.fType;
    }

    public int getId() {
        return this.fId;
    }

    public void setEventList(List<ITimeEvent> eventList) {
        this.fEventList = eventList;
        if (eventList != null && eventList.size() > 0) {
            this.fStartTime = eventList.get(0).getTime();
            ITimeEvent lastEvent = eventList.get(eventList.size() - 1);
            this.fEndTime = lastEvent.getTime() + lastEvent.getDuration();
        }
    }

    public void setZoomedEventList(List<ITimeEvent> eventList) {
        this.fZoomedEventList = eventList;
    }

    public static enum Type {
        NULL,
        CPU,
        IRQ,
        SOFT_IRQ;

    }
}

