/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.internal.tmf.ui.project.dialogs.SelectSupplementaryResourcesDialog;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class DeleteExperimentSupplementaryFilesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection instanceof TreeSelection) {
            TreeSelection sel = (TreeSelection)selection;
            Object element = sel.getFirstElement();
            ArrayList<IResource> resourcesList = new ArrayList<IResource>();
            if (element instanceof TmfExperimentElement) {
                TmfExperimentElement trace = (TmfExperimentElement)element;
                for (TmfTraceElement aTrace : trace.getTraces()) {
                    aTrace = aTrace.getElementUnderTraceFolder();
                    IResource[] resources = aTrace.getSupplementaryResources();
                    resourcesList.addAll(Arrays.asList(resources));
                }
                SelectSupplementaryResourcesDialog dialog = new SelectSupplementaryResourcesDialog(window.getShell(), resourcesList.toArray(new IResource[resourcesList.size()]));
                if (dialog.open() != 0) {
                    return null;
                }
                IResource[] resourcesToDelete = dialog.getResources();
                int i = 0;
                while (i < resourcesToDelete.length) {
                    try {
                        resourcesToDelete[i].delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError("Error deleting supplementary resource " + resourcesToDelete[i], e);
                    }
                    ++i;
                }
                IProject resource = trace.getProject().getResource();
                if (resource != null) {
                    try {
                        if (resource != null) {
                            resource.refreshLocal(2, null);
                        }
                    }
                    catch (CoreException e) {
                        Activator.getDefault().logError("Error refreshing resource " + resource, e);
                    }
                }
            }
        }
        return null;
    }
}

