/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.internal.tmf.ui.Activator;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.IHandlerService;

public class RefreshAction
extends Action {
    private static final String REFRESH_TRACE_FOLDER_COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.command.project.trace.refresh";
    private static final String REFRESH_EXPERIMENT_FOLDER_COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.command.project.experiment_folder.refresh";
    private static final String REFRESH_EXPERIMENT_COMMAND_ID = "org.eclipse.linuxtools.tmf.ui.command.project.experiment.refresh";
    private IWorkbenchPage page;
    private ISelectionProvider selectionProvider;
    private TmfProjectModelElement element;

    public RefreshAction(IWorkbenchPage page, ISelectionProvider selectionProvider) {
        this.page = page;
        this.selectionProvider = selectionProvider;
    }

    public boolean isEnabled() {
        IStructuredSelection sSelection;
        ISelection selection = this.selectionProvider.getSelection();
        if (!selection.isEmpty() && (sSelection = (IStructuredSelection)selection).size() == 1 && (sSelection.getFirstElement() instanceof TmfTraceFolder || sSelection.getFirstElement() instanceof TmfExperimentFolder || sSelection.getFirstElement() instanceof TmfExperimentElement)) {
            this.element = (TmfProjectModelElement)sSelection.getFirstElement();
            return true;
        }
        return false;
    }

    public void run() {
        try {
            IHandlerService handlerService = (IHandlerService)this.page.getActivePart().getSite().getService(IHandlerService.class);
            if (this.element instanceof TmfTraceFolder) {
                handlerService.executeCommand(REFRESH_TRACE_FOLDER_COMMAND_ID, null);
            } else if (this.element instanceof TmfExperimentFolder) {
                handlerService.executeCommand(REFRESH_EXPERIMENT_FOLDER_COMMAND_ID, null);
            } else if (this.element instanceof TmfExperimentElement) {
                handlerService.executeCommand(REFRESH_EXPERIMENT_COMMAND_ID, null);
            }
        }
        catch (ExecutionException e) {
            Activator.getDefault().logError("Error refreshing resource " + this.element.getName(), e);
        }
        catch (NotDefinedException e) {
            Activator.getDefault().logError("Error refreshing resource " + this.element.getName(), e);
        }
        catch (NotEnabledException e) {
            Activator.getDefault().logError("Error refreshing resource " + this.element.getName(), e);
        }
        catch (NotHandledException e) {
            Activator.getDefault().logError("Error refreshing resource " + this.element.getName(), e);
        }
    }
}

