/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.helgrind;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.internal.valgrind.helgrind.Messages;
import org.eclipse.linuxtools.valgrind.launch.IValgrindToolPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.osgi.framework.Version;

public class HelgrindToolPage
extends AbstractLaunchConfigurationTab
implements IValgrindToolPage {
    public static final String HELGRIND = "helgrind";
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.helgrind";
    protected Button lockordersButton;
    protected Combo historyCombo;
    protected Spinner cacheSizeSpinner;
    protected boolean isInitializing = false;
    protected Version valgrindVersion;
    protected CoreException ex = null;
    protected SelectionListener selectListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            HelgrindToolPage.this.updateLaunchConfigurationDialog();
        }
    };
    protected ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            HelgrindToolPage.this.updateLaunchConfigurationDialog();
        }
    };

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout helgrindLayout = new GridLayout(2, true);
        top.setLayout((Layout)helgrindLayout);
        top.setLayoutData((Object)new GridData(768));
        this.lockordersButton = new Button(top, 32);
        this.lockordersButton.setLayoutData((Object)new GridData(768));
        this.lockordersButton.setText(Messages.getString("HelgrindToolPage.track_lockorders"));
        this.lockordersButton.addSelectionListener(this.selectListener);
        Composite historyTop = new Composite(top, 0);
        historyTop.setLayout((Layout)new GridLayout(2, false));
        historyTop.setLayoutData((Object)new GridData(768));
        Label historyLabel = new Label(historyTop, 0);
        historyLabel.setText(Messages.getString("HelgrindToolPage.history_level"));
        this.historyCombo = new Combo(historyTop, 8);
        String[] historyOpts = new String[]{"full", "approx", "none"};
        this.historyCombo.setItems(historyOpts);
        this.historyCombo.addSelectionListener(this.selectListener);
        Composite conflictCacheSizeTop = new Composite(top, 0);
        conflictCacheSizeTop.setLayout((Layout)new GridLayout(2, false));
        conflictCacheSizeTop.setLayoutData((Object)new GridData(768));
        Label cacheSizeLabel = new Label(conflictCacheSizeTop, 0);
        cacheSizeLabel.setText(Messages.getString("HelgrindToolPage.cache_size"));
        this.cacheSizeSpinner = new Spinner(conflictCacheSizeTop, 2048);
        this.cacheSizeSpinner.setMaximum(Integer.MAX_VALUE);
        this.cacheSizeSpinner.addModifyListener(this.modifyListener);
    }

    public String getName() {
        return Messages.getString("HelgrindToolPage.Helgrind_Options");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.isInitializing = true;
        try {
            this.lockordersButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_LOCKORDERS", true));
            this.historyCombo.setText(configuration.getAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_HISTORYLEVEL", "full"));
            this.cacheSizeSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_CACHESIZE", 1000000));
        }
        catch (CoreException e) {
            this.ex = e;
        }
        this.isInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_LOCKORDERS", this.lockordersButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_HISTORYLEVEL", this.historyCombo.getText());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_CACHESIZE", this.cacheSizeSpinner.getSelection());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        boolean result = true;
        return result;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_LOCKORDERS", true);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_HISTORYLEVEL", "full");
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_CACHESIZE", 1000000);
    }

    public void setValgrindVersion(Version ver) {
        this.valgrindVersion = ver;
    }

    protected void createHorizontalSpacer(Composite comp, int numlines) {
        Label lbl = new Label(comp, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numlines;
        lbl.setLayoutData((Object)gd);
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }

    public Button getLockordersButton() {
        return this.lockordersButton;
    }

    public void setLockordersButton(Button lockordersButton) {
        this.lockordersButton = lockordersButton;
    }

    public Spinner getCacheSizeSpinner() {
        return this.cacheSizeSpinner;
    }

    public void setCacheSizeSpinner(Spinner cacheSizeSpinner) {
        this.cacheSizeSpinner = cacheSizeSpinner;
    }

    public Combo getHistoryCombo() {
        return this.historyCombo;
    }

    public void setHistoryCombo(Combo historyCombo) {
        this.historyCombo = historyCombo;
    }
}

