/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TtcnError;

public final class Optional<TYPE extends Base_Type>
extends Base_Type {
    private TYPE optionalValue;
    private optional_sel optionalSelection;
    private final Class<TYPE> clazz;

    public Optional(Class<TYPE> clazz) {
        this.optionalValue = null;
        this.optionalSelection = optional_sel.OPTIONAL_UNBOUND;
        this.clazz = clazz;
    }

    public Optional(Class<TYPE> clazz, Base_Template.template_sel otherValue) {
        if (otherValue != Base_Template.template_sel.OMIT_VALUE) {
            throw new TtcnError("Setting an optional field to an invalid value.");
        }
        this.optionalValue = null;
        this.optionalSelection = optional_sel.OPTIONAL_OMIT;
        this.clazz = clazz;
    }

    public Optional(Optional<TYPE> otherValue) {
        this.optionalValue = null;
        this.optionalSelection = otherValue.optionalSelection;
        this.clazz = otherValue.clazz;
        if (optional_sel.OPTIONAL_PRESENT.equals((Object)otherValue.optionalSelection)) {
            try {
                this.optionalValue = (Base_Type)this.clazz.newInstance();
            }
            catch (Exception e) {
                throw new TtcnError(MessageFormat.format("Internal Error: exception `{0}'' thrown while instantiating class of `{1}'' type", e.getMessage(), this.clazz.getName()));
            }
            ((Base_Type)this.optionalValue).operator_assign((Base_Type)otherValue.optionalValue);
        }
    }

    @Override
    public void clean_up() {
        if (optional_sel.OPTIONAL_PRESENT.equals((Object)this.optionalSelection)) {
            this.optionalValue = null;
        }
        this.optionalSelection = optional_sel.OPTIONAL_UNBOUND;
    }

    public Optional<TYPE> operator_assign(Base_Template.template_sel otherValue) {
        if (!Base_Template.template_sel.OMIT_VALUE.equals((Object)otherValue)) {
            throw new TtcnError("Internal error: Setting an optional field to an invalid value.");
        }
        this.set_to_omit();
        return this;
    }

    @Override
    public Optional<TYPE> operator_assign(Optional<?> otherValue) {
        switch (otherValue.optionalSelection) {
            case OPTIONAL_PRESENT: {
                if (optional_sel.OPTIONAL_PRESENT.equals((Object)this.optionalSelection)) {
                    ((Base_Type)this.optionalValue).operator_assign((Base_Type)otherValue.optionalValue);
                    break;
                }
                try {
                    this.optionalValue = (Base_Type)this.clazz.newInstance();
                }
                catch (Exception e) {
                    throw new TtcnError(MessageFormat.format("Internal Error: exception `{0}'' thrown while instantiating class of `{1}'' type", e.getMessage(), this.clazz.getName()));
                }
                ((Base_Type)this.optionalValue).operator_assign((Base_Type)otherValue.optionalValue);
                this.optionalSelection = optional_sel.OPTIONAL_PRESENT;
                break;
            }
            case OPTIONAL_OMIT: {
                if (otherValue == this) break;
                this.set_to_omit();
                break;
            }
            default: {
                this.clean_up();
            }
        }
        return this;
    }

    @Override
    public Optional<TYPE> operator_assign(Base_Type otherValue) {
        if (!(otherValue instanceof Optional)) {
            if (optional_sel.OPTIONAL_PRESENT.equals((Object)this.optionalSelection)) {
                ((Base_Type)this.optionalValue).operator_assign(otherValue);
            } else {
                try {
                    this.optionalValue = (Base_Type)this.clazz.newInstance();
                }
                catch (Exception e) {
                    throw new TtcnError(MessageFormat.format("Internal Error: exception `{0}'' thrown while instantiating class of `{1}'' type", e.getMessage(), this.clazz.getName()));
                }
                ((Base_Type)this.optionalValue).operator_assign(otherValue);
                this.optionalSelection = optional_sel.OPTIONAL_PRESENT;
            }
            return this;
        }
        Optional optionalOther = (Optional)otherValue;
        switch (optionalOther.optionalSelection) {
            case OPTIONAL_PRESENT: {
                if (optional_sel.OPTIONAL_PRESENT.equals((Object)this.optionalSelection)) {
                    ((Base_Type)this.optionalValue).operator_assign((Base_Type)optionalOther.optionalValue);
                    break;
                }
                try {
                    this.optionalValue = (Base_Type)this.clazz.newInstance();
                }
                catch (Exception e) {
                    throw new TtcnError(MessageFormat.format("Internal Error: exception `{0}'' thrown while instantiating class of `{1}'' type", e.getMessage(), this.clazz.getName()));
                }
                ((Base_Type)this.optionalValue).operator_assign((Base_Type)optionalOther.optionalValue);
                this.optionalSelection = optional_sel.OPTIONAL_PRESENT;
                break;
            }
            case OPTIONAL_OMIT: {
                if (optionalOther == this) break;
                this.set_to_omit();
                break;
            }
            default: {
                this.clean_up();
            }
        }
        return this;
    }

    public void set_to_present() {
        if (!optional_sel.OPTIONAL_PRESENT.equals((Object)this.optionalSelection)) {
            this.optionalSelection = optional_sel.OPTIONAL_PRESENT;
            try {
                this.optionalValue = (Base_Type)this.clazz.newInstance();
            }
            catch (Exception e) {
                throw new TtcnError(MessageFormat.format("Internal Error: exception `{0}'' thrown while instantiating class of `{1}'' type", e.getMessage(), this.clazz.getName()));
            }
        }
    }

    public void set_to_omit() {
        if (optional_sel.OPTIONAL_PRESENT.equals((Object)this.optionalSelection)) {
            this.optionalValue = null;
        }
        this.optionalSelection = optional_sel.OPTIONAL_OMIT;
    }

    public optional_sel get_selection() {
        return this.optionalSelection;
    }

    @Override
    public void set_implicit_omit() {
        if (this.is_present()) {
            ((Base_Type)this.optionalValue).set_implicit_omit();
        }
    }

    @Override
    public void log() {
        switch (this.optionalSelection) {
            case OPTIONAL_PRESENT: {
                ((Base_Type)this.optionalValue).log();
                break;
            }
            case OPTIONAL_OMIT: {
                TTCN_Logger.log_event_str("omit");
                break;
            }
            case OPTIONAL_UNBOUND: {
                TTCN_Logger.log_event_unbound();
            }
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Omit) {
            if (param.get_ifpresent()) {
                param.error("An optional field of a record value cannot have an 'ifpresent' attribute", new Object[0]);
            }
            if (param.get_length_restriction() != null) {
                param.error("An optional field of a record value cannot have a length restriction", new Object[0]);
            }
            this.set_to_omit();
            return;
        }
        this.set_to_present();
        ((Base_Type)this.optionalValue).set_param(param);
        if (!((Base_Type)this.optionalValue).is_bound()) {
            this.clean_up();
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        switch (this.optionalSelection) {
            case OPTIONAL_PRESENT: {
                return ((Base_Type)this.optionalValue).get_param(param_name);
            }
            case OPTIONAL_OMIT: {
                return new Param_Types.Module_Param_Omit();
            }
        }
        return new Param_Types.Module_Param_Unbound();
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        switch (this.optionalSelection) {
            case OPTIONAL_OMIT: {
                text_buf.push_int(0);
                break;
            }
            case OPTIONAL_PRESENT: {
                text_buf.push_int(1);
                ((Base_Type)this.optionalValue).encode_text(text_buf);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Text encoder: Encoding an unbound optional value.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        int temp = text_buf.pull_int().get_int();
        if (temp == 1) {
            this.set_to_present();
            ((Base_Type)this.optionalValue).decode_text(text_buf);
        } else {
            this.set_to_omit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        switch (this.optionalSelection) {
            case OPTIONAL_PRESENT: {
                return ((Base_Type)this.optionalValue).JSON_encode(p_td, p_tok);
            }
            case OPTIONAL_OMIT: {
                return p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_NULL, null);
            }
        }
        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound optional value.", new Object[0]);
        return -1;
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        AtomicReference<JSON_Tokenizer.json_token_t> token;
        this.set_to_present();
        int buf_pos = p_tok.get_buf_pos();
        int dec_len = 0;
        if (-2 == p_chosen_field) {
            token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
            dec_len = p_tok.get_next_token(token, null, null);
            if (JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_NULL == token.get()) {
                this.set_to_omit();
                return dec_len;
            }
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON token, expecting 'null' (as indicated by a condition in attribute 'chosen')%s", "");
            }
            p_tok.set_buf_pos(buf_pos);
        }
        if (-2 == (dec_len = ((Base_Type)this.optionalValue).JSON_decode(p_td, p_tok, p_silent, false, p_chosen_field))) {
            if (p_silent) {
                this.clean_up();
            } else {
                this.set_to_omit();
            }
        } else if (-1 == dec_len) {
            p_tok.set_buf_pos(buf_pos);
            token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
            dec_len = p_tok.get_next_token(token, null, null);
            if (JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_NULL == token.get()) {
                if (0 <= p_chosen_field && !p_silent) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Field cannot be omitted (as indicated by a condition in attribute 'chosen')%s", "");
                }
                this.set_to_omit();
            } else {
                dec_len = -1;
            }
        }
        return dec_len;
    }

    @Override
    public boolean is_bound() {
        switch (this.optionalSelection) {
            case OPTIONAL_PRESENT: 
            case OPTIONAL_OMIT: {
                return true;
            }
        }
        if (null != this.optionalValue) {
            return ((Base_Type)this.optionalValue).is_bound();
        }
        return false;
    }

    @Override
    public boolean is_present() {
        return optional_sel.OPTIONAL_PRESENT.equals((Object)this.optionalSelection);
    }

    public boolean ispresent() {
        switch (this.optionalSelection) {
            case OPTIONAL_PRESENT: {
                return true;
            }
            case OPTIONAL_OMIT: {
                return false;
            }
        }
        throw new TtcnError("Using an unbound optional field.");
    }

    @Override
    public boolean is_value() {
        return optional_sel.OPTIONAL_PRESENT.equals((Object)this.optionalSelection) && ((Base_Type)this.optionalValue).is_value();
    }

    @Override
    public boolean is_optional() {
        return true;
    }

    public TYPE get() {
        this.set_to_present();
        return this.optionalValue;
    }

    public TYPE constGet() {
        switch (this.optionalSelection) {
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Using the value of an unbound optional field ");
            }
            case OPTIONAL_OMIT: {
                throw new TtcnError("Using the value of an optional field containing omit.");
            }
        }
        return this.optionalValue;
    }

    public boolean operator_equals(Base_Template.template_sel otherValue) {
        if (optional_sel.OPTIONAL_UNBOUND.equals((Object)this.optionalSelection)) {
            if (Base_Template.template_sel.UNINITIALIZED_TEMPLATE.equals((Object)otherValue)) {
                return true;
            }
            throw new TtcnError("The left operand of comparison is an unbound optional value.");
        }
        if (!Base_Template.template_sel.OMIT_VALUE.equals((Object)otherValue)) {
            throw new TtcnError("Internal error: The right operand of comparison is an invalid value.");
        }
        return optional_sel.OPTIONAL_OMIT.equals((Object)this.optionalSelection);
    }

    public boolean operator_equals(Optional<TYPE> otherValue) {
        if (optional_sel.OPTIONAL_UNBOUND.equals((Object)this.optionalSelection)) {
            if (optional_sel.OPTIONAL_UNBOUND.equals((Object)otherValue.optionalSelection)) {
                return true;
            }
            throw new TtcnError("The left operand of comparison is an unbound optional value.");
        }
        if (optional_sel.OPTIONAL_UNBOUND.equals((Object)otherValue.optionalSelection)) {
            throw new TtcnError("The right operand of comparison is an unbound optional value.");
        }
        if (this.optionalSelection != otherValue.optionalSelection) {
            return false;
        }
        if (optional_sel.OPTIONAL_PRESENT.equals((Object)this.optionalSelection)) {
            return ((Base_Type)this.optionalValue).operator_equals((Base_Type)otherValue.optionalValue);
        }
        return true;
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (!(otherValue instanceof Optional)) {
            if (optional_sel.OPTIONAL_UNBOUND.equals((Object)this.optionalSelection)) {
                if (!otherValue.is_bound()) {
                    return true;
                }
                throw new TtcnError("The left operand of comparison is an unbound optional value.");
            }
            if (!otherValue.is_bound()) {
                throw new TtcnError("The right operand of comparison is an unbound optional value.");
            }
            if (optional_sel.OPTIONAL_PRESENT.equals((Object)this.optionalSelection)) {
                return ((Base_Type)this.optionalValue).operator_equals(otherValue);
            }
            return false;
        }
        Optional optionalOther = (Optional)otherValue;
        if (optional_sel.OPTIONAL_UNBOUND.equals((Object)this.optionalSelection)) {
            if (optional_sel.OPTIONAL_UNBOUND.equals((Object)optionalOther.optionalSelection)) {
                return true;
            }
            throw new TtcnError("The left operand of comparison is an unbound optional value.");
        }
        if (optional_sel.OPTIONAL_UNBOUND.equals((Object)optionalOther.optionalSelection)) {
            throw new TtcnError("The right operand of comparison is an unbound optional value.");
        }
        if (this.optionalSelection != optionalOther.optionalSelection) {
            return false;
        }
        if (optional_sel.OPTIONAL_PRESENT.equals((Object)this.optionalSelection)) {
            return ((Base_Type)this.optionalValue).operator_equals((Base_Type)optionalOther.optionalValue);
        }
        return true;
    }

    public boolean operator_not_equals(Base_Template.template_sel otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(Optional<TYPE> otherValue) {
        return !this.operator_equals(otherValue);
    }

    public static enum optional_sel {
        OPTIONAL_UNBOUND,
        OPTIONAL_OMIT,
        OPTIONAL_PRESENT;

    }
}

