/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.titan.runtime.core.TitanUniversalChar;
import org.eclipse.titan.runtime.core.TtcnError;

public class TTCN_Pattern {
    private static final Pattern PATTERN_DYNAMIC_REFERENCE = Pattern.compile("(.*?)\\{([A-Za-z][A-Za-z0-9_]*)\\}(.*)");
    private static final Pattern PATTERN_STATIC_REFERENCE = Pattern.compile("([A-Za-z][A-Za-z0-9_]*)\\}(.*)");
    private static final Pattern PATTERN_CHARSET_REFERENCE = Pattern.compile("\\\\N\\{([A-Za-z][A-Za-z0-9_]*)\\}(.*)");
    private static final Pattern PATTERN_UNICHAR_QUADRUPLE = Pattern.compile("\\{\\s*(0|[1-9][0-9]*)\\s*\\,\\s*(0|[1-9][0-9]*)\\s*\\,\\s*(0|[1-9][0-9]*)\\s*\\,\\s*(0|[1-9][0-9]*)\\s*\\}(.*)");
    private static final Pattern PATTERN_UNICHAR_USI_LIST = Pattern.compile("\\{\\s*(U\\+?[0-9A-Fa-f]+(\\s*\\,\\s*U\\+?[0-9A-Fa-f]+)*)\\s*\\}(.*)");
    private static final Pattern PATTERN_REPETITION_SINGLE = Pattern.compile("\\s*(\\d+)(.*)");
    private static final Pattern PATTERN_REPETITION_RANGE = Pattern.compile("\\(\\s*(\\d*)\\s*(,\\s*(\\d*))?\\s*\\)(.*)");
    private static final String METACHARS = "#()*+-?[\\]^{|}";

    public static Pattern convert_pattern(String ttcnPattern, boolean nocase) {
        return TTCN_Pattern.convert_pattern(ttcnPattern, nocase, null);
    }

    public static Pattern convert_pattern(String ttcnPattern, boolean nocase, Map<String, String> refs) {
        Pattern javaPattern = null;
        try {
            String javaPatternString = TTCN_Pattern.convert_pattern(ttcnPattern, refs);
            if (nocase) {
                javaPatternString = javaPatternString.toLowerCase();
            }
            javaPattern = Pattern.compile(javaPatternString);
        }
        catch (Exception e) {
            throw new TtcnError(MessageFormat.format("Cannot convert pattern \"{0}\" to POSIX-equivalent.", ttcnPattern));
        }
        return javaPattern;
    }

    public static boolean match(String s, Pattern javaPattern, boolean nocase) {
        boolean result = false;
        try {
            Matcher m = javaPattern.matcher(nocase ? s.toLowerCase() : s);
            result = m.matches();
        }
        catch (Exception e) {
            throw new TtcnError(MessageFormat.format("Pattern matching error: {0}", e.toString()));
        }
        return result;
    }

    public static String regexp(String s, Pattern javaPattern, int groupno, boolean nocase) {
        String result = "";
        String regexpPatternString = javaPattern.pattern();
        if (nocase) {
            regexpPatternString = "(?i)" + regexpPatternString;
        }
        if (s.contains("\n") || s.contains("\r")) {
            regexpPatternString = "(?s)" + regexpPatternString;
        }
        Pattern tempPattern = Pattern.compile(regexpPatternString);
        try {
            Matcher m = tempPattern.matcher(s);
            if (m.matches()) {
                result = m.group(groupno + 1);
            }
        }
        catch (Exception e) {
            throw new TtcnError(MessageFormat.format("Pattern matching error: {0}", e.toString()));
        }
        return result;
    }

    public static String regexp(String s, String ttcnPattern, int groupno, boolean nocase) {
        return TTCN_Pattern.regexp(s, TTCN_Pattern.convert_pattern(ttcnPattern, nocase), groupno, nocase);
    }

    private static String convert_pattern(String ttcnPattern, Map<String, String> refs) {
        StringBuilder javaPattern = new StringBuilder();
        String ttcnStaticPattern = TTCN_Pattern.convert_dynamic_references(ttcnPattern, refs);
        TTCN_Pattern.convert_static_pattern(ttcnStaticPattern, new AtomicInteger(0), javaPattern, refs);
        return javaPattern.toString();
    }

    private static String convert_dynamic_references(String ttcnPattern, Map<String, String> refs) {
        if (refs == null || refs.isEmpty()) {
            return ttcnPattern;
        }
        Matcher m = PATTERN_DYNAMIC_REFERENCE.matcher(ttcnPattern);
        while (m.matches()) {
            String ref = m.group(2);
            String refValue = refs.get(ref);
            ttcnPattern = m.group(1) + refValue + m.group(3);
            m = PATTERN_DYNAMIC_REFERENCE.matcher(ttcnPattern);
        }
        return ttcnPattern;
    }

    private static void convert_static_pattern(String ttcnPattern, AtomicInteger pos, StringBuilder javaPattern, Map<String, String> refs) {
        block11: while (pos.get() < ttcnPattern.length()) {
            char c = ttcnPattern.charAt(pos.getAndIncrement());
            switch (c) {
                case '?': {
                    javaPattern.append('.');
                    continue block11;
                }
                case '*': {
                    javaPattern.append(".*");
                    continue block11;
                }
                case '+': {
                    javaPattern.append('+');
                    continue block11;
                }
                case '\\': {
                    TTCN_Pattern.convert_escaped(ttcnPattern, pos, javaPattern, false, refs);
                    continue block11;
                }
                case '\"': {
                    char c2 = ttcnPattern.charAt(pos.getAndIncrement());
                    if (c2 == '\"') {
                        javaPattern.append('\"');
                        continue block11;
                    }
                    pos.decrementAndGet();
                    javaPattern.append('\"');
                    continue block11;
                }
                case '$': {
                    javaPattern.append("\\$");
                    continue block11;
                }
                case '[': {
                    javaPattern.append('[');
                    TTCN_Pattern.convert_set(ttcnPattern, pos, javaPattern, refs);
                    continue block11;
                }
                case '#': {
                    TTCN_Pattern.convert_repetition(ttcnPattern, pos, javaPattern);
                    continue block11;
                }
                case '{': {
                    javaPattern.append("\\{");
                    continue block11;
                }
            }
            javaPattern.append(c);
        }
    }

    private static boolean is_meta(char c) {
        return METACHARS.indexOf(c) >= 0;
    }

    private static void convert_escaped(String ttcnPattern, AtomicInteger pos, StringBuilder javaPattern, boolean isSet, Map<String, String> refs) {
        char c = ttcnPattern.charAt(pos.getAndIncrement());
        switch (c) {
            case 'd': {
                javaPattern.append(isSet ? "0-9" : "[0-9]");
                break;
            }
            case 'w': {
                javaPattern.append(isSet ? "0-9A-Za-z" : "[0-9A-Za-z]");
                break;
            }
            case 't': {
                javaPattern.append("\\t");
                break;
            }
            case 'n': {
                javaPattern.append(isSet ? "\\n-\\r" : "[\\n-\\r]");
                break;
            }
            case 'r': {
                javaPattern.append("\\r");
                break;
            }
            case 's': {
                javaPattern.append(isSet ? "\\t-\\r " : "[\\t-\\r ]");
                break;
            }
            case 'b': {
                javaPattern.append("\\b");
                break;
            }
            case 'f': {
                javaPattern.append("\\f");
                break;
            }
            case '\'': {
                javaPattern.append("\\'");
                break;
            }
            case '\"': {
                javaPattern.append("\\\"");
                break;
            }
            case 'q': {
                TTCN_Pattern.convert_unichar_list(ttcnPattern, pos, javaPattern);
                break;
            }
            case 'N': {
                TTCN_Pattern.convert_charset_reference(ttcnPattern, pos, javaPattern, isSet, refs);
                break;
            }
            default: {
                if (TTCN_Pattern.is_meta(c)) {
                    javaPattern.append('\\').append(c);
                    break;
                }
                throw new TtcnError("Escape character \\" + c + " is not supported at position " + pos.get());
            }
        }
    }

    private static void convert_set(String ttcnPattern, AtomicInteger pos, StringBuilder javaPattern, Map<String, String> refs) {
        char c = ttcnPattern.charAt(pos.getAndIncrement());
        if (c == '^') {
            javaPattern.append('^');
            c = ttcnPattern.charAt(pos.getAndIncrement());
        }
        while (c != ']') {
            switch (c) {
                case '\\': {
                    TTCN_Pattern.convert_escaped(ttcnPattern, pos, javaPattern, true, refs);
                    break;
                }
                case '^': {
                    throw new TtcnError("Character ^ can be only the first character of th set at position " + pos.get());
                }
                case '[': {
                    javaPattern.append("\\[");
                    break;
                }
                case '-': {
                    javaPattern.append('-');
                    break;
                }
                default: {
                    javaPattern.append(c);
                }
            }
            c = ttcnPattern.charAt(pos.getAndIncrement());
        }
        javaPattern.append(']');
    }

    private static void convert_static_reference(String ttcnPattern, AtomicInteger pos, StringBuilder javaPattern, Map<String, String> refs) {
        String input = ttcnPattern.substring(pos.get());
        Matcher m = PATTERN_STATIC_REFERENCE.matcher(input);
        if (!m.matches()) {
            throw new TtcnError("Invalid static reference at position " + pos.get());
        }
        int offset = m.toMatchResult().start(2);
        pos.getAndAdd(offset);
        String ref = m.group(1);
        String refValue = refs.get(ref);
        javaPattern.append(refValue);
    }

    private static void convert_charset_reference(String ttcnPattern, AtomicInteger pos, StringBuilder javaPattern, boolean isSet, Map<String, String> refs) {
        String input = ttcnPattern.substring(pos.get());
        Matcher m = PATTERN_CHARSET_REFERENCE.matcher(input);
        if (m.matches()) {
            int offset = m.toMatchResult().start(2);
            pos.getAndAdd(offset);
            javaPattern.append(isSet ? m.group(1) : '[' + m.group(1) + ']');
            pos.getAndAdd(m.group(1).length());
        } else {
            if (input == null) {
                throw new TtcnError("Invalid character set reference at position " + pos.get());
            }
            javaPattern.append(isSet ? input : '[' + input + ']');
            pos.getAndAdd(input.length());
        }
    }

    private static void convert_repetition(String ttcnPattern, AtomicInteger pos, StringBuilder javaPattern) {
        String input = ttcnPattern.substring(pos.get());
        Matcher m = PATTERN_REPETITION_SINGLE.matcher(input);
        if (m.matches()) {
            int offset = m.toMatchResult().start(2);
            pos.getAndAdd(offset);
            String valueStr = m.group(1);
            int value = Integer.parseInt(valueStr);
            javaPattern.append("{" + value + "}");
        } else {
            m = PATTERN_REPETITION_RANGE.matcher(input);
            if (m.matches()) {
                int offset = m.toMatchResult().start(4);
                pos.getAndAdd(offset);
                String minStr = m.group(1);
                String commaWithMaxStr = m.group(2);
                String maxStr = m.group(3);
                javaPattern.append('{');
                javaPattern.append(minStr.isEmpty() ? Character.valueOf('0') : minStr);
                if (commaWithMaxStr != null && !commaWithMaxStr.isEmpty()) {
                    javaPattern.append(',').append(maxStr);
                }
                javaPattern.append('}');
            } else {
                throw new TtcnError("Invalid pattern repetition at position " + pos.get());
            }
        }
    }

    private static void convert_unichar_list(String ttcnPattern, AtomicInteger pos, StringBuilder javaPattern) {
        String input = ttcnPattern.substring(pos.get());
        Matcher m = PATTERN_UNICHAR_USI_LIST.matcher(input);
        if (m.matches()) {
            String[] uchars;
            int offset = m.toMatchResult().start(3);
            pos.getAndAdd(offset);
            String ucharlist = m.group(1);
            for (String uchar : uchars = ucharlist.split("\\s*,\\s*")) {
                String hexstr = uchar.substring(1);
                int hex = Integer.parseInt(hexstr, 16);
                javaPattern.append(String.valueOf(Character.toChars(hex)));
            }
        } else {
            m = PATTERN_UNICHAR_QUADRUPLE.matcher(input);
            if (m.matches()) {
                int offset = m.toMatchResult().start(5);
                pos.getAndAdd(offset);
                String groupStr = m.group(1);
                String planeStr = m.group(2);
                String rowStr = m.group(3);
                String cellStr = m.group(4);
                int group = Integer.parseInt(groupStr);
                int plane = Integer.parseInt(planeStr);
                int row = Integer.parseInt(rowStr);
                int cell = Integer.parseInt(cellStr);
                TitanUniversalChar uc = new TitanUniversalChar((char)group, (char)plane, (char)row, (char)cell);
                javaPattern.append(uc.to_utf(true));
            } else {
                throw new TtcnError("Invalid unichar list at position " + pos.get());
            }
        }
    }
}

