/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.BER;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanAsn_Null
extends Base_Type {
    private static final BER.ASN_Tag[] TitanASN_Null_tag_ = new BER.ASN_Tag[]{new BER.ASN_Tag(BER.ASN_TagClass.ASN_TAG_UNIV, 5)};
    public static final BER.ASN_BERdescriptor TitanASN_Null_Ber_ = new BER.ASN_BERdescriptor(1, TitanASN_Null_tag_);
    public static final JSON.TTCN_JSONdescriptor TitanAsn_Null_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final Base_Type.TTCN_Typedescriptor TitanAsn_Null_descr_ = new Base_Type.TTCN_Typedescriptor("NULL", TitanASN_Null_Ber_, null, TitanAsn_Null_json_, null);
    private boolean boundFlag;

    public TitanAsn_Null() {
        this.boundFlag = false;
    }

    public TitanAsn_Null(Asn_Null_Type otherValue) {
        this.boundFlag = true;
    }

    public TitanAsn_Null(TitanAsn_Null otherValue) {
        otherValue.must_bound("Copying an unbound ASN.1 NULL value.");
        this.boundFlag = true;
    }

    @Override
    public void clean_up() {
        this.boundFlag = false;
    }

    public TitanAsn_Null operator_assign(Asn_Null_Type otherValue) {
        this.boundFlag = true;
        return this;
    }

    public TitanAsn_Null operator_assign(TitanAsn_Null otherValue) {
        otherValue.must_bound("Assignment of an unbound ASN.1 NULL value.");
        this.boundFlag = true;
        return this;
    }

    @Override
    public TitanAsn_Null operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanAsn_Null) {
            return this.operator_assign((TitanAsn_Null)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to ASN.1 NULL", otherValue));
    }

    public boolean operator_equals(Asn_Null_Type otherValue) {
        this.must_bound("The left operand of comparison is an unbound ASN.1 NULL value.");
        return true;
    }

    public boolean operator_equals(TitanAsn_Null otherValue) {
        this.must_bound("The left operand of comparison is an unbound ASN.1 NULL value.");
        otherValue.must_bound("The right operand of comparison is an unbound ASN.1 NULL value.");
        return true;
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanAsn_Null) {
            return this.operator_equals((TitanAsn_Null)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to ASN.1 NULL", otherValue));
    }

    public boolean operator_not_equals(Asn_Null_Type otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanAsn_Null otherValue) {
        return !this.operator_equals(otherValue);
    }

    @Override
    public boolean is_bound() {
        return this.boundFlag;
    }

    @Override
    public boolean is_present() {
        return this.boundFlag;
    }

    @Override
    public boolean is_value() {
        return this.boundFlag;
    }

    @Override
    public void log() {
        if (this.boundFlag) {
            TTCN_Logger.log_event_str("NULL");
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue(), "NULL value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        if (param.get_type() != Param_Types.Module_Parameter.type_t.MP_Asn_Null) {
            param.type_error("NULL value");
        }
        this.boundFlag = true;
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        return new Param_Types.Module_Param_Asn_Null();
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        if (!this.boundFlag) {
            throw new TtcnError("Text encoder: Encoding an ASN.1 NULL value.");
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.boundFlag = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound ASN.1 NULL value.", new Object[0]);
            return -1;
        }
        return p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_NULL);
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        int dec_len = p_tok.get_next_token(token, null, null);
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            }
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_LITERAL_NULL != token.get()) {
            return -1;
        }
        this.boundFlag = true;
        return dec_len;
    }

    public static boolean operator_equals(Asn_Null_Type parValue, TitanAsn_Null otherValue) {
        otherValue.must_bound("The right operand of comparison is an unbound ASN.1 NULL value.");
        return true;
    }

    public static boolean operator_not_equals(Asn_Null_Type parValue, TitanAsn_Null otherValue) {
        return !TitanAsn_Null.operator_equals(parValue, otherValue);
    }

    public static enum Asn_Null_Type {
        ASN_NULL_VALUE;

    }
}

