/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TitanHexString;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanHexString_Element {
    private boolean bound_flag;
    private final TitanHexString str_val;
    private final int nibble_pos;

    public TitanHexString_Element(boolean par_bound_flag, TitanHexString par_str_val, int par_nibble_pos) {
        this.bound_flag = par_bound_flag;
        this.str_val = par_str_val;
        this.nibble_pos = par_nibble_pos;
    }

    public boolean is_bound() {
        return this.bound_flag;
    }

    public boolean is_value() {
        return this.bound_flag;
    }

    public void must_bound(String errorMessage) {
        if (!this.bound_flag) {
            throw new TtcnError(errorMessage);
        }
    }

    public String toString() {
        if (this.str_val == null) {
            return "<unbound>";
        }
        StringBuilder sb = new StringBuilder();
        Byte digit = this.str_val.get_nibble(this.nibble_pos);
        sb.append("0123456789ABCDEF?*".charAt(digit.byteValue()));
        return sb.toString();
    }

    public TitanHexString_Element operator_assign(TitanHexString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound hexstring element.");
        this.bound_flag = true;
        this.str_val.set_nibble(this.nibble_pos, otherValue.str_val.get_nibble(otherValue.nibble_pos));
        return this;
    }

    public TitanHexString_Element operator_assign(TitanHexString otherValue) {
        otherValue.must_bound("Assignment of unbound hexstring value.");
        if (otherValue.get_value().length != 1) {
            throw new TtcnError("Assignment of a hexstring value with length other than 1 to a hexstring element.");
        }
        this.bound_flag = true;
        this.str_val.set_nibble(this.nibble_pos, otherValue.get_nibble(0));
        return this;
    }

    public boolean operator_equals(TitanHexString_Element otherValue) {
        this.must_bound("Unbound left operand of hexstring element comparison.");
        otherValue.must_bound("Unbound right operand of hexstring comparison.");
        return this.str_val.get_nibble(this.nibble_pos) == otherValue.str_val.get_nibble(otherValue.nibble_pos);
    }

    public boolean operator_equals(TitanHexString otherValue) {
        this.must_bound("Unbound left operand of hexstring element comparison.");
        otherValue.must_bound("Unbound right operand of hexstring element comparison.");
        if (otherValue.get_value().length != 1) {
            return false;
        }
        return this.str_val.get_nibble(this.nibble_pos) == otherValue.get_nibble(0);
    }

    public boolean operator_not_equals(TitanHexString_Element otherValue) {
        return !this.operator_equals(otherValue);
    }

    public boolean operator_not_equals(TitanHexString otherValue) {
        return !this.operator_equals(otherValue);
    }

    public TitanHexString operator_concatenate(TitanHexString other_value) {
        this.must_bound("Unbound left operand of hexstring element concatenation.");
        other_value.must_bound("Unbound right operand of hexstring concatenation.");
        byte[] src_ptr = other_value.get_value();
        int n_nibbles = src_ptr.length;
        byte[] dest_ptr = new byte[1 + n_nibbles];
        dest_ptr[0] = this.str_val.get_nibble(this.nibble_pos);
        System.arraycopy(src_ptr, 0, dest_ptr, 1, n_nibbles);
        return new TitanHexString(dest_ptr);
    }

    public TitanHexString operator_concatenate(TitanHexString_Element other_value) {
        this.must_bound("Unbound left operand of hexstring element concatenation.");
        other_value.must_bound("Unbound right operand of hexstring element concatenation.");
        return new TitanHexString(other_value.str_val);
    }

    public TitanHexString not4b() {
        this.must_bound("Unbound hexstring element operand of operator not4b.");
        byte result = (byte)(~this.str_val.get_nibble(this.nibble_pos) & 0xF);
        return new TitanHexString(result);
    }

    public TitanHexString and4b(TitanHexString other_value) {
        this.must_bound("Left operand of operator and4b is an unbound hexstring element.");
        other_value.must_bound("Right operand of operator and4b is an unbound hexstring value.");
        if (other_value.get_value().length != 1) {
            throw new TtcnError("The hexstring operands of operator and4b must have the same length.");
        }
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) & other_value.get_nibble(0));
        return new TitanHexString(result);
    }

    public TitanHexString and4b(TitanHexString_Element other_value) {
        this.must_bound("Left operand of operator and4b is an unbound hexstring element.");
        other_value.must_bound("Right operand of operator and4b is an unbound hexstring element.");
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) & other_value.str_val.get_nibble(other_value.nibble_pos));
        return new TitanHexString(result);
    }

    public TitanHexString or4b(TitanHexString other_value) {
        this.must_bound("Left operand of operator or4b is an unbound hexstring element.");
        other_value.must_bound("Right operand of operator or4b is an unbound hexstring value.");
        if (other_value.get_value().length != 1) {
            throw new TtcnError("The hexstring operands of operator or4b must have the same length.");
        }
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) | other_value.get_nibble(0));
        return new TitanHexString(result);
    }

    public TitanHexString or4b(TitanHexString_Element other_value) {
        this.must_bound("Left operand of operator or4b is an unbound hexstring element.");
        other_value.must_bound("Right operand of operator or4b is an unbound hexstring element.");
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) | other_value.str_val.get_nibble(other_value.nibble_pos));
        return new TitanHexString(result);
    }

    public TitanHexString xor4b(TitanHexString other_value) {
        this.must_bound("Left operand of operator xor4b is an unbound hexstring element.");
        other_value.must_bound("Right operand of operator xor4b is an unbound hexstring value.");
        if (other_value.get_value().length != 1) {
            throw new TtcnError("The hexstring operands of operator xor4b must have the same length.");
        }
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) ^ other_value.get_nibble(0));
        return new TitanHexString(result);
    }

    public TitanHexString xor4b(TitanHexString_Element other_value) {
        this.must_bound("Left operand of operator xor4b is an unbound hexstring element.");
        other_value.must_bound("Right operand of operator xor4b is an unbound hexstring element.");
        byte result = (byte)(this.str_val.get_nibble(this.nibble_pos) ^ other_value.str_val.get_nibble(other_value.nibble_pos));
        return new TitanHexString(result);
    }

    public TitanHexString shift_left(int shift_count) {
        this.must_bound("Unbound hexstring element operand of shift left operator.");
        if (shift_count == 0) {
            return new TitanHexString(this);
        }
        return new TitanHexString(0);
    }

    public TitanHexString shift_left(TitanInteger shift_count) {
        shift_count.must_bound("Unbound right operand of hexstring element shift left operator.");
        return this.shift_left(shift_count.get_int());
    }

    public TitanHexString shift_right(int shift_count) {
        this.must_bound("Unbound operand of hexstring element shift right operator.");
        if (shift_count == 0) {
            return new TitanHexString(this);
        }
        return new TitanHexString(0);
    }

    public TitanHexString shift_right(TitanInteger shift_count) {
        shift_count.must_bound("Unbound right operand of hexstring element right left operator.");
        return this.shift_right(shift_count.get_int());
    }

    public TitanHexString rotate_left(int rotate_count) {
        this.must_bound("Unbound hexstring element operand of rotate left operator.");
        return new TitanHexString(this);
    }

    public TitanHexString rotate_left(TitanInteger rotate_count) {
        rotate_count.must_bound("Unbound right operand of hexstring element rotate left operator.");
        return this.rotate_left(rotate_count.get_int());
    }

    public TitanHexString rotate_right(int rotateCount) {
        this.must_bound("Unbound hexstring element operand of rotate right operator.");
        return new TitanHexString(this);
    }

    public TitanHexString rotate_right(TitanInteger rotateCount) {
        rotateCount.must_bound("Unbound right operand of hexstring element rotate right operator.");
        return this.rotate_right(rotateCount.get_int());
    }

    public byte get_nibble() {
        return this.str_val.get_nibble(this.nibble_pos);
    }

    public void log() {
        if (this.bound_flag) {
            TTCN_Logger.log_char('\'');
            TTCN_Logger.log_hex(this.str_val.get_nibble(this.nibble_pos));
            TTCN_Logger.log_event_str("'H");
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }
}

