/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanUniversalChar {
    private char uc_group;
    private char uc_plane;
    private char uc_row;
    private char uc_cell;

    public TitanUniversalChar(char uc_group, char uc_plane, char uc_row, char uc_cell) {
        this.uc_group = uc_group;
        this.uc_plane = uc_plane;
        this.uc_row = uc_row;
        this.uc_cell = uc_cell;
    }

    public TitanUniversalChar(TitanUniversalChar uc) {
        this.uc_group = uc.uc_group;
        this.uc_plane = uc.uc_plane;
        this.uc_row = uc.uc_row;
        this.uc_cell = uc.uc_cell;
    }

    public TitanUniversalChar() {
    }

    public boolean is_char() {
        return this.getUc_group() == '\u0000' && this.getUc_plane() == '\u0000' && this.getUc_row() == '\u0000' && this.getUc_cell() < '\u0080';
    }

    public static boolean operator_equals(TitanUniversalChar left_value, TitanUniversalChar right_value) {
        return left_value.getUc_group() == right_value.getUc_group() && left_value.getUc_plane() == right_value.getUc_plane() && left_value.getUc_row() == right_value.getUc_row() && left_value.getUc_cell() == right_value.getUc_cell();
    }

    public boolean operator_equals(TitanUniversalChar right_value) {
        return TitanUniversalChar.operator_equals(this, right_value);
    }

    public static boolean operator_not_equals(TitanUniversalChar left_value, TitanUniversalChar right_value) {
        return !TitanUniversalChar.operator_equals(left_value, right_value);
    }

    public static boolean is_less_than(TitanUniversalChar left_value, TitanUniversalChar right_value) {
        if (left_value.getUc_group() < right_value.getUc_group()) {
            return true;
        }
        if (left_value.getUc_group() == right_value.getUc_group()) {
            if (left_value.getUc_plane() < right_value.getUc_plane()) {
                return true;
            }
            if (left_value.getUc_plane() == right_value.getUc_plane()) {
                if (left_value.getUc_row() < right_value.getUc_row()) {
                    return true;
                }
                if (left_value.getUc_row() == right_value.getUc_row()) {
                    return left_value.getUc_cell() < right_value.getUc_cell();
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean is_less_than(TitanUniversalChar right_value) {
        return TitanUniversalChar.is_less_than(this, right_value);
    }

    public char getUc_group() {
        return this.uc_group;
    }

    public char getUc_plane() {
        return this.uc_plane;
    }

    public char getUc_row() {
        return this.uc_row;
    }

    public char getUc_cell() {
        return this.uc_cell;
    }

    public String toString() {
        return "(" + this.uc_group + "," + this.uc_plane + "," + this.uc_row + "," + this.uc_cell + ")";
    }

    public String to_utf(boolean is_alone) {
        byte[] arr = new byte[]{(byte)(this.uc_group & 0xFF), (byte)(this.uc_plane & 0xFF), (byte)(this.uc_row & 0xFF), (byte)(this.uc_cell & 0xFF)};
        try {
            if (is_alone && arr[0] == 0 && arr[1] == 0 && arr[2] == -2 && arr[3] == -1) {
                return new String(arr, "UTF-32LE");
            }
            return new String(arr, "UTF-32");
        }
        catch (UnsupportedEncodingException e) {
            throw new TtcnError(MessageFormat.format("Cannot decode quadruple: {0}, {1}, {2}, {3}", Character.valueOf(this.uc_group), Character.valueOf(this.uc_plane), Character.valueOf(this.uc_row), Character.valueOf(this.uc_cell)));
        }
    }
}

