/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.views.executormonitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.titan.executor.executors.BaseExecutor;
import org.eclipse.titan.executor.executors.ITreeBranch;
import org.eclipse.titan.executor.executors.ITreeLeaf;
import org.eclipse.titan.executor.executors.TreeLeaf;
import org.eclipse.titan.executor.views.executormonitor.HostControllerElement;
import org.eclipse.titan.executor.views.executormonitor.InformationElement;

public final class MainControllerElement
extends TreeLeaf
implements ITreeBranch {
    private final BaseExecutor executor;
    private boolean terminated;
    private InformationElement stateInfo;
    private InformationElement pauseInfo;
    private InformationElement consoleLoggingInfo;
    private List<HostControllerElement> hostControllers;

    public MainControllerElement(String name, BaseExecutor executor) {
        super(name);
        this.executor = executor;
        this.terminated = false;
        this.hostControllers = new ArrayList<HostControllerElement>(1);
    }

    public BaseExecutor executor() {
        return this.executor;
    }

    public boolean getTerminated() {
        return this.terminated;
    }

    public void setTerminated() {
        this.terminated = true;
        this.stateInfo = null;
        this.pauseInfo = null;
        this.consoleLoggingInfo = null;
        this.hostControllers.clear();
    }

    public void setStateInfo(InformationElement stateInfo) {
        this.stateInfo = stateInfo;
        stateInfo.parent(this);
    }

    public void setPauseInfo(InformationElement pauseInfo) {
        this.pauseInfo = pauseInfo;
        pauseInfo.parent(this);
    }

    public void setConsoleLoggingInfo(InformationElement consoleLoggingInfo) {
        this.consoleLoggingInfo = consoleLoggingInfo;
        consoleLoggingInfo.parent(this);
    }

    public void addHostController(HostControllerElement hostController) {
        this.hostControllers.add(hostController);
        hostController.parent(this);
    }

    @Override
    public List<ITreeLeaf> children() {
        ArrayList<ITreeLeaf> result = new ArrayList<ITreeLeaf>();
        if (null != this.stateInfo) {
            result.add(this.stateInfo);
        }
        if (null != this.pauseInfo) {
            result.add(this.pauseInfo);
        }
        if (null != this.consoleLoggingInfo) {
            result.add(this.consoleLoggingInfo);
        }
        result.addAll(this.hostControllers);
        return result;
    }

    public void transferData(MainControllerElement other) {
        this.stateInfo = other.stateInfo;
        if (null != this.stateInfo) {
            this.stateInfo.parent(this);
        }
        this.pauseInfo = other.pauseInfo;
        if (null != this.pauseInfo) {
            this.pauseInfo.parent(this);
        }
        this.consoleLoggingInfo = other.consoleLoggingInfo;
        if (null != this.consoleLoggingInfo) {
            this.consoleLoggingInfo.parent(this);
        }
        List<HostControllerElement> oldHCs = this.hostControllers;
        this.hostControllers = new ArrayList<HostControllerElement>(other.hostControllers.size());
        for (HostControllerElement tempElement : other.hostControllers) {
            boolean found = false;
            Iterator<HostControllerElement> iterator = oldHCs.iterator();
            while (iterator.hasNext() && !found) {
                HostControllerElement oldElement = iterator.next();
                if (!oldElement.isSame(tempElement)) continue;
                oldElement.transferData(tempElement);
                this.hostControllers.add(oldElement);
                iterator.remove();
                found = true;
            }
            if (found) continue;
            this.hostControllers.add(tempElement);
            tempElement.parent(this);
        }
        other.hostControllers.clear();
    }
}

