/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.common.usagestats;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import org.eclipse.titan.common.utils.MapJoiner;

public class HttpPoster {
    private final String host;
    private final String page;
    private final int port;

    public HttpPoster(String host, String page, int port) {
        this.host = host;
        this.page = page;
        this.port = port;
    }

    public void post(Map<String, String> data) {
        int[] ports = new int[]{49555, 59555, 61555, 0};
        Socket socket = new Socket();
        for (int i = 0; i < ports.length; ++i) {
            try {
                socket.bind(new InetSocketAddress(InetAddress.getLocalHost(), ports[i]));
                break;
            }
            catch (IOException e) {
                if (!socket.isBound()) continue;
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        try {
            socket.connect(new InetSocketAddress(this.host, this.port));
            String urlParameters = new MapJoiner("&", "=").join(data).toString();
            DataOutputStream wr = new DataOutputStream(socket.getOutputStream());
            wr.writeBytes("POST " + this.page + " HTTP/1.0\r\nHost: " + this.host + "\r\nContent-type: application/x-www-form-urlencoded\r\nContent-length: " + Integer.toString(urlParameters.length()) + "\r\n\r\n");
            wr.writeBytes(urlParameters);
            wr.flush();
            wr.close();
            socket.close();
            return;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

