/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.ASN1Object;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.IObjectSet_Element;
import org.eclipse.titan.designer.AST.ASN1.Object.ASN1Objects;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectSetElementVisitor_checker;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectSetElementVisitor_codeGen;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectSetElementVisitor_objectCollector;
import org.eclipse.titan.designer.AST.ASN1.Object.Object_Definition;
import org.eclipse.titan.designer.AST.ASN1.Object.Referenced_ObjectSet;
import org.eclipse.titan.designer.AST.ASN1.ObjectSet;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;

public final class ObjectSet_definition
extends ObjectSet
implements IReferenceChainElement {
    private static final String DUPLICATED_UNIQUE_FIELD_VALUE = "Two objects in the set have the same identifier (UNIQUE) field value";
    private final Block mBlock;
    private List<IObjectSet_Element> objectSetElements = new ArrayList<IObjectSet_Element>();
    private ASN1Objects objects;
    private BuildTimestamp lastTimeGenerated = null;

    public ObjectSet_definition() {
        this.mBlock = null;
    }

    public ObjectSet_definition(Block aBlock) {
        this.mBlock = aBlock;
    }

    public ObjectSet_definition(ASN1Objects objects) {
        this.mBlock = null;
        this.objects = objects;
    }

    @Override
    public ObjectSet_definition newInstance() {
        ObjectSet_definition temp = null != this.mBlock ? new ObjectSet_definition(this.mBlock) : (null != this.objects ? new ObjectSet_definition(this.objects) : new ObjectSet_definition());
        for (int i = 0; i < this.objectSetElements.size(); ++i) {
            temp.addObjectSetElement(this.objectSetElements.get(i).newOseInstance());
        }
        temp.getObjectSetElements();
        return temp;
    }

    public final List<IObjectSet_Element> getObjectSetElements() {
        return this.objectSetElements;
    }

    public final void setObjectSetElements(List<IObjectSet_Element> objectSetElements) {
        this.objectSetElements = objectSetElements;
    }

    @Override
    public final String chainedDescription() {
        return this.getFullName();
    }

    @Override
    public final Location getChainLocation() {
        return this.getLocation();
    }

    public final void steelObjectSetElements(ObjectSet_definition definition) {
        if (null == definition) {
            return;
        }
        for (int i = 0; i < definition.getObjectSetElements().size(); ++i) {
            this.addObjectSetElement(definition.getObjectSetElements().get(i).newOseInstance());
        }
        definition.getObjectSetElements().clear();
    }

    @Override
    public final StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (int i = 0; i < this.objectSetElements.size(); ++i) {
            if (this.objectSetElements.get(i) != child) continue;
            return builder.append(".").append(String.valueOf(i + 1));
        }
        return builder;
    }

    @Override
    public final void setMyScope(Scope scope) {
        super.setMyScope(scope);
        for (IObjectSet_Element element : this.objectSetElements) {
            element.setMyScopeOse(scope);
        }
    }

    public final void addObjectSetElement(IObjectSet_Element element) {
        if (null != element) {
            element.setFullNameParent(this);
            this.objectSetElements.add(element);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        int i;
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isErroneous = false;
        if (null != this.mBlock && this.lastTimeChecked == null) {
            this.parseBlockObjectSetSpecifications();
        }
        ObjectSetElementVisitor_checker checker = new ObjectSetElementVisitor_checker(timestamp, this.location, this.myGovernor);
        for (i = 0; i < this.objectSetElements.size(); ++i) {
            IObjectSet_Element element = this.objectSetElements.get(i);
            element.setGenNameOse(this.getGenNameOwn(), Integer.toString(i + 1).toString());
            element.accept(checker);
        }
        this.lastTimeChecked = timestamp;
        this.createObjects(true);
        if (this.objectSetElements.size() != this.objects.getNofObjects()) {
            return;
        }
        for (i = 0; i < this.objects.getNofObjects() - 1; ++i) {
            IValue value = this.objects.getObjectByIndex(i).getUniqueFieldSettingValue();
            if (value == null) continue;
            for (int j = i + 1; j < this.objects.getNofObjects(); ++j) {
                IObjectSet_Element e2;
                IValue value2 = this.objects.getObjectByIndex(j).getUniqueFieldSettingValue();
                if (value2 == null || !value2.checkEquality(timestamp, value)) continue;
                String severity = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.reportDuplicatedUniqueFieldValue", "ignore", null);
                IObjectSet_Element e1 = this.objectSetElements.get(i);
                if (e1 instanceof ILocateableNode) {
                    ((ILocateableNode)((Object)e1)).getLocation().reportConfigurableSemanticProblem(severity, DUPLICATED_UNIQUE_FIELD_VALUE);
                }
                if (!((e2 = this.objectSetElements.get(j)) instanceof ILocateableNode)) continue;
                ((ILocateableNode)((Object)e2)).getLocation().reportConfigurableSemanticProblem(severity, DUPLICATED_UNIQUE_FIELD_VALUE);
            }
        }
    }

    @Override
    public final ObjectSet_definition getRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (1 != this.objectSetElements.size()) {
            return this;
        }
        IObjectSet_Element element = this.objectSetElements.get(0);
        if (!(element instanceof Referenced_ObjectSet)) {
            return this;
        }
        boolean newChain = null == referenceChain;
        IReferenceChain temporalReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        temporalReferenceChain.add(this);
        ObjectSet_definition result = ((Referenced_ObjectSet)element).getRefdLast(timestamp, temporalReferenceChain);
        if (newChain) {
            temporalReferenceChain.release();
        }
        return result;
    }

    @Override
    public final int getNofObjects() {
        this.createObjects(false);
        return this.objects.getNofObjects();
    }

    @Override
    public final ASN1Object getObjectByIndex(int index) {
        this.createObjects(false);
        return this.objects.getObjectByIndex(index);
    }

    public final ASN1Objects getObjs() {
        this.createObjects(false);
        return this.objects;
    }

    @Override
    public final void accept(ObjectSetElementVisitor_objectCollector v) {
        v.visitObjectSet(this, false);
    }

    private void parseBlockObjectSetSpecifications() {
        if (this.mBlock == null) {
            return;
        }
        Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock);
        if (parser == null) {
            return;
        }
        ObjectSet_definition temporalDefinition = parser.pr_special_ObjectSetSpec().definition;
        List<SyntacticErrorStorage> errors = parser.getErrorStorage();
        if (null != errors && !errors.isEmpty()) {
            for (int i = 0; i < errors.size(); ++i) {
                ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
            }
        }
        if (null == temporalDefinition) {
            this.isErroneous = true;
            return;
        }
        List<IObjectSet_Element> elements = temporalDefinition.getObjectSetElements();
        for (int i = 0; i < elements.size(); ++i) {
            this.addObjectSetElement(elements.get(i));
        }
        temporalDefinition.setObjectSetElements(null);
        this.setMyScope(this.getMyScope());
    }

    protected final void createObjects(boolean force) {
        if (null != this.objects && !force) {
            return;
        }
        if (null == this.myGovernor) {
            return;
        }
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        ObjectSetElementVisitor_objectCollector visitor = new ObjectSetElementVisitor_objectCollector(this, this.lastTimeChecked);
        for (int i = 0; i < this.objectSetElements.size(); ++i) {
            this.objectSetElements.get(i).accept(visitor);
        }
        this.objects = visitor.getObjects();
        this.objects.trimToSize();
    }

    @Override
    public final void addProposal(ProposalCollector propCollector, int index) {
        block5: {
            List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
            if (subreferences.size() <= index) {
                return;
            }
            ISubReference subreference = subreferences.get(index);
            if (!ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) break block5;
            if (subreferences.size() > index + 1) {
                for (int j = 0; j < this.objects.getNofObjects(); ++j) {
                    Object_Definition def = this.objects.getObjectByIndex(j);
                    def.addProposal(propCollector, index + 1);
                }
            } else {
                for (int j = 0; j < this.objects.getNofObjects(); ++j) {
                    Object_Definition def = this.objects.getObjectByIndex(j);
                    def.addProposal(propCollector, index);
                }
            }
        }
    }

    @Override
    public final void addDeclaration(DeclarationCollector declarationCollector, int index) {
        block5: {
            List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
            if (subreferences.size() <= index) {
                return;
            }
            ISubReference subreference = subreferences.get(index);
            if (!ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) break block5;
            if (subreferences.size() > index + 1) {
                for (int j = 0; j < this.objects.getNofObjects(); ++j) {
                    Object_Definition def = this.objects.getObjectByIndex(j);
                    def.addDeclaration(declarationCollector, index + 1);
                }
            } else {
                for (int j = 0; j < this.objects.getNofObjects(); ++j) {
                    Object_Definition def = this.objects.getObjectByIndex(j);
                    def.addDeclaration(declarationCollector, index);
                }
            }
        }
    }

    @Override
    protected final boolean memberAccept(ASTVisitor v) {
        if (this.objectSetElements != null) {
            for (IObjectSet_Element element : this.objectSetElements) {
                if (element.memberAccept(v)) continue;
                return false;
            }
        }
        return this.objects == null || this.objects.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        ObjectSetElementVisitor_codeGen osev = new ObjectSetElementVisitor_codeGen(this, aData);
        if (this.objectSetElements != null) {
            for (IObjectSet_Element element : this.objectSetElements) {
                element.accept(osev);
            }
        }
    }
}

