/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3;

public class Code {
    private static void translate_character(StringBuilder str, char c, boolean in_string) {
        switch (c) {
            case '\u0007': {
                str.append("\\a");
                break;
            }
            case '\b': {
                str.append("\\b");
                break;
            }
            case '\f': {
                str.append("\\f");
                break;
            }
            case '\n': {
                str.append("\\n");
                break;
            }
            case '\r': {
                str.append("\\r");
                break;
            }
            case '\t': {
                str.append("\\t");
                break;
            }
            case '\u000b': {
                str.append("\\v");
                break;
            }
            case '\\': {
                str.append("\\\\");
                break;
            }
            case '\'': {
                if (in_string) {
                    str.append('\'');
                    break;
                }
                str.append("\\'");
                break;
            }
            case '\"': {
                if (in_string) {
                    str.append("\\\"");
                    break;
                }
                str.append('\"');
                break;
            }
            case '?': {
                str.append('?');
                break;
            }
            default: {
                if (c < '\u0100' && !Character.isISOControl(c)) {
                    str.append(c);
                    break;
                }
                str.append(String.format(in_string ? "\\%03o" : "\\%o", Character.valueOf(c)));
            }
        }
    }

    public static String translate_character(char c) {
        StringBuilder str = new StringBuilder();
        Code.translate_character(str, c, false);
        return str.toString();
    }

    public static String translate_string(String src) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            Code.translate_character(str, src.charAt(i), true);
        }
        return str.toString();
    }
}

