/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.NamedBridgeScope;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IParameterisedAssignment;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public final class Def_Altstep
extends Definition
implements IParameterisedAssignment {
    private static final String FULLNAMEPART1 = ".<formal_parameter_list>";
    private static final String FULLNAMEPART2 = ".<runs_on_type>";
    private static final String FULLNAMEPART3 = ".<block>";
    private static final String FULLNAMEPART4 = ".<guards>";
    private static final String FULLNAMEPART5 = ".<mtc_type>";
    private static final String FULLNAMEPART6 = ".<system_type>";
    private static final String FULLNAMEPART7 = ".<finally_block>";
    private static final String DASHALLOWEDONLYFORTEMPLATES = "Using not used symbol (`-') as the default parameter is allowed only for modified templates";
    private static final String KIND = "altstep";
    private final FormalParameterList formalParList;
    private final Reference runsOnRef;
    private Component_Type runsOnType = null;
    private final Reference mtcRef;
    private Component_Type mtcType = null;
    private final Reference systemRef;
    private Component_Type systemType = null;
    private final StatementBlock block;
    private final AltGuards altGuards;
    private NamedBridgeScope bridgeScope = null;

    public Def_Altstep(Identifier identifier, FormalParameterList formalParameters, Reference runsOnRef, Reference mtcReference, Reference systemReference, StatementBlock block, AltGuards altGuards) {
        super(identifier);
        this.formalParList = formalParameters;
        this.runsOnRef = runsOnRef;
        this.mtcRef = mtcReference;
        this.systemRef = systemReference;
        this.block = block;
        this.altGuards = altGuards;
        if (this.formalParList != null) {
            this.formalParList.setMyDefinition(this);
            this.formalParList.setFullNameParent(this);
        }
        if (runsOnRef != null) {
            runsOnRef.setFullNameParent(this);
        }
        if (mtcReference != null) {
            mtcReference.setFullNameParent(this);
        }
        if (systemReference != null) {
            systemReference.setFullNameParent(this);
        }
        if (block != null) {
            block.setMyDefinition(this);
        }
        if (altGuards != null) {
            altGuards.setMyDefinition(this);
        }
    }

    public AltGuards getAltGuards() {
        return this.altGuards;
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_ALTSTEP;
    }

    public static String getKind() {
        return KIND;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.formalParList == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.runsOnRef == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.block == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.altGuards == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.mtcRef == child) {
            return builder.append(FULLNAMEPART5);
        }
        if (this.systemRef == child) {
            return builder.append(FULLNAMEPART6);
        }
        return builder;
    }

    @Override
    public FormalParameterList getFormalParameterList() {
        return this.formalParList;
    }

    @Override
    public String getProposalKind() {
        return KIND;
    }

    @Override
    public String getAssignmentName() {
        return KIND;
    }

    @Override
    public String getOutlineIcon() {
        return "altstep.gif";
    }

    @Override
    public String getProposalDescription() {
        StringBuilder nameBuilder = new StringBuilder(this.identifier.getDisplayName());
        nameBuilder.append('(');
        this.formalParList.getAsProposalDesriptionPart(nameBuilder);
        nameBuilder.append(')');
        return nameBuilder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.bridgeScope != null && this.bridgeScope.getParentScope() == scope) {
            return;
        }
        this.bridgeScope = new NamedBridgeScope();
        this.bridgeScope.setParentScope(scope);
        scope.addSubScope(this.getLocation(), this.bridgeScope);
        this.bridgeScope.setScopeMacroName(this.identifier.getDisplayName());
        super.setMyScope(this.bridgeScope);
        if (this.runsOnRef != null) {
            this.runsOnRef.setMyScope(this.bridgeScope);
        }
        if (this.mtcRef != null) {
            this.mtcRef.setMyScope(this.bridgeScope);
        }
        if (this.systemRef != null) {
            this.systemRef.setMyScope(this.bridgeScope);
        }
        this.formalParList.setMyScope(this.bridgeScope);
        if (this.block != null) {
            this.block.setMyScope(this.formalParList);
            this.altGuards.setMyScope(this.block);
            this.bridgeScope.addSubScope(this.block.getLocation(), this.block);
        }
        this.bridgeScope.addSubScope(this.formalParList.getLocation(), this.formalParList);
        if (this.altGuards != null) {
            for (int i = 0; i < this.altGuards.getNofAltguards(); ++i) {
                AltGuard ag = this.altGuards.getAltguardByIndex(i);
                StatementBlock sb = ag.getStatementBlock();
                if (sb == null) continue;
                this.bridgeScope.addSubScope(sb.getLocation(), sb);
            }
        }
    }

    public Component_Type getRunsOnType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnType;
    }

    public Reference getRunsOnReference(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.runsOnRef;
    }

    public Component_Type getMTCType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.mtcType;
    }

    public Component_Type getSystemType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.systemType;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        Module module;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.isUsed = false;
        this.runsOnType = null;
        this.mtcType = null;
        this.systemType = null;
        this.lastTimeChecked = timestamp;
        if (this.runsOnRef != null) {
            this.runsOnType = this.runsOnRef.chkComponentypeReference(timestamp);
            if (this.runsOnType != null) {
                Scope formalParlistPreviosScope = this.formalParList.getParentScope();
                if (formalParlistPreviosScope instanceof RunsOnScope && ((RunsOnScope)formalParlistPreviosScope).getParentScope() == this.myScope) {
                    ((RunsOnScope)formalParlistPreviosScope).setComponentType(this.runsOnType);
                } else {
                    RunsOnScope tempScope = new RunsOnScope(this.runsOnType, this.myScope);
                    this.formalParList.setMyScope(tempScope);
                }
            }
        }
        if (this.mtcRef != null) {
            this.mtcType = this.mtcRef.chkComponentypeReference(timestamp);
        }
        if (this.systemRef != null) {
            this.systemType = this.systemRef.chkComponentypeReference(timestamp);
        }
        if (this.formalParList.hasNotusedDefaultValue()) {
            this.formalParList.getLocation().reportSemanticError(DASHALLOWEDONLYFORTEMPLATES);
        }
        boolean canSkip = false;
        if (this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            canSkip = true;
        }
        if (!canSkip) {
            this.formalParList.reset();
        }
        this.formalParList.check(timestamp, this.getAssignmentType());
        if (canSkip) {
            return;
        }
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionAltstep", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.block != null) {
            this.block.check(timestamp);
            this.block.setCodeSection(GovernedSimple.CodeSectionType.CS_INLINE);
        }
        if (this.altGuards != null) {
            this.altGuards.setIsAltstep();
            this.altGuards.setMyAltguards(this.altGuards);
            this.altGuards.setMyLaicStmt(this.altGuards, null);
            this.altGuards.check(timestamp);
            this.altGuards.setCodeSection(GovernedSimple.CodeSectionType.CS_INLINE);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        if (this.block != null) {
            this.block.postCheck();
        }
        if (this.altGuards != null) {
            this.altGuards.postCheck();
        }
    }

    @Override
    public void postCheck() {
        Module module;
        if (this.myScope != null && (module = this.myScope.getModuleScope()) != null && module.getSkippedFromSemanticChecking()) {
            return;
        }
        super.postCheck();
        this.formalParList.postCheck();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(index).getReferenceType())) {
            return;
        }
        if (ISubReference.Subreference_type.parameterisedSubReference.equals((Object)subrefs.get(index).getReferenceType()) && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            StringBuilder patternBuilder = new StringBuilder(this.identifier.getDisplayName());
            patternBuilder.append('(');
            this.formalParList.getAsProposalPart(patternBuilder);
            patternBuilder.append(')');
            propCollector.addTemplateProposal(this.identifier.getDisplayName(), new Template(this.getProposalDescription(), "", propCollector.getContextIdentifier(), patternBuilder.toString(), false), TTCN3CodeSkeletons.SKELETON_IMAGE);
            super.addProposal(propCollector, index);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() <= index || ISubReference.Subreference_type.arraySubReference.equals((Object)subrefs.get(index).getReferenceType())) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            declarationCollector.addDeclaration(this);
        }
    }

    @Override
    public String getOutlineText() {
        StringBuilder text = new StringBuilder(this.identifier.getDisplayName());
        if (this.formalParList == null || this.lastTimeChecked == null) {
            return text.toString();
        }
        text.append('(');
        for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
            FormalParameter parameter;
            if (i != 0) {
                text.append(", ");
            }
            if (Assignment.Assignment_type.A_PAR_TIMER.semanticallyEquals((parameter = this.formalParList.getParameterByIndex(i)).getRealAssignmentType())) {
                text.append("timer");
                continue;
            }
            Type type = parameter.getType(this.lastTimeChecked);
            if (type == null) {
                text.append("Unknown type");
                continue;
            }
            text.append(type.getTypename());
        }
        text.append(')');
        return text.toString();
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0 && this.identifier != null) {
                    enveloped = true;
                } else {
                    this.removeBridge();
                    throw new ReParseException(result);
                }
            }
            if (this.formalParList != null) {
                if (enveloped) {
                    this.formalParList.updateSyntax(reparser, false);
                    reparser.updateLocation(this.formalParList.getLocation());
                } else if (reparser.envelopsDamage(this.formalParList.getLocation())) {
                    try {
                        this.formalParList.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.formalParList.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.runsOnRef != null) {
                if (enveloped) {
                    this.runsOnRef.updateSyntax(reparser, false);
                    reparser.updateLocation(this.runsOnRef.getLocation());
                } else if (reparser.envelopsDamage(this.runsOnRef.getLocation())) {
                    try {
                        this.runsOnRef.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.runsOnRef.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.mtcRef != null) {
                if (enveloped) {
                    this.mtcRef.updateSyntax(reparser, false);
                    reparser.updateLocation(this.mtcRef.getLocation());
                } else if (reparser.envelopsDamage(this.mtcRef.getLocation())) {
                    try {
                        this.mtcRef.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.mtcRef.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.systemRef != null) {
                if (enveloped) {
                    this.systemRef.updateSyntax(reparser, false);
                    reparser.updateLocation(this.systemRef.getLocation());
                } else if (reparser.envelopsDamage(this.systemRef.getLocation())) {
                    try {
                        this.systemRef.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.systemRef.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.altGuards != null) {
                if (enveloped) {
                    this.altGuards.updateSyntax(reparser, false);
                    reparser.updateLocation(this.altGuards.getLocation());
                } else if (reparser.envelopsDamage(this.altGuards.getLocation())) {
                    try {
                        this.altGuards.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.altGuards.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.block != null) {
                if (enveloped) {
                    this.block.updateSyntax(reparser, false);
                    reparser.updateLocation(this.block.getLocation());
                } else if (reparser.envelopsDamage(this.block.getLocation())) {
                    try {
                        this.block.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.block.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    try {
                        this.withAttributesPath.updateSyntax(reparser, true);
                        enveloped = true;
                        reparser.updateLocation(this.withAttributesPath.getLocation());
                    }
                    catch (ReParseException e) {
                        this.removeBridge();
                        throw e;
                    }
                }
            }
            if (!enveloped) {
                this.removeBridge();
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.formalParList != null) {
            this.formalParList.updateSyntax(reparser, false);
            reparser.updateLocation(this.formalParList.getLocation());
        }
        if (this.runsOnRef != null) {
            this.runsOnRef.updateSyntax(reparser, false);
            reparser.updateLocation(this.runsOnRef.getLocation());
        }
        if (this.mtcRef != null) {
            this.mtcRef.updateSyntax(reparser, false);
            reparser.updateLocation(this.mtcRef.getLocation());
        }
        if (this.systemRef != null) {
            this.systemRef.updateSyntax(reparser, false);
            reparser.updateLocation(this.systemRef.getLocation());
        }
        if (this.block != null) {
            this.block.updateSyntax(reparser, false);
            reparser.updateLocation(this.block.getLocation());
        }
        if (this.altGuards != null) {
            this.altGuards.updateSyntax(reparser, false);
            reparser.updateLocation(this.altGuards.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    private void removeBridge() {
        if (this.bridgeScope != null) {
            this.bridgeScope.remove();
            this.bridgeScope = null;
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.formalParList != null) {
            this.formalParList.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.runsOnRef != null) {
            this.runsOnRef.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.mtcRef != null) {
            this.mtcRef.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.systemRef != null) {
            this.systemRef.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.block != null) {
            this.block.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.altGuards != null) {
            this.altGuards.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.formalParList != null && !this.formalParList.accept(v)) {
            return false;
        }
        if (this.runsOnRef != null && !this.runsOnRef.accept(v)) {
            return false;
        }
        if (this.mtcRef != null && !this.mtcRef.accept(v)) {
            return false;
        }
        if (this.systemRef != null && !this.systemRef.accept(v)) {
            return false;
        }
        if (this.block != null && !this.block.accept(v)) {
            return false;
        }
        return this.altGuards == null || this.altGuards.accept(v);
    }

    public int nofBranches() {
        return this.altGuards.getNofAltguards();
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        FormalParameter formalParameter;
        int i;
        StringBuilder source = aData.getSrc();
        String genName = this.getGenName();
        this.formalParList.setGenName(genName);
        StringBuilder body = new StringBuilder();
        this.getLocation().create_location_object(aData, body, "ALTSTEP", this.getIdentifier().getDisplayName());
        if (aData.getAddSourceInfo()) {
            body.append("try {\n");
        }
        this.block.generateCode(aData, body);
        this.altGuards.generateCodeAltstep(aData, body);
        if (aData.getAddSourceInfo()) {
            body.append("} finally {\n");
            this.getLocation().release_location_object(aData, body);
            body.append("}\n");
        }
        StringBuilder formalParListCode = new StringBuilder();
        this.formalParList.generateCode(aData, formalParListCode);
        StringBuilder shadowObjects = new StringBuilder();
        this.formalParList.generateCodeSetUnbound(aData, shadowObjects);
        this.formalParList.generateCodeShadowObjects(aData, shadowObjects);
        aData.addBuiltinTypeImport("TitanAlt_Status");
        aData.addBuiltinTypeImport("TTCN_Default");
        aData.addCommonLibraryImport("TTCN_Snapshot");
        StringBuilder actualParameterList = this.formalParList.generateCodeActualParlist("");
        StringBuilder fullParamaterList = this.formalParList.generateCode(aData);
        source.append(MessageFormat.format("public static final TitanAlt_Status {0}_instance({1})\n", genName, fullParamaterList));
        source.append("{\n");
        source.append((CharSequence)shadowObjects);
        source.append((CharSequence)body);
        source.append("}\n\n");
        source.append(MessageFormat.format("public static final void {0}({1})\n", genName, fullParamaterList));
        source.append("{\n");
        source.append("altstep_begin: for( ; ; ) {\n");
        source.append("boolean block_flag = false;\n");
        source.append("TitanAlt_Status altstep_flag = TitanAlt_Status.ALT_UNCHECKED;\n");
        source.append("TitanAlt_Status default_flag = TitanAlt_Status.ALT_UNCHECKED;\n");
        source.append("for( ; ; ) {\n");
        source.append("TTCN_Snapshot.take_new(block_flag);\n");
        source.append("if (altstep_flag != TitanAlt_Status.ALT_NO) {\n");
        source.append(MessageFormat.format("altstep_flag = {0}_instance({1});\n", genName, actualParameterList));
        source.append("if (altstep_flag == TitanAlt_Status.ALT_YES || altstep_flag == TitanAlt_Status.ALT_BREAK) {\n");
        source.append("return;\n");
        source.append("} else if (altstep_flag == TitanAlt_Status.ALT_REPEAT) {\n");
        source.append("continue altstep_begin;\n");
        source.append("}\n");
        source.append("}\n");
        source.append("if (default_flag != TitanAlt_Status.ALT_NO) {\n");
        source.append("default_flag = TTCN_Default.try_altsteps();\n");
        source.append("if (default_flag == TitanAlt_Status.ALT_YES || default_flag == TitanAlt_Status.ALT_BREAK) {\n");
        source.append("return;\n");
        source.append("} else if (default_flag == TitanAlt_Status.ALT_REPEAT) {\n");
        source.append("continue altstep_begin;\n");
        source.append("}\n");
        source.append("}\n");
        source.append("if (altstep_flag == TitanAlt_Status.ALT_NO && default_flag == TitanAlt_Status.ALT_NO) {\n");
        source.append(MessageFormat.format("throw new TtcnError(\"None of the branches can be chosen in altstep {0}\");\n", this.identifier.getDisplayName()));
        source.append("} else {\n");
        source.append("block_flag = true;\n");
        source.append("}\n");
        source.append("}\n");
        source.append("}\n");
        source.append("}\n\n");
        aData.addBuiltinTypeImport("Default_Base");
        source.append(MessageFormat.format("static final class {0}_Default extends Default_Base '{'\n", genName));
        for (i = 0; i < this.formalParList.getNofParameters(); ++i) {
            formalParameter = this.formalParList.getParameterByIndex(i);
            source.append("private ");
            formalParameter.generateCodeObject(aData, source, "par_", true, false);
        }
        source.append(MessageFormat.format("public {0}_Default({1}) '{'\n", genName, fullParamaterList));
        source.append(MessageFormat.format("super(\"{0}\");\n", this.identifier.getDisplayName()));
        block5: for (i = 0; i < this.formalParList.getNofParameters(); ++i) {
            formalParameter = this.formalParList.getParameterByIndex(i);
            String FormalParName = formalParameter.getIdentifier().getName();
            switch (formalParameter.getAssignmentType()) {
                case A_PAR_TIMER: 
                case A_PAR_VAL_INOUT: 
                case A_PAR_VAL_OUT: 
                case A_PAR_TEMP_INOUT: 
                case A_PAR_TEMP_OUT: 
                case A_PAR_PORT: {
                    source.append(MessageFormat.format("par_{0} = {0};\n", FormalParName));
                    continue block5;
                }
                case A_PAR_VAL: 
                case A_PAR_VAL_IN: 
                case A_PAR_TEMP_IN: {
                    if (formalParameter.getEvaluationType() == FormalParameter.parameterEvaluationType.NORMAL_EVAL) {
                        source.append(MessageFormat.format("par_{0}.operator_assign({0});\n", FormalParName));
                        continue block5;
                    }
                    source.append(MessageFormat.format("par_{0} = {0};\n", FormalParName));
                    continue block5;
                }
                default: {
                    source.append(MessageFormat.format("par_{0}.operator_assign({0});\n", FormalParName));
                }
            }
        }
        source.append("}\n\n");
        StringBuilder prefixedActualParameterList = this.formalParList.generateCodeActualParlist("par_");
        source.append("@Override\n");
        source.append("public final TitanAlt_Status call_altstep() {\n");
        source.append(MessageFormat.format("return {0}_instance({1});\n", genName, prefixedActualParameterList));
        source.append("}\n\n");
        source.append("}\n\n");
        source.append(MessageFormat.format("public static final Default_Base activate_{0}({1}) '{'\n", genName, fullParamaterList));
        source.append(MessageFormat.format("return new {0}_Default({1});\n", genName, actualParameterList));
        source.append("}\n\n");
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText(KIND).addText(" ");
        this.hoverContent.addStyledText(this.getFullNameForDocComment(), 1);
        this.hoverContent.closeHeader();
        if (dc != null) {
            dc.addDescsContent(this.hoverContent);
            dc.addParamsContent(this.hoverContent, this.formalParList);
            dc.addVerdictsContent(this.hoverContent);
            dc.addRequirementsContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        } else if (this.formalParList != null && this.formalParList.getNofParameters() > 0) {
            this.hoverContent.addTag("Parameters");
            for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
                FormalParameter param = this.formalParList.getParameterByIndex(i);
                String paramType = param.getFormalParamType();
                StringBuilder sb = new StringBuilder(param.getIdentifier().getDisplayName());
                sb.append(" (").append(paramType != null ? paramType : "<?>").append(")");
                this.hoverContent.addIndentedText(sb.toString(), "");
            }
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n");
        if (this.formalParList != null && this.formalParList.getNofParameters() > 0) {
            for (int i = 0; i < this.formalParList.getNofParameters(); ++i) {
                FormalParameter param = this.formalParList.getParameterByIndex(i);
                sb.append(ind).append("@param").append(" ").append(param.getIdentifier().getDisplayName()).append("\n");
            }
        }
        sb.append(ind).append("@verdict").append(" pass ").append("\n").append(ind).append("@verdict").append(" fail ").append("\n").append(ind).append("@verdict").append(" inconc ").append("\n");
        sb.append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }
}

