/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.DocumentComment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NamingConventionHelper;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.PatternString;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.UnivCharString_Pattern_Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.IdentifierReparser;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.ui.IEditorPart;

public class Def_Var_Template
extends Definition {
    private static final String FULLNAMEPART1 = ".<type>";
    private static final String FULLNAMEPART2 = ".<initial_value>";
    public static final String PORTNOTALLOWED = "Template variable can not be defined for port type `{0}''";
    private static final String PARAMETRIZED_LOCAL_TEMPLATE_VAR = "Code generation for parameterized local template variable `{0}'' is not yet supported";
    private static final String KIND = " template variable definition";
    private final Type type;
    private final FormalParameterList mFormalParList;
    private TTCN3Template initialValue;
    private final TemplateRestriction.Restriction_type templateRestriction;
    private boolean generateRestrictionCheck = false;
    private boolean wasAssigned;

    public Def_Var_Template(TemplateRestriction.Restriction_type templateRestriction, Identifier identifier, Type type, FormalParameterList aFormalParList, TTCN3Template initialValue) {
        super(identifier);
        this.templateRestriction = templateRestriction;
        this.type = type;
        this.mFormalParList = aFormalParList;
        this.initialValue = initialValue;
        if (type != null) {
            type.setOwnertype(IType.TypeOwner_type.OT_VARTMPL_DEF, this);
            type.setFullNameParent(this);
        }
        if (initialValue != null) {
            initialValue.setFullNameParent(this);
            initialValue.setMyDefinition(this);
        }
    }

    @Override
    public Assignment.Assignment_type getAssignmentType() {
        return Assignment.Assignment_type.A_VAR_TEMPLATE;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.initialValue == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public String getAssignmentName() {
        return "template variable";
    }

    @Override
    public String getDescription() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAssignmentName()).append(" `");
        if (this.isLocal()) {
            builder.append(this.identifier.getDisplayName());
        } else {
            builder.append(this.getFullName());
        }
        builder.append('\'');
        return builder.toString();
    }

    @Override
    public String getOutlineIcon() {
        return "template_dynamic.gif";
    }

    @Override
    public int category() {
        int result = super.category();
        if (this.type != null) {
            result += this.type.category();
        }
        return result;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.initialValue != null) {
            this.initialValue.setMyScope(scope);
        }
    }

    @Override
    public Type getType(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.type;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isUsed = false;
        this.wasAssigned = false;
        NamingConventionHelper.checkConvention("org.eclipse.titan.designer.reportNamingConventionLocalVariableTemplate", this.identifier, this);
        NamingConventionHelper.checkNameContents(this.identifier, this.getMyScope().getModuleScope().getIdentifier(), this.getDescription());
        if (this.type == null) {
            this.lastTimeChecked = timestamp;
            return;
        }
        this.type.setGenName("_T_", this.getGenName());
        this.type.check(timestamp);
        if (this.initialValue == null) {
            return;
        }
        IType lastType = this.type.getTypeRefdLast(timestamp);
        switch (lastType.getTypetype()) {
            case TYPE_PORT: {
                this.location.reportSemanticError(MessageFormat.format(PORTNOTALLOWED, lastType.getFullName()));
                break;
            }
        }
        TTCN3Template realInitialValue = this.initialValue;
        this.initialValue.setMyGovernor(this.type);
        if (this.initialValue.getTemplatetype() == ITTCN3Template.Template_type.CSTR_PATTERN && lastType.getTypetype() == IType.Type_type.TYPE_UCHARSTRING && (realInitialValue = this.initialValue.setTemplatetype(timestamp, ITTCN3Template.Template_type.USTR_PATTERN)) instanceof UnivCharString_Pattern_Template) {
            ((UnivCharString_Pattern_Template)realInitialValue).getPatternstring().setPatterntype(PatternString.PatternType.UNIVCHARSTRING_PATTERN);
        }
        ITTCN3Template temporalValue = this.type.checkThisTemplateRef(timestamp, realInitialValue);
        temporalValue.checkThisTemplateGeneric(timestamp, this.type, true, true, true, true, false, this);
        this.generateRestrictionCheck = TemplateRestriction.check(timestamp, this, realInitialValue, null);
        realInitialValue.setCodeSection(GovernedSimple.CodeSectionType.CS_INLINE);
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        if (this.mFormalParList != null) {
            this.mFormalParList.reset();
            this.mFormalParList.check(timestamp, this.getAssignmentType());
            this.location.reportSemanticError(MessageFormat.format(PARAMETRIZED_LOCAL_TEMPLATE_VAR, this.getIdentifier()));
        }
        this.initialValue.setGenNameRecursive(this.getGenName());
        this.initialValue.setCodeSection(GovernedSimple.CodeSectionType.CS_INLINE);
    }

    public TTCN3Template getInitialValue() {
        return this.initialValue;
    }

    public void setWritten() {
        this.wasAssigned = true;
    }

    @Override
    public boolean checkIdentical(CompilationTimeStamp timestamp, Definition definition) {
        this.check(timestamp);
        definition.check(timestamp);
        if (!Assignment.Assignment_type.A_VAR_TEMPLATE.semanticallyEquals(definition.getAssignmentType())) {
            this.location.reportSemanticError(MessageFormat.format("Local definition `{0}'' is a template variable, but the definition inherited from component type `{1}'' is a {2}", this.identifier.getDisplayName(), definition.getMyScope().getFullName(), definition.getAssignmentName()));
            return false;
        }
        Def_Var_Template otherVariable = (Def_Var_Template)definition;
        if (!this.type.isIdentical(timestamp, otherVariable.type)) {
            String message = MessageFormat.format("Local template variable `{0}'' has type `{1}'', but the template variable inherited from component type `{2}'' has type `{3}''", this.identifier.getDisplayName(), this.type.getTypename(), otherVariable.getMyScope().getFullName(), otherVariable.type.getTypename());
            this.type.getLocation().reportSemanticError(message);
            return false;
        }
        if (this.initialValue != null) {
            if (otherVariable.initialValue == null) {
                this.initialValue.getLocation().reportSemanticWarning(MessageFormat.format("Local template variable `{0}'' has initial value, but the template variable inherited from component type `{1}'' does not", this.identifier.getDisplayName(), otherVariable.getMyScope().getFullName()));
            }
        } else if (otherVariable.initialValue != null) {
            this.location.reportSemanticWarning(MessageFormat.format("Local template variable `{0}'' does not have initial value, but the template variable inherited from component type `{1}'' has", this.identifier.getDisplayName(), otherVariable.getMyScope().getFullName()));
        }
        return true;
    }

    @Override
    public String getProposalKind() {
        StringBuilder builder = new StringBuilder();
        if (this.type != null) {
            this.type.getProposalDescription(builder);
        }
        builder.append(KIND);
        return builder.toString();
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int index) {
        List<ISubReference> subrefs = propCollector.getReference().getSubreferences();
        if (subrefs.size() <= index) {
            return;
        }
        if (subrefs.size() == index + 1 && this.identifier.getName().toLowerCase(Locale.ENGLISH).startsWith(subrefs.get(index).getId().getName().toLowerCase(Locale.ENGLISH))) {
            super.addProposal(propCollector, index);
        } else if (subrefs.size() > index + 1 && this.type != null && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            this.type.addProposal(propCollector, index + 1);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int index) {
        List<ISubReference> subrefs = declarationCollector.getReference().getSubreferences();
        if (subrefs.size() > index && this.identifier.getName().equals(subrefs.get(index).getId().getName())) {
            if (subrefs.size() > index + 1 && this.type != null) {
                this.type.addDeclaration(declarationCollector, index + 1);
            } else if (subrefs.size() == index + 1 && ISubReference.Subreference_type.fieldSubReference.equals((Object)subrefs.get(index).getReferenceType())) {
                declarationCollector.addDeclaration(this);
            }
        }
    }

    @Override
    public TemplateRestriction.Restriction_type getTemplateRestriction() {
        return this.templateRestriction;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        List<Integer> result = super.getPossibleExtensionStarterTokens();
        if (this.initialValue == null) {
            result.add(252);
        }
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            Location temporalIdentifier = this.identifier.getLocation();
            if (reparser.envelopsDamage(temporalIdentifier) || reparser.isExtending(temporalIdentifier)) {
                reparser.extendDamagedRegion(temporalIdentifier);
                IdentifierReparser r = new IdentifierReparser(reparser);
                int result = r.parseAndSetNameChanged();
                this.identifier = r.getIdentifier();
                if (result == 0 && this.identifier != null) {
                    enveloped = true;
                } else {
                    throw new ReParseException(result);
                }
            }
            if (this.type != null) {
                if (enveloped) {
                    this.type.updateSyntax(reparser, false);
                    reparser.updateLocation(this.type.getLocation());
                } else if (reparser.envelopsDamage(this.type.getLocation())) {
                    this.type.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.type.getLocation());
                }
            }
            if (this.initialValue != null) {
                if (enveloped) {
                    this.initialValue.updateSyntax(reparser, false);
                    reparser.updateLocation(this.initialValue.getLocation());
                } else if (reparser.envelopsDamage(this.initialValue.getLocation())) {
                    this.initialValue.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.initialValue.getLocation());
                }
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                    this.withAttributesPath.updateSyntax(reparser, true);
                    enveloped = true;
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                }
            }
            if (!enveloped) {
                throw new ReParseException();
            }
            return;
        }
        reparser.updateLocation(this.identifier.getLocation());
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.initialValue != null) {
            this.initialValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.initialValue.getLocation());
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.initialValue != null) {
            this.initialValue.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        return this.initialValue == null || this.initialValue.accept(v);
    }

    public boolean getWritten() {
        return this.wasAssigned;
    }

    @Override
    public void generateCode(JavaGenData aData, boolean cleanUp) {
        String genName = this.getGenName();
        StringBuilder sb = aData.getSrc();
        StringBuilder source = new StringBuilder();
        StringBuilder initComp = aData.getInitComp();
        String typeGeneratedName = this.type.getGenNameTemplate(aData, source);
        if (this.type.getTypetype().equals((Object)IType.Type_type.TYPE_ARRAY)) {
            Array_Type arrayType = (Array_Type)this.type;
            StringBuilder sbforTemp = aData.getCodeForType(arrayType.getGenNameOwn());
            arrayType.generateCodeValue(aData, sbforTemp);
            arrayType.generateCodeTemplate(aData, sbforTemp);
        }
        if (this.getMyScope() instanceof ComponentTypeBody) {
            source.append(MessageFormat.format("public static final ThreadLocal<{0}> {1} = new ThreadLocal<{0}>() '{'\n", typeGeneratedName, genName));
            source.append("@Override\n");
            source.append(MessageFormat.format("protected {0} initialValue() '{'\n", typeGeneratedName));
            source.append(MessageFormat.format("return new {0}();\n", typeGeneratedName));
            source.append("}\n");
            source.append("};\n");
            sb.append((CharSequence)source);
            if (this.initialValue != null) {
                IType initialGovernor = this.initialValue.getMyGovernor();
                if (initialGovernor.getTypetype() == IType.Type_type.TYPE_SEQUENCE_OF || initialGovernor.getTypetype() == IType.Type_type.TYPE_ARRAY) {
                    initComp.append(MessageFormat.format("{0}.get().remove_all_permutations();\n", genName));
                }
                this.initialValue.generateCodeInit(aData, initComp, genName + ".get()");
                if (this.templateRestriction != TemplateRestriction.Restriction_type.TR_NONE && this.generateRestrictionCheck) {
                    TemplateRestriction.generateRestrictionCheckCode(aData, initComp, this.location, genName + ".get()", this.templateRestriction);
                }
            } else if (cleanUp) {
                initComp.append(MessageFormat.format("{0}.get().clean_up();\n", genName));
            }
        } else {
            source.append(MessageFormat.format(" public static final {0} {1} = new {0}();\n", typeGeneratedName, genName));
            sb.append((CharSequence)source);
            if (this.initialValue != null) {
                this.initialValue.generateCodeInit(aData, initComp, genName);
                if (this.templateRestriction != TemplateRestriction.Restriction_type.TR_NONE && this.generateRestrictionCheck) {
                    TemplateRestriction.generateRestrictionCheckCode(aData, initComp, this.location, genName, this.templateRestriction);
                }
            } else if (cleanUp) {
                initComp.append(MessageFormat.format("{0}.clean_up();\n", genName));
            }
        }
    }

    @Override
    public void generateCodeString(JavaGenData aData, StringBuilder source) {
        String genName = this.getGenName();
        String typeGeneratedName = this.type.getGenNameTemplate(aData, source);
        if (this.type.getTypetype().equals((Object)IType.Type_type.TYPE_ARRAY)) {
            Array_Type arrayType = (Array_Type)this.type;
            StringBuilder sb = aData.getCodeForType(arrayType.getGenNameOwn());
            arrayType.generateCodeValue(aData, sb);
            arrayType.generateCodeTemplate(aData, sb);
        }
        if (this.initialValue != null && this.initialValue.hasSingleExpression()) {
            source.append(MessageFormat.format("final {0} {1} = new {0}({2});\n", typeGeneratedName, genName, this.initialValue.getSingleExpression(aData, false)));
        } else {
            source.append(MessageFormat.format("final {0} {1} = new {0}();\n", typeGeneratedName, genName));
            if (this.initialValue != null) {
                this.initialValue.generateCodeInit(aData, source, genName);
                if (this.templateRestriction != TemplateRestriction.Restriction_type.TR_NONE && this.generateRestrictionCheck) {
                    TemplateRestriction.generateRestrictionCheckCode(aData, source, this.location, genName, this.templateRestriction);
                }
            }
        }
    }

    @Override
    public void generateCodeInitComp(JavaGenData aData, StringBuilder initComp, Definition definition) {
        if (this.initialValue != null) {
            this.initialValue.generateCodeInit(aData, initComp, definition.getGenNameFromScope(aData, initComp, ""));
            if (this.templateRestriction != TemplateRestriction.Restriction_type.TR_NONE && this.generateRestrictionCheck) {
                TemplateRestriction.generateRestrictionCheckCode(aData, initComp, this.location, this.genName, this.templateRestriction);
            }
        }
    }

    @Override
    public Ttcn3HoverContent getHoverContent(IEditorPart editor) {
        super.getHoverContent(editor);
        DocumentComment dc = null;
        if (this.hasDocumentComment() && (dc = this.parseDocumentComment()).isDeprecated()) {
            this.hoverContent.addDeprecated();
        }
        Type assType = this.getType(this.getLastTimeChecked());
        this.hoverContent.addIcon(this.getOutlineIcon());
        this.hoverContent.addText("var template ");
        this.hoverContent.addStyledText(assType != null ? assType.getTypename() : "<?>").addStyledText(" ").addStyledText(this.getFullNameForDocComment(), 1);
        this.hoverContent.closeHeader();
        if (dc != null) {
            dc.addDescsContent(this.hoverContent);
            dc.addMembersContent(this.hoverContent);
            dc.addStatusContent(this.hoverContent);
            dc.addRemarksContent(this.hoverContent);
            dc.addSinceContent(this.hoverContent);
            dc.addVersionContent(this.hoverContent);
            dc.addAuthorsContent(this.hoverContent);
            dc.addReferenceContent(this.hoverContent);
            dc.addSeesContent(this.hoverContent);
            dc.addUrlsContent(this.hoverContent);
        }
        this.hoverContent.addContent(HoverContentType.INFO);
        return this.hoverContent;
    }

    @Override
    public String generateDocComment(String indentation) {
        String ind = indentation + " * ";
        StringBuilder sb = new StringBuilder();
        sb.append("/**\n").append(ind).append("@desc").append("\n").append(indentation).append(" */\n").append(indentation);
        return sb.toString();
    }

    public TTCN3Template stealValue() {
        TTCN3Template retval = this.initialValue;
        this.initialValue = null;
        return retval;
    }
}

