/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Sequence_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Type;
import org.eclipse.titan.designer.AST.ASN1.types.Open_Type;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplates;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.Anytype_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValues;
import org.eclipse.titan.designer.AST.TTCN3.values.Sequence_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Named_Template_List
extends TTCN3Template {
    private static final String ALLARENOTUSED = "All elements of value list notation for type `{0}'' are not used symbols (`-'')";
    private static final String TOOMANYELEMENTS = "Too many elements in value list notation for type `{0}'': {1} was expected instead of {2}";
    private final NamedTemplates namedTemplates;
    private Sequence_Value asValue = null;

    public Named_Template_List(NamedTemplates namedTemplates) {
        this.namedTemplates = namedTemplates;
        namedTemplates.setFullNameParent(this);
    }

    public static Named_Template_List convert(CompilationTimeStamp timestamp, Template_List other) {
        boolean allNotUsed;
        int upperLimit;
        IType lastType = other.getMyGovernor().getTypeRefdLast(timestamp);
        int nofTemplates = other.getNofTemplates();
        int nofTypeComponents = 0;
        switch (lastType.getTypetype()) {
            case TYPE_TTCN3_SEQUENCE: {
                nofTypeComponents = ((TTCN3_Sequence_Type)lastType).getNofComponents();
                break;
            }
            case TYPE_ASN1_SEQUENCE: {
                nofTypeComponents = ((ASN1_Sequence_Type)lastType).getNofComponents();
                break;
            }
            case TYPE_SIGNATURE: {
                nofTypeComponents = ((Signature_Type)lastType).getNofParameters();
                break;
            }
            case TYPE_TTCN3_SET: {
                nofTypeComponents = ((TTCN3_Set_Type)lastType).getNofComponents();
                break;
            }
            case TYPE_ASN1_SET: {
                nofTypeComponents = ((ASN1_Set_Type)lastType).getNofComponents();
                break;
            }
        }
        if (nofTemplates > nofTypeComponents) {
            other.getLocation().reportSemanticError(MessageFormat.format(TOOMANYELEMENTS, lastType.getTypename(), nofTypeComponents, nofTemplates));
            other.setIsErroneous(true);
        }
        if (nofTemplates <= nofTypeComponents) {
            upperLimit = nofTemplates;
            allNotUsed = true;
        } else {
            upperLimit = nofTypeComponents;
            allNotUsed = false;
        }
        NamedTemplates namedTemplates = new NamedTemplates();
        for (int i = 0; i < upperLimit; ++i) {
            TTCN3Template template = other.getTemplateByIndex(i);
            if (ITTCN3Template.Template_type.TEMPLATE_NOTUSED.equals((Object)template.getTemplatetype())) continue;
            allNotUsed = false;
            Identifier identifier = null;
            switch (lastType.getTypetype()) {
                case TYPE_TTCN3_SEQUENCE: {
                    identifier = ((TTCN3_Sequence_Type)lastType).getComponentIdentifierByIndex(i);
                    break;
                }
                case TYPE_ASN1_SEQUENCE: {
                    identifier = ((ASN1_Sequence_Type)lastType).getComponentIdentifierByIndex(i);
                    break;
                }
                case TYPE_SIGNATURE: {
                    identifier = ((Signature_Type)lastType).getParameterIdentifierByIndex(i);
                    break;
                }
                case TYPE_TTCN3_SET: {
                    identifier = ((TTCN3_Set_Type)lastType).getComponentIdentifierByIndex(i);
                    break;
                }
                case TYPE_ASN1_SET: {
                    identifier = ((ASN1_Set_Type)lastType).getComponentIdentifierByIndex(i);
                    break;
                }
            }
            if (identifier == null) continue;
            NamedTemplate namedTemplate = new NamedTemplate(identifier.newInstance(), template);
            namedTemplate.setLocation(template.getLocation());
            namedTemplates.addTemplate(namedTemplate);
        }
        namedTemplates.setMyScope(other.getMyScope());
        namedTemplates.setFullNameParent(other);
        if (allNotUsed && nofTemplates > 0 && !IType.Type_type.TYPE_SIGNATURE.equals((Object)lastType.getTypetype())) {
            other.getLocation().reportSemanticWarning(MessageFormat.format(ALLARENOTUSED, lastType.getTypename()));
            other.setIsErroneous(true);
        }
        Named_Template_List target = new Named_Template_List(namedTemplates);
        target.copyGeneralProperties(other);
        return target;
    }

    public void addNamedValue(NamedTemplate template) {
        if (template != null) {
            this.namedTemplates.addTemplate(template);
            template.setMyScope(this.myScope);
        }
    }

    public boolean hasNamedTemplate(Identifier name) {
        if (name == null || this.namedTemplates == null) {
            return false;
        }
        return this.namedTemplates.hasNamedTemplateWithName(name);
    }

    public NamedTemplate getNamedTemplate(Identifier name) {
        if (name == null || this.namedTemplates == null) {
            return null;
        }
        return this.namedTemplates.getNamedTemplateByName(name);
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous assignment notation";
        }
        return "assignment notation";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        int size = this.namedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            NamedTemplate namedTemplate = this.namedTemplates.getTemplateByIndex(i);
            builder.append(namedTemplate.getName().getDisplayName());
            builder.append(" := ");
            builder.append(namedTemplate.getTemplate().createStringRepresentation());
        }
        builder.append(" }");
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.namedTemplates != null) {
            this.namedTemplates.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        int size = this.namedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            this.namedTemplates.getTemplateByIndex(i).getTemplate().setCodeSection(codeSection);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.setCodeSection(codeSection);
        }
    }

    public void removeGeneratedValues() {
        if (this.namedTemplates != null) {
            this.namedTemplates.removeGeneratedValues();
        }
    }

    public int getNofTemplates() {
        return this.namedTemplates.getNofTemplates();
    }

    public NamedTemplate getTemplateByIndex(int index) {
        return this.namedTemplates.getTemplateByIndex(index);
    }

    @Override
    public boolean isValue(CompilationTimeStamp timestamp) {
        if (this.lengthRestriction != null || this.isIfpresent || this.getIsErroneous(timestamp)) {
            return false;
        }
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (this.namedTemplates.getTemplateByIndex(i).getTemplate().isValue(timestamp)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IValue getValue() {
        if (this.asValue != null) {
            return this.asValue;
        }
        NamedValues values = new NamedValues();
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            NamedTemplate namedTemplate = this.namedTemplates.getTemplateByIndex(i);
            NamedValue namedValue = new NamedValue(namedTemplate.getName(), namedTemplate.getTemplate().getValue());
            namedValue.setLocation(namedTemplate.getLocation());
            values.addNamedValue(namedValue);
        }
        this.asValue = new Sequence_Value(values);
        this.asValue.setLocation(this.getLocation());
        this.asValue.setMyScope(this.getMyScope());
        this.asValue.setFullNameParent(this.getNameParent());
        this.asValue.setMyGovernor(this.getMyGovernor());
        return this.asValue;
    }

    @Override
    public boolean checkExpressionSelfReferenceTemplate(CompilationTimeStamp timestamp, Assignment lhs) {
        int size = this.namedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            if (!this.namedTemplates.getTemplateByIndex(i).getTemplate().checkExpressionSelfReferenceTemplate(timestamp, lhs)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        int size = this.namedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            TTCN3Template temp = this.namedTemplates.getTemplateByIndex(i).getTemplate();
            if (temp == null) continue;
            temp.checkSpecificValue(timestamp, true);
        }
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            for (int i = 0; i < this.namedTemplates.getNofTemplates(); ++i) {
                NamedTemplate template = this.namedTemplates.getTemplateByIndex(i);
                if (template == null) continue;
                referenceChain.markState();
                template.getTemplate().checkRecursions(timestamp, referenceChain);
                referenceChain.previousState();
            }
        }
    }

    @Override
    public boolean chkRestrictionNamedListBaseTemplate(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Set<String> checkedNames, int neededCheckedCnt, Location usageLocation) {
        boolean needsRuntimeCheck = false;
        if (checkedNames.size() >= neededCheckedCnt) {
            return needsRuntimeCheck;
        }
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            TTCN3Template tmpl = this.namedTemplates.getTemplateByIndex(i).getTemplate();
            String name = this.namedTemplates.getTemplateByIndex(i).getName().getName();
            if (checkedNames.contains(name)) continue;
            if (tmpl.checkValueomitRestriction(timestamp, definitionName, true, usageLocation)) {
                needsRuntimeCheck = true;
            }
            checkedNames.add(name);
        }
        if (this.baseTemplate instanceof Named_Template_List && ((Named_Template_List)this.baseTemplate).chkRestrictionNamedListBaseTemplate(timestamp, definitionName, omitAllowed, checkedNames, neededCheckedCnt, usageLocation)) {
            needsRuntimeCheck = true;
        }
        return needsRuntimeCheck;
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (omitAllowed) {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
        } else {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
        }
        boolean needsRuntimeCheck = false;
        int neededCheckedCnt = 0;
        HashSet<String> checkedNames = new HashSet<String>();
        if (this.baseTemplate != null && this.myGovernor != null) {
            switch (this.myGovernor.getTypetype()) {
                case TYPE_TTCN3_SEQUENCE: {
                    neededCheckedCnt = ((TTCN3_Sequence_Type)this.myGovernor).getNofComponents();
                    break;
                }
                case TYPE_ASN1_SEQUENCE: {
                    neededCheckedCnt = ((ASN1_Sequence_Type)this.myGovernor).getNofComponents();
                    break;
                }
                case TYPE_TTCN3_SET: {
                    neededCheckedCnt = ((TTCN3_Set_Type)this.myGovernor).getNofComponents();
                    break;
                }
                case TYPE_ASN1_SET: {
                    neededCheckedCnt = ((ASN1_Set_Type)this.myGovernor).getNofComponents();
                    break;
                }
                case TYPE_SIGNATURE: {
                    neededCheckedCnt = ((Signature_Type)this.myGovernor).getNofParameters();
                    break;
                }
            }
        }
        int size = this.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            NamedTemplate temp = this.namedTemplates.getTemplateByIndex(i);
            if (temp.getTemplate().checkValueomitRestriction(timestamp, definitionName, true, usageLocation)) {
                needsRuntimeCheck = true;
            }
            if (neededCheckedCnt <= 0) continue;
            checkedNames.add(temp.getName().getName());
        }
        if (neededCheckedCnt > 0 && this.baseTemplate instanceof Named_Template_List && ((Named_Template_List)this.baseTemplate).chkRestrictionNamedListBaseTemplate(timestamp, definitionName, omitAllowed, checkedNames, neededCheckedCnt, usageLocation)) {
            needsRuntimeCheck = true;
        }
        return needsRuntimeCheck;
    }

    @Override
    public ITTCN3Template getReferencedSetSequenceFieldTemplate(CompilationTimeStamp timestamp, Identifier fieldIdentifier, Reference reference, IReferenceChain referenceChain, boolean silent) {
        if (this.hasNamedTemplate(fieldIdentifier)) {
            return this.getNamedTemplate(fieldIdentifier).getTemplate();
        }
        if (this.baseTemplate != null) {
            TTCN3Template temp = this.baseTemplate.getTemplateReferencedLast(timestamp, referenceChain);
            if (temp == null) {
                return null;
            }
            return temp.getReferencedFieldTemplate(timestamp, fieldIdentifier, reference, referenceChain, silent);
        }
        if (!reference.getUsedInIsbound() && !silent) {
            reference.getLocation().reportSemanticError(MessageFormat.format("Reference to unbound field `{0}''.", fieldIdentifier.getDisplayName()));
        }
        return null;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.updateSyntax(reparser, false);
            reparser.updateLocation(this.lengthRestriction.getLocation());
        }
        if (this.baseTemplate instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.baseTemplate)).updateSyntax(reparser, false);
            reparser.updateLocation(this.baseTemplate.getLocation());
        } else if (this.baseTemplate != null) {
            throw new ReParseException();
        }
        this.namedTemplates.updateSyntax(reparser, false);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        NamedTemplate nt;
        IType govLast;
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.asValue != null) {
            this.asValue.findReferences(referenceFinder, foundIdentifiers);
            return;
        }
        if (this.namedTemplates == null) {
            return;
        }
        if (referenceFinder.assignment.getAssignmentType() == Assignment.Assignment_type.A_TYPE && referenceFinder.fieldId != null && this.myGovernor != null && referenceFinder.type == (govLast = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp())) && (nt = this.namedTemplates.getNamedTemplateByName(referenceFinder.fieldId)) != null) {
            foundIdentifiers.add(new ReferenceFinder.Hit(nt.getName()));
        }
        this.namedTemplates.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return !(this.asValue != null ? !this.asValue.accept(v) : this.namedTemplates != null && !this.namedTemplates.accept(v));
    }

    @Override
    public void setGenNamePrefix(String prefix) {
        super.setGenNamePrefix(prefix);
        for (int i = 0; i < this.namedTemplates.getNofTemplates(); ++i) {
            this.namedTemplates.getTemplateByIndex(i).getTemplate().setGenNamePrefix(prefix);
        }
    }

    @Override
    public void setGenNameRecursive(String parameterGenName) {
        super.setGenNameRecursive(parameterGenName);
        if (this.myGovernor == null) {
            return;
        }
        for (int i = 0; i < this.namedTemplates.getNofTemplates(); ++i) {
            NamedTemplate namedTemplate = this.namedTemplates.getTemplateByIndex(i);
            String javaGetterName = FieldSubReference.getJavaGetterName(namedTemplate.getName().getName());
            String embeddedName = MessageFormat.format("{0}.get_field_{1}()", parameterGenName, javaGetterName);
            namedTemplate.getTemplate().setGenNameRecursive(embeddedName);
        }
    }

    @Override
    public boolean needsTemporaryReference() {
        if (this.lengthRestriction != null || this.isIfpresent) {
            return true;
        }
        return this.namedTemplates.getNofTemplates() > 0;
    }

    @Override
    public boolean hasSingleExpression() {
        if (this.lengthRestriction != null || this.isIfpresent || this.get_needs_conversion()) {
            return false;
        }
        if (this.myGovernor == null) {
            return false;
        }
        switch (this.myGovernor.getTypetype()) {
            case TYPE_TTCN3_SEQUENCE: {
                return ((TTCN3_Sequence_Type)this.myGovernor).getNofComponents() == 0;
            }
            case TYPE_ASN1_SEQUENCE: {
                return ((ASN1_Sequence_Type)this.myGovernor).getNofComponents() == 0;
            }
            case TYPE_SIGNATURE: {
                return ((Signature_Type)this.myGovernor).getNofParameters() == 0;
            }
            case TYPE_TTCN3_SET: {
                return ((TTCN3_Set_Type)this.myGovernor).getNofComponents() == 0;
            }
            case TYPE_ASN1_SET: {
                return ((ASN1_Set_Type)this.myGovernor).getNofComponents() == 0;
            }
        }
        return false;
    }

    @Override
    public StringBuilder getSingleExpression(JavaGenData aData, boolean castIsNeeded) {
        if (this.namedTemplates.getNofTemplates() != 0) {
            ErrorReporter.INTERNAL_ERROR((String)("INTERNAL ERROR: Can not generate single expression for named template list `" + this.getFullName() + "''"));
            return new StringBuilder("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
        }
        aData.addBuiltinTypeImport("TitanNull_Type");
        if (this.myGovernor == null) {
            return new StringBuilder("TitanNull_Type.NULL_VALUE");
        }
        StringBuilder result = new StringBuilder();
        String genName = this.myGovernor.getGenNameTemplate(aData, result);
        result.append(MessageFormat.format("new {0}(TitanNull_Type.NULL_VALUE)", genName));
        return result;
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, TemplateRestriction.Restriction_type templateRestriction) {
        if (this.lengthRestriction == null && !this.isIfpresent && templateRestriction == TemplateRestriction.Restriction_type.TR_NONE && this.hasSingleExpression()) {
            expression.expression.append((CharSequence)this.getSingleExpression(aData, true));
            return;
        }
        if (this.asValue != null) {
            this.asValue.generateCodeExpression(aData, expression, true);
            return;
        }
        IType governor = this.myGovernor;
        if (governor == null) {
            governor = this.getExpressionGovernor(CompilationTimeStamp.getBaseTimestamp(), Expected_Value_type.EXPECTED_TEMPLATE);
        }
        if (governor == null) {
            return;
        }
        String tempId = aData.getTemporaryVariableName();
        String genName = governor.getGenNameTemplate(aData, expression.expression);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", genName, tempId));
        this.setGenNameRecursive(genName);
        this.generateCodeInit(aData, expression.preamble, tempId);
        if (templateRestriction != TemplateRestriction.Restriction_type.TR_NONE) {
            TemplateRestriction.generateRestrictionCheckCode(aData, expression.preamble, this.location, tempId, templateRestriction);
        }
        expression.expression.append(tempId);
    }

    @Override
    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.asValue != null) {
            this.asValue.reArrangeInitCode(aData, source, usageModule);
            return;
        }
        for (int i = 0; i < this.namedTemplates.getNofTemplates(); ++i) {
            this.namedTemplates.getTemplateByIndex(i).getTemplate().reArrangeInitCode(aData, source, usageModule);
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.reArrangeInitCode(aData, source, usageModule);
        }
    }

    @Override
    public void generateCodeInit(JavaGenData aData, StringBuilder source, String name) {
        int nofTypeMembers;
        if (this.lastTimeBuilt != null && !this.lastTimeBuilt.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeBuilt = aData.getBuildTimstamp();
        if (this.asValue != null) {
            this.asValue.generateCodeInit(aData, source, name);
            return;
        }
        if (this.myGovernor == null) {
            return;
        }
        IType type = this.myGovernor.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (type == null) {
            return;
        }
        switch (this.myGovernor.getTypetype()) {
            case TYPE_TTCN3_SEQUENCE: {
                nofTypeMembers = ((TTCN3_Sequence_Type)this.myGovernor).getNofComponents();
                break;
            }
            case TYPE_ASN1_SEQUENCE: {
                nofTypeMembers = ((ASN1_Sequence_Type)this.myGovernor).getNofComponents();
                break;
            }
            case TYPE_SIGNATURE: {
                nofTypeMembers = ((Signature_Type)this.myGovernor).getNofParameters();
                break;
            }
            case TYPE_TTCN3_SET: {
                nofTypeMembers = ((TTCN3_Set_Type)this.myGovernor).getNofComponents();
                break;
            }
            case TYPE_ASN1_SET: {
                nofTypeMembers = ((ASN1_Set_Type)this.myGovernor).getNofComponents();
                break;
            }
            default: {
                nofTypeMembers = 1;
            }
        }
        if (nofTypeMembers == 0) {
            aData.addBuiltinTypeImport("TitanNull_Type");
            source.append(MessageFormat.format("{0}.operator_assign(TitanNull_Type.NULL_VALUE);\n", name));
            if (this.lengthRestriction != null) {
                if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                    this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
                }
                this.lengthRestriction.generateCodeInit(aData, source, name);
            }
            if (this.isIfpresent) {
                source.append(name);
                source.append(".set_ifPresent();\n");
            }
            return;
        }
        for (int i = 0; i < this.namedTemplates.getNofTemplates(); ++i) {
            CompField field;
            NamedTemplate namedTemplate = this.namedTemplates.getTemplateByIndex(i);
            Identifier fieldId = namedTemplate.getName();
            String fieldName = fieldId.getName();
            String generatedFieldName = FieldSubReference.getJavaGetterName(fieldName);
            TTCN3Template template = namedTemplate.getTemplate();
            if (template.needsTemporaryReference()) {
                Type fieldType;
                switch (type.getTypetype()) {
                    case TYPE_SIGNATURE: {
                        fieldType = ((Signature_Type)type).getParameterByName(fieldName).getType();
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: {
                        fieldType = ((TTCN3_Sequence_Type)type).getComponentByName(fieldName).getType();
                        break;
                    }
                    case TYPE_TTCN3_SET: {
                        fieldType = ((TTCN3_Set_Type)type).getComponentByName(fieldName).getType();
                        break;
                    }
                    case TYPE_ASN1_SEQUENCE: {
                        fieldType = ((ASN1_Sequence_Type)type).getComponentByName(fieldId).getType();
                        break;
                    }
                    case TYPE_ASN1_SET: {
                        fieldType = ((ASN1_Set_Type)type).getComponentByName(fieldId).getType();
                        break;
                    }
                    case TYPE_ASN1_CHOICE: {
                        fieldType = ((ASN1_Choice_Type)type).getComponentByName(fieldId).getType();
                        break;
                    }
                    case TYPE_TTCN3_CHOICE: {
                        fieldType = ((TTCN3_Choice_Type)type).getComponentByName(fieldName).getType();
                        break;
                    }
                    case TYPE_OPENTYPE: {
                        CompField field2 = ((Open_Type)type).getComponentByName(fieldId);
                        fieldType = field2.getType();
                        fieldName = field2.getIdentifier().getName();
                        generatedFieldName = FieldSubReference.getJavaGetterName(fieldName);
                        break;
                    }
                    case TYPE_ANYTYPE: {
                        fieldType = ((Anytype_Type)type).getComponentByName(fieldName).getType();
                        break;
                    }
                    default: {
                        ErrorReporter.INTERNAL_ERROR((String)("FATAL ERROR while processing named template list `" + this.getFullName() + "''"));
                        return;
                    }
                }
                String tempId = aData.getTemporaryVariableName();
                source.append("{\n");
                source.append(MessageFormat.format("final {0} {1} = {2}.get_field_{3}();\n", fieldType.getGenNameTemplate(aData, source), tempId, name, generatedFieldName));
                template.generateCodeInit(aData, source, tempId);
                source.append("}\n");
                continue;
            }
            if (type.getTypetype() == IType.Type_type.TYPE_OPENTYPE && (field = ((Open_Type)type).getComponentByName(fieldId)) != null) {
                fieldName = field.getIdentifier().getName();
                generatedFieldName = FieldSubReference.getJavaGetterName(fieldName);
            }
            String embeddedName = MessageFormat.format("{0}.get_field_{1}()", name, generatedFieldName);
            template.generateCodeInit(aData, source, embeddedName);
        }
        if (this.lengthRestriction != null) {
            if (this.getCodeSection() == GovernedSimple.CodeSectionType.CS_POST_INIT) {
                this.lengthRestriction.reArrangeInitCode(aData, source, this.myScope.getModuleScopeGen());
            }
            this.lengthRestriction.generateCodeInit(aData, source, name);
        }
        if (this.isIfpresent) {
            source.append(name);
            source.append(".set_ifPresent();\n");
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
        int size = this.namedTemplates.getNofTemplates();
        for (int i = 0; i < size; ++i) {
            this.namedTemplates.getTemplateByIndex(i).getTemplate().setMyDefinition(definition);
        }
    }
}

