/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AnytypeAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.AttributeSpecification;
import org.eclipse.titan.designer.AST.TTCN3.attributes.ExtensionAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.Qualifiers;
import org.eclipse.titan.designer.AST.TTCN3.attributes.SingleWithAttribute;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.NamedTemplate;
import org.eclipse.titan.designer.AST.TTCN3.templates.Named_Template_List;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.CompFieldMap;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.UnionGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.SubType;
import org.eclipse.titan.designer.AST.TTCN3.values.Anytype_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.extensionattributeparser.ExtensionAttributeAnalyzer;

public final class Anytype_Type
extends Type {
    private static final String TEMPLATENOTALLOWED = "{0} cannot be used for anytype type `{1}''";
    private static final String LENGTHRESTRICTIONNOTALLOWED = "Length restriction is not allowed for anytype type `{0}''";
    private static final String ONEFIELDEXPECTED = "A template for anytype type must contain exactly one selected field";
    private static final String ANYTYPEEXPECTED = "Anytype value was expected for type `{0}''";
    private static final String NONEXISTENTUNION = "Reference to a non-existent field `{0}'' in anytype value for type `{1}''";
    private static final String CLASSCANNOTBECONTAINED = "Class type cannot be the contained value of an any type value";
    private static final String NOCOMPATIBLEFIELD = "Type anytype `{0}'' doesn''t have any field compatible with `{1}''";
    private static final String NOTCOMPATIBLEANYTYPE = "Type anytype is compatible only with other anytype types";
    private CompFieldMap compFieldMap;
    private boolean insideCanHaveCoding = false;

    public Anytype_Type() {
        this.clear();
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_ANYTYPE;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.compFieldMap.setMyScope(scope);
    }

    public int getNofComponents() {
        if (this.compFieldMap == null) {
            return 0;
        }
        return this.compFieldMap.fields.size();
    }

    public CompField getComponentByIndex(int index) {
        return this.compFieldMap.fields.get(index);
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp) || this == temp) {
            return true;
        }
        if (info == null || noStructuredTypeCompatibility) {
            return this == temp;
        }
        switch (temp.getTypetype()) {
            case TYPE_ANYTYPE: {
                Anytype_Type tempType = (Anytype_Type)temp;
                if (this == tempType) {
                    return true;
                }
                TypeCompatibilityInfo.Chain lChain = leftChain;
                TypeCompatibilityInfo.Chain rChain = rightChain;
                if (lChain == null) {
                    lChain = info.getChain();
                    lChain.add(this);
                }
                if (rChain == null) {
                    rChain = info.getChain();
                    rChain.add(tempType);
                }
                for (int i = 0; i < this.getNofComponents(); ++i) {
                    CompField cf = this.getComponentByIndex(i);
                    IType cfType = cf.getType().getTypeRefdLast(timestamp);
                    for (int j = 0; j < tempType.getNofComponents(); ++j) {
                        CompField tempComponentField = tempType.getComponentByIndex(j);
                        IType tempTypeCompFieldType = tempComponentField.getType().getTypeRefdLast(timestamp);
                        if (!cf.getIdentifier().getDisplayName().equals(tempComponentField.getIdentifier().getDisplayName())) continue;
                        lChain.markState();
                        rChain.markState();
                        lChain.add(cfType);
                        rChain.add(tempTypeCompFieldType);
                        if (cfType == tempTypeCompFieldType || lChain.hasRecursion() && rChain.hasRecursion() || cfType.isCompatible(timestamp, tempTypeCompFieldType, info, lChain, rChain)) {
                            info.setNeedsConversion(true);
                            lChain.previousState();
                            rChain.previousState();
                            return true;
                        }
                        lChain.previousState();
                        rChain.previousState();
                    }
                }
                info.setErrorStr(MessageFormat.format(NOCOMPATIBLEFIELD, temp.getTypename(), this.getTypename()));
                return false;
            }
            case TYPE_ASN1_SEQUENCE: 
            case TYPE_TTCN3_SEQUENCE: 
            case TYPE_SEQUENCE_OF: 
            case TYPE_ARRAY: 
            case TYPE_ASN1_SET: 
            case TYPE_TTCN3_SET: 
            case TYPE_SET_OF: 
            case TYPE_ASN1_CHOICE: 
            case TYPE_TTCN3_CHOICE: {
                info.setErrorStr(NOTCOMPATIBLEANYTYPE);
                return false;
            }
        }
        return false;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "anytype.gif";
    }

    private void clear() {
        this.compFieldMap = new CompFieldMap();
        this.compFieldMap.setMyType(this);
        this.compFieldMap.setFullNameParent(this);
    }

    public void addComp(CompField field) {
        this.compFieldMap.addComp(field);
    }

    public boolean hasComponentWithName(String name) {
        if (this.compFieldMap.componentFieldMap == null) {
            return false;
        }
        return this.compFieldMap.componentFieldMap.containsKey(name);
    }

    public CompField getComponentByName(String name) {
        if (this.compFieldMap.componentFieldMap == null) {
            return null;
        }
        return this.compFieldMap.componentFieldMap.get(name);
    }

    @Override
    public SubType.SubType_type getSubtypeType() {
        return SubType.SubType_type.ST_UNION;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.isErroneous = false;
        this.analyzeExtensionAttributes(timestamp);
        this.initAttributes(timestamp);
        this.compFieldMap.check(timestamp);
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public void getTypesWithNoCodingTable(CompilationTimeStamp timestamp, ArrayList<IType> typeList, boolean onlyOwnTable) {
        if (typeList.contains(this)) {
            return;
        }
        if (onlyOwnTable && this.codingTable.isEmpty() || !onlyOwnTable && this.getTypeWithCodingTable(timestamp, false) == null) {
            typeList.add(this);
        }
        for (CompField compField : this.compFieldMap.fields) {
            compField.getType().getTypesWithNoCodingTable(timestamp, typeList, onlyOwnTable);
        }
    }

    private void analyzeExtensionAttributes(CompilationTimeStamp timestamp) {
        this.clear();
        TTCN3Module myModule = (TTCN3Module)this.getMyScope().getModuleScope();
        WithAttributesPath moduleAttributePath = myModule.getAttributePath();
        if (moduleAttributePath == null) {
            return;
        }
        List<SingleWithAttribute> realAttributes = moduleAttributePath.getRealAttributes(timestamp);
        ArrayList<AttributeSpecification> specifications = null;
        for (int i = 0; i < realAttributes.size(); ++i) {
            Qualifiers qualifiers;
            SingleWithAttribute attribute = realAttributes.get(i);
            if (!SingleWithAttribute.Attribute_Type.Extension_Attribute.equals((Object)attribute.getAttributeType()) || (qualifiers = attribute.getQualifiers()) != null && qualifiers.getNofQualifiers() != 0) continue;
            if (specifications == null) {
                specifications = new ArrayList<AttributeSpecification>();
            }
            specifications.add(attribute.getAttributeSpecification());
        }
        if (specifications == null) {
            return;
        }
        ArrayList<ExtensionAttribute> attributes = new ArrayList<ExtensionAttribute>();
        for (int i = 0; i < specifications.size(); ++i) {
            AttributeSpecification specification = (AttributeSpecification)specifications.get(i);
            ExtensionAttributeAnalyzer analyzer = new ExtensionAttributeAnalyzer();
            analyzer.parse(specification);
            List<ExtensionAttribute> temp = analyzer.getAttributes();
            if (temp == null) continue;
            attributes.addAll(temp);
        }
        Definitions definitionsScope = myModule.getDefinitions();
        for (int i = 0; i < attributes.size(); ++i) {
            ExtensionAttribute extensionAttribute = (ExtensionAttribute)attributes.get(i);
            if (!ExtensionAttribute.ExtensionAttribute_type.ANYTYPE.equals((Object)extensionAttribute.getAttributeType())) continue;
            AnytypeAttribute anytypeAttribute = (AnytypeAttribute)extensionAttribute;
            for (int j = 0; j < anytypeAttribute.getNofTypes(); ++j) {
                String fieldName;
                Type tempType = anytypeAttribute.getType(j);
                Identifier identifier = null;
                if (IType.Type_type.TYPE_REFERENCED.equals((Object)tempType.getTypetype())) {
                    Reference reference = ((Referenced_Type)tempType).getReference();
                    identifier = reference.getId();
                    fieldName = identifier.getTtcnName();
                } else {
                    fieldName = tempType.getTypename();
                    identifier = new Identifier(Identifier.Identifier_type.ID_TTCN, fieldName);
                }
                tempType.setMyScope(definitionsScope);
                this.addComp(new CompField(identifier, tempType, false, null));
            }
        }
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = super.checkThisValue(timestamp, value, lhs, valueCheckingOptions);
        IValue last = value.getValueRefdLast(timestamp, valueCheckingOptions.expected_value, null);
        if (last == null || last.getIsErroneous(timestamp)) {
            return selfReference;
        }
        switch (value.getValuetype()) {
            case OMIT_VALUE: 
            case REFERENCED_VALUE: {
                return selfReference;
            }
            case UNDEFINED_LOWERIDENTIFIER_VALUE: {
                if (!IValue.Value_type.REFERENCED_VALUE.equals((Object)last.getValuetype())) break;
                return selfReference;
            }
        }
        switch (last.getValuetype()) {
            case SEQUENCE_VALUE: {
                last = last.setValuetype(timestamp, IValue.Value_type.ANYTYPE_VALUE);
                if (last.getIsErroneous(timestamp)) break;
                selfReference = this.checkThisValueAnytype(timestamp, (Anytype_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.str_elem);
                break;
            }
            case ANYTYPE_VALUE: {
                selfReference = this.checkThisValueAnytype(timestamp, (Anytype_Value)last, lhs, valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.str_elem);
                break;
            }
            case EXPRESSION_VALUE: 
            case MACRO_VALUE: {
                break;
            }
            default: {
                value.getLocation().reportSemanticError(MessageFormat.format(ANYTYPEEXPECTED, this.getFullName()));
                value.setIsErroneous(true);
            }
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    private boolean checkThisValueAnytype(CompilationTimeStamp timestamp, Anytype_Value value, Assignment lhs, Expected_Value_type expectedValue, boolean incompleteAllowed, boolean strElem) {
        boolean selfReference = false;
        Identifier name = value.getName();
        if (!this.hasComponentWithName(name.getName())) {
            value.getLocation().reportSemanticError(MessageFormat.format(NONEXISTENTUNION, name.getDisplayName(), this.getFullName()));
            this.setIsErroneous(true);
            return selfReference;
        }
        Type alternativeType = this.getComponentByName(name.getName()).getType();
        IValue alternativeValue = value.getValue();
        alternativeValue.setMyGovernor(alternativeType);
        alternativeValue = alternativeType.checkThisValueRef(timestamp, alternativeValue);
        selfReference = alternativeType.checkThisValue(timestamp, alternativeValue, lhs, new IType.ValueCheckingOptions(expectedValue, incompleteAllowed, false, true, false, strElem));
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.setMyGovernor(this);
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = false;
        if (ITTCN3Template.Template_type.NAMED_TEMPLATE_LIST.equals((Object)template.getTemplatetype())) {
            Named_Template_List namedTemplateList = (Named_Template_List)template;
            int nofTemplates = namedTemplateList.getNofTemplates();
            if (nofTemplates != 1) {
                template.getLocation().reportSemanticError(ONEFIELDEXPECTED);
            }
            for (int i = 0; i < nofTemplates; ++i) {
                NamedTemplate namedTemplate = namedTemplateList.getTemplateByIndex(i);
                Identifier name = namedTemplate.getName();
                CompField field = this.compFieldMap.getCompWithName(name);
                if (field == null) continue;
                Type fieldType = field.getType();
                ITTCN3Template namedTemplateTemplate = namedTemplate.getTemplate();
                namedTemplateTemplate.setMyGovernor(fieldType);
                namedTemplateTemplate = fieldType.checkThisTemplateRef(timestamp, namedTemplateTemplate);
                ITTCN3Template.Completeness_type completeness = namedTemplateList.getCompletenessConditionChoice(timestamp, isModified, name);
                selfReference |= namedTemplateTemplate.checkThisTemplateGeneric(timestamp, fieldType, ITTCN3Template.Completeness_type.MAY_INCOMPLETE.equals((Object)completeness), false, false, true, implicitOmit, lhs);
            }
        } else {
            template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, template.getTemplateTypeName(), this.getTypename()));
        }
        if (template.getLengthRestriction() != null) {
            template.getLocation().reportSemanticError(MessageFormat.format(LENGTHRESTRICTIONNOTALLOWED, this.getTypename()));
        }
        return selfReference;
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (this.insideCanHaveCoding) {
            this.insideCanHaveCoding = false;
            return true;
        }
        this.insideCanHaveCoding = true;
        if (coding == IType.MessageEncoding_type.BER) {
            this.insideCanHaveCoding = false;
            return this.hasEncoding(timestamp, IType.MessageEncoding_type.BER, null);
        }
        for (CompField compField : this.compFieldMap.fields) {
            if (compField.getType().getTypeRefdLast(timestamp).canHaveCoding(timestamp, coding)) continue;
            this.insideCanHaveCoding = false;
            return false;
        }
        this.insideCanHaveCoding = false;
        return true;
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        this.checkJson(timestamp);
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        refChain.markState();
        for (CompField compField : this.compFieldMap.fields) {
            compField.getType().checkCodingAttributes(timestamp, refChain);
        }
        refChain.previousState();
    }

    @Override
    public void forceJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null) {
            this.jsonAttribute = new JsonAST();
        }
    }

    @Override
    public void checkJson(CompilationTimeStamp timestamp) {
        if (this.jsonAttribute == null && !this.hasEncodeAttribute("JSON")) {
            return;
        }
        for (int i = 0; i < this.getNofComponents(); ++i) {
            Type fieldType = this.getComponentByIndex(i).getType();
            fieldType.forceJson(timestamp);
        }
        if (this.jsonAttribute == null) {
            return;
        }
        if (this.jsonAttribute.omit_as_null && !this.isOptionalField()) {
            this.getLocation().reportSemanticError("Invalid attribute, 'omit as null' requires optional field of a record or set.");
        }
        if (this.jsonAttribute.alias != null) {
            IType parent = this.getParentType();
            if (parent == null) {
                this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
            } else {
                switch (parent.getTypetype()) {
                    case TYPE_ANYTYPE: 
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: 
                    case TYPE_TTCN3_CHOICE: {
                        break;
                    }
                    default: {
                        this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
                    }
                }
            }
            if (parent != null && parent.getJsonAttribute() != null && parent.getJsonAttribute().as_value) {
                switch (parent.getTypetype()) {
                    case TYPE_ANYTYPE: 
                    case TYPE_TTCN3_CHOICE: {
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)parent).getNofComponents() != 1) break;
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                }
            }
        }
        if (this.jsonAttribute.parsed_default_value != null) {
            this.checkJsonDefault(timestamp);
        }
        if (this.jsonAttribute.metainfo_unbound && (this.getParentType() == null || this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SEQUENCE && this.getParentType().getTypetype() != IType.Type_type.TYPE_TTCN3_SET)) {
            this.getLocation().reportSemanticError("Invalid attribute 'metainfo for unbound', requires record, set, record of, set of, array or field of a record or set");
        }
        if (this.jsonAttribute.as_number) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as number' is only allowed for enumerated types");
        }
        if (this.jsonAttribute.as_map) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires record of or set of");
        }
        if (this.jsonAttribute.enum_texts.size() > 0) {
            this.getLocation().reportSemanticError("Invalid attribute, 'text ... as ...' requires an enumerated type");
        }
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return null;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return null;
                }
                if (fieldType instanceof Referenced_Type && fieldType.getTypeRefdLast(timestamp) instanceof Class_Type) {
                    subreference.getLocation().reportSemanticError(CLASSCANNOTBECONTAINED);
                    return null;
                }
                Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                return fieldType.getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, false);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return false;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return false;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                int fieldIndex = this.compFieldMap.fields.indexOf(compField);
                subrefsArray.add(fieldIndex);
                typeArray.add(this);
                return fieldType.getSubrefsAsArray(timestamp, reference, actualSubReference + 1, subrefsArray, typeArray);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return false;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return false;
    }

    @Override
    public boolean getFieldTypesAsArray(Reference reference, int actualSubReference, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                if (this.compFieldMap == null) {
                    return false;
                }
                Identifier id = subreference.getId();
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    return false;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                typeArray.add(this);
                return fieldType.getFieldTypesAsArray(reference, actualSubReference + 1, typeArray);
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        int size = this.getNofComponents();
        for (int i = 0; i < size; ++i) {
            Type type = this.getComponentByIndex(i).getType();
            type.checkMapParameter(timestamp, refChain, errorLocation);
        }
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("anytype");
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.compFieldMap.getCompWithName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addProposal(propCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefixCaseInsensitive(subreference.getId().getName());
                for (CompField compField : compFields) {
                    String proposalKind = compField.getType().getProposalDescription(new StringBuilder()).toString();
                    propCollector.addProposal(compField.getIdentifier(), " - " + proposalKind, ImageCache.getImage(this.getOutlineIcon()), proposalKind);
                }
            }
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.compFieldMap.getCompWithName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addDeclaration(declarationCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefixCaseInsensitive(subreference.getId().getName());
                for (CompField compField : compFields) {
                    declarationCollector.addDeclaration(compField.getIdentifier().getDisplayName(), compField.getIdentifier().getLocation(), this);
                }
            }
        }
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        this.compFieldMap.getEnclosingField(offset, rf);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.compFieldMap == null || this.compFieldMap.accept(v);
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData).concat("_template");
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        String baseName = this.getGenNameTypeName(aData, source);
        return baseName + "." + this.getGenNameOwn();
    }

    @Override
    public boolean needsOwnRawDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_json_";
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        String genName = this.getGenNameOwn();
        String displayName = this.getFullName();
        StringBuilder localTypeDescriptor = new StringBuilder();
        this.generateCodeTypedescriptor(aData, source, localTypeDescriptor, null);
        this.generateCodeDefaultCoding(aData, source, localTypeDescriptor);
        StringBuilder localCodingHandler = new StringBuilder();
        this.generateCodeForCodingHandlers(aData, source, localCodingHandler);
        boolean hasJson = this.getGenerateCoderFunctions(IType.MessageEncoding_type.JSON);
        ArrayList<UnionGenerator.FieldInfo> fieldInfos = new ArrayList<UnionGenerator.FieldInfo>();
        boolean hasOptional = false;
        for (CompField compField : this.compFieldMap.fields) {
            Type cfType = compField.getType();
            String jsonAlias = cfType.getJsonAttribute() != null ? cfType.getJsonAttribute().alias : null;
            int JsonValueType = hasJson ? cfType.getJsonValueType() : 0;
            UnionGenerator.FieldInfo fi = new UnionGenerator.FieldInfo(cfType.getGenNameValue(aData, source), cfType.getGenNameTemplate(aData, source), compField.getIdentifier().getName(), compField.getIdentifier().getDisplayName(), cfType.getGenNameTypeDescriptor(aData, source), jsonAlias, JsonValueType);
            hasOptional |= compField.isOptional();
            fieldInfos.add(fi);
        }
        for (CompField compField : this.compFieldMap.fields) {
            StringBuilder tempSource = aData.getCodeForType(compField.getType().getGenNameOwn());
            compField.getType().generateCode(aData, tempSource);
        }
        boolean jsonAsValue = this.jsonAttribute != null ? this.jsonAttribute.as_value : false;
        boolean hasRaw = this.getGenerateCoderFunctions(IType.MessageEncoding_type.RAW);
        UnionGenerator.generateValueClass(aData, source, genName, displayName, fieldInfos, hasOptional, hasRaw, null, hasJson, true, jsonAsValue, localTypeDescriptor, localCodingHandler);
        UnionGenerator.generateTemplateClass(aData, source, genName, displayName, fieldInfos, hasOptional);
        if (this.hasDoneAttribute()) {
            this.generateCodeDone(aData, source);
        }
        if (this.subType != null) {
            this.subType.generateCode(aData, source);
        }
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        boolean nextOptional;
        ISubReference subReference;
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return;
        }
        if (subReferenceIndex >= subreferences.size()) {
            return;
        }
        StringBuilder closingBrackets = new StringBuilder();
        if (isTemplate) {
            boolean anyvalueReturnValue = true;
            if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                anyvalueReturnValue = this.isPresentAnyvalueEmbeddedField(expression, subreferences, subReferenceIndex);
            } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION || optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                anyvalueReturnValue = false;
            }
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", externalId));
            expression.expression.append("case UNINITIALIZED_TEMPLATE:\n");
            expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
            expression.expression.append("break;\n");
            expression.expression.append("case ANY_VALUE:\n");
            expression.expression.append(MessageFormat.format("{0} = {1};\n", globalId, anyvalueReturnValue ? "true" : "false"));
            expression.expression.append("break;\n");
            expression.expression.append("case SPECIFIC_VALUE:{\n");
            closingBrackets.append("break;}\n");
            closingBrackets.append("default:\n");
            closingBrackets.append(MessageFormat.format("{0} = false;\n", globalId));
            closingBrackets.append("break;\n");
            closingBrackets.append("}\n");
            closingBrackets.append("}\n");
        }
        if (!((subReference = subreferences.get(subReferenceIndex)) instanceof FieldSubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return;
        }
        Identifier fieldId = ((FieldSubReference)subReference).getId();
        CompField compField = this.getComponentByName(fieldId.getName());
        Type nextType = compField.getType();
        String nextTypeGenName = isTemplate ? nextType.getGenNameTemplate(aData, expression.expression) : nextType.getGenNameValue(aData, expression.expression);
        boolean bl = nextOptional = !isTemplate && compField.isOptional();
        if (nextOptional) {
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            closingBrackets.insert(0, "}\n");
            String temporalId = aData.getTemporaryVariableName();
            aData.addBuiltinTypeImport("Optional");
            expression.expression.append(MessageFormat.format("final Optional<{0}> {1} = {2}.get_field_{3}();\n", nextTypeGenName, temporalId, externalId, FieldSubReference.getJavaGetterName(fieldId.getName())));
            if (subReferenceIndex == subreferences.size() - 1) {
                expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", temporalId));
                expression.expression.append("case OPTIONAL_UNBOUND:\n");
                expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
                expression.expression.append("break;\n");
                expression.expression.append("case OPTIONAL_OMIT:\n");
                expression.expression.append(MessageFormat.format("{0} = {1};\n", globalId, optype == Expression_Value.Operation_type.ISBOUND_OPERATION ? "true" : "false"));
                expression.expression.append("break;\n");
                expression.expression.append("default:\n");
                expression.expression.append("{\n");
                String temporalId2 = aData.getTemporaryVariableName();
                expression.expression.append(MessageFormat.format("final {0} {1} = {2}.constGet();\n", nextTypeGenName, temporalId2, temporalId));
                if (optype == Expression_Value.Operation_type.ISBOUND_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
                } else if (optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.is_value();\n", globalId, temporalId2));
                } else if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.is_present({2});\n", globalId, temporalId2, isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
                } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2});\n", globalId, temporalId2, field));
                }
                expression.expression.append("break;}\n");
                expression.expression.append("}\n");
                nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId2, isTemplate, optype, field, targetScope);
            } else {
                expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", temporalId));
                expression.expression.append("case OPTIONAL_UNBOUND:\n");
                expression.expression.append("case OPTIONAL_OMIT:\n");
                expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
                expression.expression.append("break;\n");
                expression.expression.append("default:\n");
                expression.expression.append("break;\n");
                expression.expression.append("}\n");
                expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
                closingBrackets.insert(0, "}\n");
                String temporalId2 = aData.getTemporaryVariableName();
                expression.expression.append(MessageFormat.format("final {0} {1} = {2}.constGet();\n", nextTypeGenName, temporalId2, temporalId));
                expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
                nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId2, isTemplate, optype, field, targetScope);
            }
        } else {
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            closingBrackets.insert(0, "}\n");
            String temporalId = aData.getTemporaryVariableName();
            String temporalId2 = aData.getTemporaryVariableName();
            String currentTypeGenName = isTemplate ? this.getGenNameTemplate(aData, expression.expression) : this.getGenNameValue(aData, expression.expression);
            expression.expression.append(MessageFormat.format("final {0} {1} = {2};\n", currentTypeGenName, temporalId, externalId));
            expression.expression.append(MessageFormat.format("final {0} {1} = {2}.get_field_{3}();\n", nextTypeGenName, temporalId2, temporalId, FieldSubReference.getJavaGetterName(fieldId.getName())));
            if (optype == Expression_Value.Operation_type.ISBOUND_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
            } else if (optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.is_value();\n", globalId, temporalId2));
            } else if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.{2}({3});\n", globalId, temporalId2, subReferenceIndex != subreferences.size() - 1 ? "is_bound" : "is_present", subReferenceIndex == subreferences.size() - 1 && isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
            } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
                if (subReferenceIndex == subreferences.size() - 1) {
                    expression.expression.append(MessageFormat.format("if ({0}) '{'\n", globalId));
                    expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2});\n", globalId, temporalId2, field));
                    expression.expression.append("}\n");
                }
            }
            nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId2, isTemplate, optype, field, targetScope);
        }
        expression.expression.append((CharSequence)closingBrackets);
    }

    @Override
    public boolean isPresentAnyvalueEmbeddedField(ExpressionStruct expression, List<ISubReference> subreferences, int beginIndex) {
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return true;
        }
        return beginIndex >= subreferences.size();
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        IType refdType = fromType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (refdType == null || this == refdType) {
            return fromName;
        }
        switch (refdType.getTypetype()) {
            case TYPE_ANYTYPE: {
                Anytype_Type realFromType = (Anytype_Type)refdType;
                return this.generateConversionAnytypeToAnytype(aData, realFromType, fromName, forValue, expression);
            }
        }
        expression.expression.append(MessageFormat.format("//FIXME conversion from {0} to {1} is not needed or nor supported yet\n", fromType.getTypename(), this.getTypename()));
        return fromName;
    }

    protected String generateConversionAnytypeToAnytype(JavaGenData aData, Anytype_Type fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = this.getGenNameValue(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            StringBuilder conversionFunctionBody = new StringBuilder();
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromType.getGenNameValue(aData, conversionFunctionBody)));
            conversionFunctionBody.append("\t\tif(!from.is_bound()) {\n");
            conversionFunctionBody.append("\t\t\treturn false;\n");
            conversionFunctionBody.append("\t\t}\n");
            conversionFunctionBody.append("\t\tswitch (from.get_selection()) {\n");
            for (int i = 0; i < fromType.getNofComponents(); ++i) {
                CompField fromComp = fromType.getComponentByIndex(i);
                Identifier fromFieldName = fromComp.getIdentifier();
                IType fromFieldType = fromComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                for (int j = 0; j < this.getNofComponents(); ++j) {
                    CompField toComp = this.getComponentByIndex(j);
                    Identifier toFieldName = toComp.getIdentifier();
                    IType toFieldType = toComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                    if (!fromFieldName.equals(toFieldName) || !fromFieldType.isCompatible(CompilationTimeStamp.getBaseTimestamp(), toFieldType, null, null, null)) continue;
                    conversionFunctionBody.append(MessageFormat.format("\t\tcase ALT_{0}: '{'\n", fromFieldName.getName()));
                    String tempId2 = aData.getTemporaryVariableName();
                    conversionFunctionBody.append(MessageFormat.format("\t\t\tfinal {0} {1} = from.constGet_field_{2}();\n", fromFieldType.getGenNameValue(aData, conversionFunctionBody), tempId2, fromFieldName.getName()));
                    conversionFunctionBody.append(MessageFormat.format("\t\t\tif ({0}.is_bound()) '{'\n", tempId2));
                    ExpressionStruct tempExpression = new ExpressionStruct();
                    String tempId3 = toFieldType.generateConversion(aData, fromFieldType, tempId2, forValue, tempExpression);
                    tempExpression.openMergeExpression(conversionFunctionBody);
                    conversionFunctionBody.append(MessageFormat.format("\t\t\t\tto.get_field_{0}().operator_assign({1});\n", toFieldName.getName(), tempId3));
                    conversionFunctionBody.append("\t\t\t}\n");
                    conversionFunctionBody.append("\t\t\tbreak;\n");
                    conversionFunctionBody.append("\t\t}\n");
                }
            }
            conversionFunctionBody.append("\t\tdefault:\n");
            conversionFunctionBody.append("\t\t\treturn false;\n");
            conversionFunctionBody.append("\t\t}\n");
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }
}

