/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimension;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Port_Type
extends Type {
    private static final String TEMPLATENOTALLOWED = "Template cannot be defined for port type `{0}''";
    private final PortTypeBody body;

    public Port_Type(PortTypeBody body) {
        this.body = body;
        if (body != null) {
            body.setFullNameParent(this);
            body.setMyType(this);
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_PORT;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.body != null) {
            this.body.setMyScope(scope);
        }
    }

    public PortTypeBody getPortBody() {
        return this.body;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType temp = otherType.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == otherType;
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType temp = type.getTypeRefdLast(timestamp);
        if (this.getIsErroneous(timestamp) || temp.getIsErroneous(timestamp)) {
            return true;
        }
        return this == temp;
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        return this.getFullName();
    }

    @Override
    public String getOutlineIcon() {
        return "port.gif";
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        return true;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.initAttributes(timestamp);
        if (this.body != null) {
            FormalParameterList unmapParams;
            this.body.check(timestamp);
            FormalParameterList mapParams = this.body.getMapParameters();
            if (mapParams != null) {
                mapParams.setMyDefinition((Definition)this.getDefiningAssignment());
                mapParams.setGenName(this.getGenNameOwn());
            }
            if ((unmapParams = this.body.getUnmapParameters()) != null) {
                unmapParams.setMyDefinition((Definition)this.getDefiningAssignment());
                unmapParams.setGenName(this.getGenNameOwn());
            }
            if (this.withAttributesPath != null) {
                this.body.checkAttributes(timestamp, this.withAttributesPath);
            }
        }
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        this.location.reportSemanticError(MessageFormat.format("Port type `{0}'' cannot be {1}", this.getTypename(), operation));
    }

    @Override
    public void checkEmbedded(CompilationTimeStamp timestamp, Location errorLocation, boolean defaultAllowed, String errorMessage) {
        errorLocation.reportSemanticError(MessageFormat.format("Port type `{0}'' cannot be {1}", this.getTypename(), errorMessage));
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        this.registerUsage(template);
        template.getLocation().reportSemanticError(MessageFormat.format(TEMPLATENOTALLOWED, this.getFullName()));
        return false;
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        return builder.append("port");
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        if (this.body != null) {
            this.body.addProposal(propCollector, i);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.body != null) {
            this.body.updateSyntax(reparser, false);
            reparser.updateLocation(this.body.getLocation());
        }
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.body != null) {
            this.body.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.body == null || this.body.accept(v);
    }

    public String getClassName(JavaGenData aData, StringBuilder source) {
        return this.body.getClassName(aData, source);
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        return this.getClassName(aData, source);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous setting `" + this.getFullName() + "''"));
        return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous setting `" + this.getFullName() + "''"));
        return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return true;
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
            return;
        }
        this.lastTimeGenerated = aData.getBuildTimstamp();
        this.body.generateCode(aData, source);
    }

    public String generateCodePort(JavaGenData aData, StringBuilder source, ArrayDimensions dimensions) {
        String typeName;
        String className = typeName = aData.getTemporaryVariableName();
        for (int i = 0; i < dimensions.size(); ++i) {
            ArrayDimension dimension = dimensions.get(i);
            String elementName = i == dimensions.size() - 1 ? this.getGenNameValue(aData, source) : aData.getTemporaryVariableName();
            source.append(MessageFormat.format("\tpublic static class {0} extends TitanPort_Array<{1}> '{'\n", className, elementName));
            source.append(MessageFormat.format("\t\tpublic {0}() '{'\n", className));
            source.append(MessageFormat.format("\t\t\tsuper({0}.class, {1} , {2});\n", elementName, dimension.getSize(), dimension.getOffset()));
            source.append("\t\t}\n");
            source.append(MessageFormat.format("\t\tpublic {0}({0} otherValue) '{'\n", className));
            source.append("\t\t\tsuper(otherValue);\n");
            source.append("\t\t}\n");
            PortGenerator.generatePortArrayBodyMembers(aData, source, this.body.generateDefinitionForCodeGeneration(aData, source), dimension.getSize(), dimension.getOffset());
            source.append("\t}\n\n");
            className = elementName;
        }
        aData.addBuiltinTypeImport("TitanPort_Array");
        return typeName;
    }
}

