/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.IASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Type_Assignment;
import org.eclipse.titan.designer.AST.ASN1.Undefined_Assignment;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.BridgingNamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawAST;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.AbstractOfType;
import org.eclipse.titan.designer.AST.TTCN3.types.EnumItem;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Enumerated_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Set_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Integer_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.TypeCompatibilityInfo;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Referenced_Type
extends ASN1Type
implements IReferencingType {
    private final Reference reference;
    private IType refd;
    private IType refdLast;
    private boolean componentInternal;

    public Referenced_Type(Reference reference) {
        this.reference = reference;
        this.componentInternal = false;
        if (reference != null) {
            reference.setFullNameParent(this);
            this.setLocation(reference.getLocation());
            this.setMyScope(reference.getMyScope());
        }
    }

    @Override
    public IType.Type_type getTypetype() {
        return IType.Type_type.TYPE_REFERENCED;
    }

    public Reference getReference() {
        return this.reference;
    }

    @Override
    public Location getLocation() {
        if (this.reference != null && this.reference.getLocation() != null) {
            return new Location(this.reference.getLocation());
        }
        return NULL_Location.INSTANCE;
    }

    @Override
    public void setLocation(Location location) {
    }

    @Override
    public IASN1Type newInstance() {
        return new Referenced_Type(this.reference);
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.reference != null) {
            this.reference.setMyScope(scope);
        }
    }

    @Override
    public String chainedDescription() {
        return "type reference: " + this.reference;
    }

    @Override
    public boolean isCompatible(CompilationTimeStamp timestamp, IType otherType, TypeCompatibilityInfo info, TypeCompatibilityInfo.Chain leftChain, TypeCompatibilityInfo.Chain rightChain) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType t1 = this.getTypeRefdLast(timestamp);
        IType t2 = otherType.getTypeRefdLast(timestamp);
        if (t1.getIsErroneous(timestamp) || t2.getIsErroneous(timestamp)) {
            return true;
        }
        return t1.isCompatible(timestamp, t2, info, null, null);
    }

    @Override
    public boolean isCompatibleByPort(CompilationTimeStamp timestamp, IType otherType) {
        this.check(timestamp);
        otherType.check(timestamp);
        IType t1 = this.getTypeRefdLast(timestamp);
        IType t2 = otherType.getTypeRefdLast(timestamp);
        if (t1.getIsErroneous(timestamp) || t2.getIsErroneous(timestamp)) {
            return true;
        }
        return t1.isCompatibleByPort(timestamp, otherType);
    }

    @Override
    public boolean isIdentical(CompilationTimeStamp timestamp, IType type) {
        this.check(timestamp);
        type.check(timestamp);
        IType t1 = this.getTypeRefdLast(timestamp);
        IType t2 = type.getTypeRefdLast(timestamp);
        if (t1.getIsErroneous(timestamp) || t2.getIsErroneous(timestamp)) {
            return true;
        }
        return t1.isIdentical(timestamp, t2);
    }

    @Override
    public IType.Type_type getTypetypeTtcn3() {
        if (this.isErroneous) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return this.getTypetype();
    }

    @Override
    public String getTypename() {
        if (this.isErroneous || this.refdLast == null || this.refdLast == this) {
            return "Referenced type";
        }
        return this.refdLast.getTypename();
    }

    @Override
    public String getOutlineIcon() {
        return "referenced.gif";
    }

    @Override
    public IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        this.check(timestamp);
        if (reference.getSubreferences().size() <= actualSubReference) {
            return this;
        }
        if (this.refdLast != null && this != this.refdLast) {
            Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
            IType temp = this.refdLast.getFieldType(timestamp, reference, actualSubReference, internalExpectation, refChain, interruptIfOptional);
            if (reference.getIsErroneous(timestamp)) {
                this.setIsErroneous(true);
            }
            return temp;
        }
        return this;
    }

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        if (reference.getSubreferences().size() <= actualSubReference) {
            return true;
        }
        if (this == this.refdLast) {
            return false;
        }
        return this.refdLast.getSubrefsAsArray(timestamp, reference, actualSubReference, subrefsArray, typeArray);
    }

    @Override
    public boolean getFieldTypesAsArray(Reference reference, int actualSubReference, List<IType> typeArray) {
        if (reference.getSubreferences().size() <= actualSubReference) {
            return true;
        }
        if (this == this.refdLast || this.refdLast == null) {
            return false;
        }
        return this.refdLast.getFieldTypesAsArray(reference, actualSubReference, typeArray);
    }

    @Override
    public StringBuilder getProposalDescription(StringBuilder builder) {
        Assignment ass = this.lastTimeChecked == null ? this.reference.getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), true) : this.reference.getRefdAssignment(this.lastTimeChecked, true);
        if (ass != null && Assignment.Assignment_type.A_TYPE.semanticallyEquals(ass.getAssignmentType())) {
            if (ass instanceof Def_Type) {
                Def_Type defType = (Def_Type)ass;
                return builder.append(defType.getIdentifier().getDisplayName());
            }
            if (ass instanceof Type_Assignment) {
                return builder.append(((Type_Assignment)ass).getIdentifier().getDisplayName());
            }
        }
        return builder.append("unknown_referred_type");
    }

    @Override
    public boolean isComponentInternal(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.componentInternal;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        this.check(timestamp, null);
    }

    @Override
    public void check(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.componentInternal = false;
        this.isErroneous = false;
        this.refd = null;
        this.refdLast = null;
        this.initAttributes(timestamp);
        this.refdLast = this.getTypeRefdLast(timestamp);
        if (this.refdLast != null && !this.refdLast.getIsErroneous(timestamp)) {
            this.refdLast.check(timestamp);
            this.componentInternal = this.refdLast.isComponentInternal(timestamp);
        }
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IType typeParent = this.getTypeRefd(timestamp, tempReferenceChain);
        tempReferenceChain.release();
        if (!this.refdLast.getIsErroneous(timestamp) && !typeParent.getIsErroneous(timestamp)) {
            this.checkSubtypeRestrictions(timestamp, this.refdLast.getSubtypeType(), typeParent.getSubtype());
        }
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        IType last = this.getTypeRefdLast(timestamp);
        if (last != null && !last.getIsErroneous(timestamp) && last != this) {
            last.checkComponentInternal(timestamp, typeSet, operation);
        }
    }

    @Override
    public void checkEmbedded(CompilationTimeStamp timestamp, Location errorLocation, boolean defaultAllowed, String errorMessage) {
        IType last = this.getTypeRefdLast(timestamp);
        if (last != null && !last.getIsErroneous(timestamp) && last != this) {
            last.checkEmbedded(timestamp, errorLocation, defaultAllowed, errorMessage);
        }
    }

    @Override
    public IValue checkThisValueRef(CompilationTimeStamp timestamp, IValue value) {
        if (IValue.Value_type.UNDEFINED_LOWERIDENTIFIER_VALUE.equals((Object)value.getValuetype())) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType refd = this.getTypeRefd(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (refd == null || this.equals(refd)) {
                return value;
            }
            return refd.checkThisValueRef(timestamp, value);
        }
        return value;
    }

    @Override
    public boolean checkThisValue(CompilationTimeStamp timestamp, IValue value, Assignment lhs, IType.ValueCheckingOptions valueCheckingOptions) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        boolean selfReference = false;
        IType tempType = this.getTypeRefdLast(timestamp);
        if (tempType != this) {
            String referingModuleName;
            selfReference = tempType.checkThisValue(timestamp, value, lhs, new IType.ValueCheckingOptions(valueCheckingOptions.expected_value, valueCheckingOptions.incomplete_allowed, valueCheckingOptions.omit_allowed, false, valueCheckingOptions.implicit_omit, valueCheckingOptions.str_elem, valueCheckingOptions.from_subtype));
            Definition def = value.getDefiningAssignment();
            if (def != null && !def.referingHere.contains(referingModuleName = this.getMyScope().getModuleScope().getName())) {
                def.referingHere.add(referingModuleName);
            }
        }
        if (valueCheckingOptions.sub_check && this.subType != null) {
            this.subType.checkThisValue(timestamp, value);
        }
        value.setLastTimeChecked(timestamp);
        return selfReference;
    }

    @Override
    public boolean checkThisTemplate(CompilationTimeStamp timestamp, ITTCN3Template template, boolean isModified, boolean implicitOmit, Assignment lhs) {
        if (this.getIsErroneous(timestamp)) {
            return false;
        }
        this.registerUsage(template);
        boolean selfReference = false;
        IType tempType = this.getTypeRefdLast(timestamp);
        if (tempType != this) {
            selfReference = tempType.checkThisTemplate(timestamp, template, isModified, implicitOmit, lhs);
        }
        return selfReference;
    }

    @Override
    public IType getTypeRefd(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        if (refChain.add(this) && this.reference != null && !this.getIsErroneous(timestamp)) {
            if (this.refd != null) {
                return this.refd;
            }
            Assignment ass = this.reference.getRefdAssignment(timestamp, true, refChain);
            if (ass != null && Assignment.Assignment_type.A_UNDEF.semanticallyEquals(ass.getAssignmentType())) {
                ass = ((Undefined_Assignment)ass).getRealAssignment(timestamp);
            }
            if (ass == null || ass.getIsErroneous()) {
                this.isErroneous = true;
                this.lastTimeChecked = timestamp;
                return this;
            }
            switch (ass.getAssignmentType()) {
                case A_TYPE: {
                    IType tempType = ass.getType(timestamp);
                    if (tempType == null || tempType.getIsErroneous(timestamp)) break;
                    tempType.check(timestamp);
                    tempType = tempType.getFieldType(timestamp, this.reference, 1, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, refChain, false);
                    if (tempType == null) {
                        this.setIsErroneous(true);
                        return this;
                    }
                    this.refd = tempType;
                    return this.refd;
                }
                case A_VS: {
                    IType tempType = ass.getType(timestamp);
                    if (tempType == null) {
                        this.isErroneous = true;
                        this.lastTimeChecked = timestamp;
                        return this;
                    }
                    this.refd = tempType;
                    return this.refd;
                }
                case A_OC: 
                case A_OBJECT: 
                case A_OS: {
                    ISetting setting = this.reference.getRefdSetting(timestamp);
                    if (setting == null || setting.getIsErroneous(timestamp)) {
                        this.isErroneous = true;
                        this.lastTimeChecked = timestamp;
                        return this;
                    }
                    if (!ISetting.Setting_type.S_T.equals((Object)setting.getSettingtype())) {
                        this.reference.getLocation().reportSemanticError(MessageFormat.format("`{0}'' is not a reference to a type", this.reference.getDisplayName()));
                        this.isErroneous = true;
                        this.lastTimeChecked = timestamp;
                        return this;
                    }
                    this.refd = (Type)setting;
                    if (this.refd.getOwnertype() == IType.TypeOwner_type.OT_UNKNOWN) {
                        this.refd.setOwnertype(IType.TypeOwner_type.OT_REF, this);
                    }
                    if (this.refd.getMyScope() != null) {
                        this.refd.setMyScope(this.getMyScope());
                        this.refd.setParentType(this.getParentType());
                        this.refd.setGenName(this.getGenNameOwn(), "type");
                        this.refd.setFullNameParent(new BridgingNamedNode(this, ".type"));
                    }
                    return this.refd;
                }
                default: {
                    this.reference.getLocation().reportSemanticError(MessageFormat.format("`{0}'' is not a reference to a type", this.reference.getDisplayName()));
                }
            }
        }
        this.isErroneous = true;
        this.lastTimeChecked = timestamp;
        return this;
    }

    @Override
    public IType getTypeRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        boolean newChain = null == referenceChain;
        IReferenceChain tempReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        IType t = this;
        while (t != null && t instanceof IReferencingType && !t.getIsErroneous(timestamp)) {
            t = ((IReferencingType)((Object)t)).getTypeRefd(timestamp, tempReferenceChain);
        }
        if (newChain) {
            tempReferenceChain.release();
        }
        if (t != null && t.getIsErroneous(timestamp)) {
            this.setIsErroneous(true);
        }
        return t;
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (referenceChain.add(this)) {
            ReferenceChain tempReferenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IType t = this.getTypeRefd(timestamp, tempReferenceChain);
            tempReferenceChain.release();
            if (t != null && !t.getIsErroneous(timestamp) && !this.equals(t)) {
                t.checkRecursions(timestamp, referenceChain);
            }
        }
    }

    @Override
    public void checkCodingAttributes(CompilationTimeStamp timestamp, IReferenceChain refChain) {
        int restrictionLength;
        if (this.refdLast == null || this.refdLast.getIsErroneous(CompilationTimeStamp.getBaseTimestamp()) || this.refdLast == this) {
            return;
        }
        if (this.subType != null && (restrictionLength = this.subType.get_length_restriction()) != -1) {
            if (this.rawAttribute == null) {
                this.rawAttribute = new RawAST(this.getDefaultRawFieldLength());
            }
            if (this.rawAttribute.fieldlength == 0) {
                this.rawAttribute.fieldlength = restrictionLength;
                this.rawAttribute.length_restriction = -1;
            } else {
                this.rawAttribute.length_restriction = restrictionLength;
            }
        }
        if (this.rawAttribute != null) {
            this.refd.forceRaw(timestamp);
            if (this.rawAttribute.fieldlength == 0 && this.rawAttribute.length_restriction != -1) {
                switch (this.refdLast.getTypetype()) {
                    case TYPE_BITSTRING: {
                        this.rawAttribute.fieldlength = this.rawAttribute.length_restriction;
                        this.rawAttribute.length_restriction = -1;
                        break;
                    }
                    case TYPE_HEXSTRING: {
                        this.rawAttribute.fieldlength = this.rawAttribute.length_restriction * 4;
                        this.rawAttribute.length_restriction = -1;
                        break;
                    }
                    case TYPE_OCTETSTRING: {
                        this.rawAttribute.fieldlength = this.rawAttribute.length_restriction * 8;
                        this.rawAttribute.length_restriction = -1;
                        break;
                    }
                    case TYPE_CHARSTRING: 
                    case TYPE_UCHARSTRING: {
                        this.rawAttribute.fieldlength = this.rawAttribute.length_restriction * 8;
                        this.rawAttribute.length_restriction = -1;
                        break;
                    }
                    case TYPE_SEQUENCE_OF: 
                    case TYPE_SET_OF: {
                        this.rawAttribute.fieldlength = this.rawAttribute.length_restriction;
                        this.rawAttribute.length_restriction = -1;
                        break;
                    }
                }
            }
        }
        if (this.refd.getJsonAttribute() == null) {
            this.refd.forceJson(timestamp);
        }
        this.checkJson(timestamp);
        if (refChain.contains(this)) {
            return;
        }
        this.refdLast.checkCodingAttributes(timestamp, refChain);
    }

    @Override
    public void checkJson(CompilationTimeStamp timestamp) {
        Type last;
        if (this.jsonAttribute == null && !this.hasEncodeAttribute("JSON")) {
            return;
        }
        if (this.jsonAttribute == null) {
            return;
        }
        if (this.jsonAttribute.omit_as_null && !this.isOptionalField()) {
            this.getLocation().reportSemanticError("Invalid attribute, 'omit as null' requires optional field of a record or set.");
        }
        if (this.jsonAttribute.as_value) {
            switch (this.refdLast.getTypetype()) {
                case TYPE_TTCN3_CHOICE: 
                case TYPE_ANYTYPE: {
                    break;
                }
                case TYPE_TTCN3_SEQUENCE: 
                case TYPE_TTCN3_SET: {
                    if (((TTCN3_Set_Seq_Choice_BaseType)this.refdLast).getNofComponents() == 1) break;
                }
                default: {
                    this.getLocation().reportSemanticError("Invalid attribute, 'as value' is only allowed for unions, the anytype, or records or sets with one field");
                }
            }
        }
        if (this.jsonAttribute.alias != null) {
            IType parent = this.getParentType();
            if (parent == null) {
                this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
            } else {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: 
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        break;
                    }
                    default: {
                        this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
                    }
                }
            }
            if (parent != null && parent.getJsonAttribute() != null && parent.getJsonAttribute().as_value) {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)parent).getNofComponents() != 1) break;
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                }
            }
        }
        if (this.jsonAttribute.parsed_default_value != null) {
            this.checkJsonDefault(timestamp);
        }
        if (this.jsonAttribute.metainfo_unbound) {
            if (this.refdLast.getTypetype() == IType.Type_type.TYPE_TTCN3_SEQUENCE || this.refdLast.getTypetype() == IType.Type_type.TYPE_TTCN3_SET) {
                last = (TTCN3_Set_Seq_Choice_BaseType)this.refdLast;
                int nofComponents = ((TTCN3_Set_Seq_Choice_BaseType)last).getNofComponents();
                if (this.jsonAttribute.as_value && nofComponents == 1) {
                    this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'metainfo for unbound' will be ignored, because the {0} is encoded without field names.", this.refdLast.getTypetype() == IType.Type_type.TYPE_TTCN3_SEQUENCE ? "record" : "set"));
                } else {
                    for (int i = 0; i < nofComponents; ++i) {
                        Type componentType = ((TTCN3_Set_Seq_Choice_BaseType)last).getComponentByIndex(i).getType();
                        if (componentType.jsonAttribute == null) {
                            componentType.jsonAttribute = new JsonAST();
                        }
                        componentType.jsonAttribute.metainfo_unbound = true;
                    }
                }
            } else {
                switch (this.refdLast.getTypetype()) {
                    case TYPE_SEQUENCE_OF: 
                    case TYPE_SET_OF: 
                    case TYPE_ARRAY: {
                        break;
                    }
                    default: {
                        if (this.getParentType() != null && (this.getParentType().getTypetype() == IType.Type_type.TYPE_TTCN3_SEQUENCE || this.getParentType().getTypetype() == IType.Type_type.TYPE_TTCN3_SET)) break;
                        this.getLocation().reportSemanticError("Invalid attribute 'metainfo for unbound', requires record, set, record of, set of, array or field of a record or set");
                    }
                }
            }
        }
        if (this.jsonAttribute.as_number) {
            if (this.refdLast.getTypetypeTtcn3() != IType.Type_type.TYPE_TTCN3_ENUMERATED) {
                this.getLocation().reportSemanticError("Invalid attribute, 'as number' is only allowed for enumerated types");
            } else if (this.jsonAttribute.enum_texts.size() != 0) {
                this.getLocation().reportSemanticWarning("Attribute 'text ... as ...' will be ignored, because the enumerated values are encoded as numbers");
            }
        }
        if (this.jsonAttribute.as_map) {
            if (this.refdLast.getTypetype() != IType.Type_type.TYPE_SEQUENCE_OF && this.refdLast.getTypetype() != IType.Type_type.TYPE_SET_OF) {
                this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires record of or set of");
            } else {
                Type keyType;
                last = (AbstractOfType)this.refdLast;
                IType ofType = ((AbstractOfType)last).getOfType();
                IType ofTypeLast = ofType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                if (ofTypeLast.getTypetype() == IType.Type_type.TYPE_TTCN3_SEQUENCE && ((TTCN3_Sequence_Type)ofTypeLast).getNofComponents() == 2) {
                    keyType = ((TTCN3_Sequence_Type)ofTypeLast).getComponentByIndex(0).getType();
                    if (keyType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetype() != IType.Type_type.TYPE_UCHARSTRING) {
                        this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires the element type's first field to be a universal charstring");
                    }
                    if (keyType.isOptionalField()) {
                        this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires the element type's first field to be mandatory");
                    }
                } else if (ofTypeLast.getTypetype() == IType.Type_type.TYPE_TTCN3_SET || ((TTCN3_Set_Type)ofTypeLast).getNofComponents() == 2) {
                    keyType = ((TTCN3_Set_Type)ofTypeLast).getComponentByIndex(0).getType();
                    if (keyType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetype() != IType.Type_type.TYPE_UCHARSTRING) {
                        this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires the element type's first field to be a universal charstring");
                    }
                    if (keyType.isOptionalField()) {
                        this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires the element type's first field to be mandatory");
                    }
                } else {
                    this.getLocation().reportSemanticError("Invalid attribute, 'as map' requires the element type to be a record or set with 2 fields");
                }
            }
        }
        if (this.jsonAttribute.enum_texts.size() > 0) {
            if (this.refdLast.getTypetypeTtcn3() != IType.Type_type.TYPE_TTCN3_ENUMERATED) {
                this.getLocation().reportSemanticError("Invalid attribute, 'text ... as ...' requires an enumerated type");
            } else {
                for (int i = 0; i < this.jsonAttribute.enum_texts.size(); ++i) {
                    int index;
                    Identifier identifier = new Identifier(Identifier.Identifier_type.ID_TTCN, this.jsonAttribute.enum_texts.get((int)i).from, NULL_Location.INSTANCE, true);
                    if (!((TTCN3_Enumerated_Type)this.refdLast).hasEnumItemWithName(identifier)) {
                        this.getLocation().reportSemanticError(MessageFormat.format("Invalid JSON default value for enumerated type `{0}''", this.getTypename()));
                        continue;
                    }
                    EnumItem enumItem = ((TTCN3_Enumerated_Type)this.refdLast).getEnumItemWithName(identifier);
                    this.jsonAttribute.enum_texts.get((int)i).index = index = (int)((Integer_Value)enumItem.getValue()).getValue();
                    for (int j = 0; j < i; ++j) {
                        if (this.jsonAttribute.enum_texts.get((int)j).index != index) continue;
                        this.getLocation().reportSemanticError(MessageFormat.format("Duplicate attribute 'text ... as ...' for enumerated value `{0}''", this.jsonAttribute.enum_texts.get((int)i).from));
                    }
                }
            }
        }
    }

    @Override
    public int getDefaultRawFieldLength() {
        if (this.refdLast != null && !this.refdLast.getIsErroneous(CompilationTimeStamp.getBaseTimestamp()) && this.refdLast != this) {
            return this.refdLast.getDefaultRawFieldLength();
        }
        return 0;
    }

    @Override
    public int getRawLength(BuildTimestamp timestamp) {
        if (this.refdLast != null && !this.refdLast.getIsErroneous(CompilationTimeStamp.getBaseTimestamp()) && this.refdLast != this) {
            return this.refdLast.getRawLength(timestamp);
        }
        return -1;
    }

    @Override
    public int getLengthMultiplier() {
        if (this.refdLast != null && !this.refdLast.getIsErroneous(CompilationTimeStamp.getBaseTimestamp()) && this.refdLast != this) {
            return this.refdLast.getLengthMultiplier();
        }
        return 1;
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        if (this.refdLast != null) {
            this.refdLast.checkMapParameter(timestamp, refChain, errorLocation);
        }
    }

    @Override
    public void forceRaw(CompilationTimeStamp timestamp) {
        if (this.refd != null && !this.refd.getIsErroneous(CompilationTimeStamp.getBaseTimestamp()) && this.refdLast != this) {
            this.refd.forceRaw(timestamp);
        }
    }

    @Override
    public void forceJson(CompilationTimeStamp timestamp) {
        if (this.refd != null && !this.refd.getIsErroneous(CompilationTimeStamp.getBaseTimestamp()) && this.refdLast != this) {
            this.refd.forceJson(timestamp);
        }
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.refdLast != null && !this.equals(this.refdLast)) {
            this.refdLast.addProposal(propCollector, i);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        if (this.lastTimeChecked == null) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (this.refdLast != null && !this.equals(this.refdLast)) {
            this.refdLast.addDeclaration(declarationCollector, i);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        this.reference.updateSyntax(reparser, false);
        reparser.updateLocation(this.reference.getLocation());
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.reference != null) {
            this.reference.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.reference == null || this.reference.accept(v);
    }

    @Override
    public String createStringRep_for_OpenType_AltName(CompilationTimeStamp timestamp) {
        if (this.isTagged() || this.constraints != null || this.withAttributesPath != null && this.withAttributesPath.hasAttributes(timestamp)) {
            return this.getGenNameOwn();
        }
        return this.getTypeRefdLast(timestamp).createStringRep_for_OpenType_AltName(timestamp);
    }

    @Override
    public String getGenNameValue(JavaGenData aData, StringBuilder source) {
        if (this == this.refd || this.refd == null || this.refdLast == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        return this.refd.getGenNameValue(aData, source);
    }

    @Override
    public String getGenNameTemplate(JavaGenData aData, StringBuilder source) {
        if (this == this.refd || this.refd == null || this.refdLast == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        return this.refd.getGenNameTemplate(aData, source);
    }

    @Override
    public String getGenNameTypeDescriptor(JavaGenData aData, StringBuilder source) {
        if (this.rawAttribute != null || this.jsonAttribute != null || this.hasVariantAttributes(CompilationTimeStamp.getBaseTimestamp()) || !this.isAsn() && this.hasEncodeAttribute("JSON")) {
            if (this.needsAlias()) {
                String baseName = this.getGenNameOwn(aData);
                return baseName + "." + this.getGenNameOwn();
            }
            if (this.getParentType() != null) {
                IType parentType = this.getParentType();
                if (parentType.generatesOwnClass(aData, source)) {
                    return parentType.getGenNameOwn(aData) + "." + this.getGenNameOwn();
                }
                return this.getGenNameOwn(aData);
            }
            return this.getGenNameOwn(aData);
        }
        if (this.needsAlias()) {
            String baseName = this.getGenNameOwn(aData);
            return baseName + "." + this.getGenNameOwn();
        }
        ReferenceChain refChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
        IType t = this.getTypeRefd(CompilationTimeStamp.getBaseTimestamp(), refChain);
        refChain.release();
        if (t != null && t != this) {
            return t.getGenNameTypeDescriptor(aData, source);
        }
        ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
        return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
    }

    @Override
    public boolean needsOwnRawDescriptor(JavaGenData aData) {
        return this.rawAttribute != null;
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        if (this == this.refd || this.refd == null || this.refdLast == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        if (this.rawAttribute != null) {
            if (this.needsAlias()) {
                return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_raw_";
            }
            return this.getGenNameOwn(aData) + "_raw_";
        }
        return this.refd.getGenNameRawDescriptor(aData, source);
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return this.jsonAttribute != null && !this.jsonAttribute.empty() || this.getOwnertype() == IType.TypeOwner_type.OT_RECORD_OF && this.getParentType().getJsonAttribute() != null && this.getParentType().getJsonAttribute().as_map;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        if (this == this.refd || this.refd == null || this.refdLast == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            return "FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n";
        }
        if (this.needsOwnJsonDescriptor(aData)) {
            if (this.needsAlias()) {
                return this.getGenNameOwn(aData) + "." + this.getGenNameOwn() + "_json_";
            }
            return this.getGenNameOwn(aData) + "_json_";
        }
        return this.refd.getGenNameJsonDescriptor(aData, source);
    }

    @Override
    public boolean generatesOwnClass(JavaGenData aData, StringBuilder source) {
        return this.needsAlias();
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        block12: {
            block11: {
                if (this.lastTimeGenerated != null && !this.lastTimeGenerated.isLess(aData.getBuildTimstamp())) {
                    return;
                }
                this.lastTimeGenerated = aData.getBuildTimstamp();
                if (this.myScope.getModuleScopeGen() == this.refd.getMyScope().getModuleScopeGen()) {
                    StringBuilder tempSource = aData.getCodeForType(this.refd.getGenNameOwn());
                    this.refd.generateCode(aData, tempSource);
                }
                if (!this.needsAlias()) break block11;
                String ownName = this.getGenNameOwn();
                switch (this.refd.getTypetype()) {
                    case TYPE_PORT: {
                        source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{' '}'\n", ownName, this.refd.getGenNameValue(aData, source)));
                        break;
                    }
                    case TYPE_SIGNATURE: {
                        source.append(MessageFormat.format("\tpublic static class {0}_call extends {1}_call '{' '}'\n", ownName, this.refd.getGenNameValue(aData, source)));
                        source.append(MessageFormat.format("\tpublic static class {0}_call_redirect extends {1}_call_redirect '{' '}'\n", ownName, this.refd.getGenNameValue(aData, source)));
                        if (!((Signature_Type)this.refd).isNonblocking()) {
                            source.append(MessageFormat.format("\tpublic static class {0}_reply extends {1}_reply '{' '}'\n", ownName, this.refd.getGenNameValue(aData, source)));
                            source.append(MessageFormat.format("\tpublic static class {0}_reply_redirect extends {1}_reply_redirect '{' '}'\n", ownName, this.refd.getGenNameValue(aData, source)));
                        }
                        if (((Signature_Type)this.refd).getSignatureExceptions() != null) {
                            source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, this.refd.getGenNameTemplate(aData, source)));
                            break;
                        }
                        break block12;
                    }
                    default: {
                        source.append(MessageFormat.format("\tpublic static class {0} extends {1} '{'\n", ownName, this.refd.getGenNameValue(aData, source)));
                        StringBuilder descriptor = new StringBuilder();
                        this.generateCodeTypedescriptor(aData, source, descriptor, null);
                        this.generateCodeDefaultCoding(aData, source, descriptor);
                        this.generateCodeForCodingHandlers(aData, source, descriptor);
                        source.append((CharSequence)descriptor);
                        source.append("\t}\n");
                        source.append(MessageFormat.format("\tpublic static class {0}_template extends {1} '{' '}'\n", ownName, this.refd.getGenNameTemplate(aData, source)));
                        break;
                    }
                }
                break block12;
            }
            this.generateCodeTypedescriptor(aData, source, null, aData.attibute_registry);
            this.generateCodeDefaultCoding(aData, source, null);
            this.generateCodeForCodingHandlers(aData, source, null);
        }
        if (!this.isAsn()) {
            if (this.hasDoneAttribute()) {
                this.generateCodeDone(aData, source);
            }
            if (this.subType != null) {
                this.subType.generateCode(aData, source);
            }
        }
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        if (this == this.refdLast || this.refdLast == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return;
        }
        this.refdLast.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex, globalId, externalId, isTemplate, optype, field, targetScope);
    }

    @Override
    public boolean isPresentAnyvalueEmbeddedField(ExpressionStruct expression, List<ISubReference> subreferences, int beginIndex) {
        if (this == this.refdLast || this.refdLast == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return false;
        }
        return this.refdLast.isPresentAnyvalueEmbeddedField(expression, subreferences, beginIndex);
    }

    @Override
    public String generateConversion(JavaGenData aData, IType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        if (this == this.refdLast || this.refdLast == null) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return fromName;
        }
        return this.refdLast.generateConversion(aData, fromType, fromName, forValue, expression);
    }
}

