/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types.subtypes;

import java.math.BigInteger;
import org.eclipse.titan.designer.AST.TTCN3.types.subtypes.LimitType;

public final class SizeLimit
extends LimitType {
    public static final SizeLimit MAXIMUM = new SizeLimit(true);
    public static final SizeLimit MINIMUM = new SizeLimit(BigInteger.ZERO);
    private final boolean infinity;
    private final BigInteger size;

    public SizeLimit(BigInteger size) {
        this.infinity = false;
        this.size = size;
    }

    public SizeLimit(long size) {
        this(BigInteger.valueOf(size));
    }

    public SizeLimit(boolean infinity) {
        this.infinity = infinity;
        this.size = BigInteger.ZERO;
    }

    @Override
    public LimitType.Type getType() {
        return LimitType.Type.SIZE;
    }

    public BigInteger getSize() {
        return this.size;
    }

    public boolean getInfinity() {
        return this.infinity;
    }

    @Override
    public LimitType decrement() {
        if (this.infinity) {
            return new SizeLimit(true);
        }
        return new SizeLimit(this.size.subtract(BigInteger.ONE));
    }

    @Override
    public LimitType increment() {
        if (this.infinity) {
            return new SizeLimit(true);
        }
        return new SizeLimit(this.size.add(BigInteger.ONE));
    }

    @Override
    public boolean isAdjacent(LimitType other) {
        SizeLimit sl = (SizeLimit)other;
        if (this.infinity || sl.infinity) {
            return false;
        }
        return this.size.add(BigInteger.ONE).compareTo(sl.size) == 0;
    }

    @Override
    public int compareTo(LimitType o) {
        SizeLimit sl = (SizeLimit)o;
        if (this.infinity) {
            if (sl.infinity) {
                return 0;
            }
            return 1;
        }
        if (sl.infinity) {
            return -1;
        }
        return this.size.compareTo(sl.size);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SizeLimit)) {
            return false;
        }
        SizeLimit other = (SizeLimit)obj;
        return this.infinity == other.infinity && this.size == other.size;
    }

    @Override
    public void toString(StringBuilder sb) {
        if (this.infinity) {
            sb.append("infinity");
        } else {
            sb.append(this.size.toString());
        }
    }

    public int hashCode() {
        return this.size.hashCode();
    }
}

