/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.values.NamedValue;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class NamedValues
extends ASTNode
implements IIncrementallyUpdateable {
    public static final String DUPLICATEIDENTIFIERFIRST = "Duplicate field name `{0}'' was first used here";
    public static final String DUPLICATEIDENTIFIERREPEATED = "Duplicate identifier `{0}''";
    private final ArrayList<NamedValue> values = new ArrayList();
    private Map<String, NamedValue> namedValuesMap;
    private CompilationTimeStamp lastUniquenessCheck;

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.values.trimToSize();
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.get(i).setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        for (int i = 0; i < this.values.size(); ++i) {
            this.values.get(i).setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        for (int i = 0; i < this.values.size(); ++i) {
            NamedValue nv = this.values.get(i);
            if (nv != child) continue;
            return builder.append(".").append(nv.getName().getDisplayName());
        }
        return builder;
    }

    public void addNamedValue(NamedValue value) {
        if (value == null || value.getName() == null) {
            return;
        }
        this.values.add(value);
        value.setFullNameParent(this);
    }

    public void insertNamedValue(NamedValue value, int index) {
        if (value == null || value.getName() == null) {
            return;
        }
        this.values.add(index, value);
        value.setFullNameParent(this);
    }

    public void removeGeneratedValues() {
        if (this.values != null) {
            Iterator<NamedValue> iterator = this.values.iterator();
            while (iterator.hasNext()) {
                NamedValue temp = iterator.next();
                if (temp.isParsed()) continue;
                iterator.remove();
            }
        }
    }

    public int getSize() {
        return this.values.size();
    }

    public NamedValue getNamedValueByIndex(int index) {
        return this.values.get(index);
    }

    public boolean hasNamedValueWithName(Identifier name) {
        this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        return this.namedValuesMap.containsKey(name.getName());
    }

    public NamedValue getNamedValueByName(Identifier name) {
        this.checkUniqueness(CompilationTimeStamp.getBaseTimestamp());
        return this.namedValuesMap.get(name.getName());
    }

    public void checkUniqueness(CompilationTimeStamp timestamp) {
        if (this.lastUniquenessCheck != null && !this.lastUniquenessCheck.isLess(timestamp)) {
            return;
        }
        this.namedValuesMap = new HashMap<String, NamedValue>(this.values.size());
        for (NamedValue value : this.values) {
            Identifier identifier = value.getName();
            String name = identifier.getName();
            if (this.namedValuesMap.containsKey(name)) {
                this.namedValuesMap.get(name).getName().getLocation().reportSingularSemanticError(MessageFormat.format(DUPLICATEIDENTIFIERFIRST, identifier.getDisplayName()));
                value.getLocation().reportSemanticError(MessageFormat.format(DUPLICATEIDENTIFIERREPEATED, identifier.getDisplayName()));
                continue;
            }
            this.namedValuesMap.put(name, value);
        }
        this.lastUniquenessCheck = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        for (NamedValue value : this.values) {
            value.updateSyntax(reparser, false);
            reparser.updateLocation(value.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.values == null) {
            return;
        }
        for (NamedValue nv : this.values) {
            nv.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.values != null) {
            for (NamedValue nv : this.values) {
                if (nv.accept(v)) continue;
                return false;
            }
        }
        return true;
    }
}

