/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.Array_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.ArrayDimensions;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Referenced_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ComponentRunningExpression
extends Expression_Value {
    private static final String OPERATIONNAME = "component running";
    private final IValue value;
    private final boolean anyfrom;
    private final Reference indexRedirection;

    public ComponentRunningExpression(IValue value, Reference index_redirection, boolean anyFrom) {
        this.value = value;
        this.indexRedirection = index_redirection;
        this.anyfrom = anyFrom;
        if (value != null) {
            value.setFullNameParent(this);
        }
        if (index_redirection != null) {
            index_redirection.setFullNameParent(this);
        }
    }

    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.COMPONENT_RUNNING_OPERATION;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return this.value != null && this.value.checkExpressionSelfReferenceValue(timestamp, lhs);
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value.createStringRepresentation()).append(".running");
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.indexRedirection != null) {
            this.indexRedirection.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        super.setCodeSection(codeSection);
        if (this.value != null) {
            this.value.setCodeSection(codeSection);
        }
        if (this.indexRedirection != null) {
            this.indexRedirection.setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.value == child) {
            return builder.append(".<operand>");
        }
        if (this.value == child) {
            return builder.append(".redirectIndex");
        }
        return builder;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_BOOL;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        IValue tempValue = this.value.setLoweridToReference(timestamp);
        IType t = Component_Type.checkExpressionOperandComponentRefernce(timestamp, tempValue, OPERATIONNAME, this.anyfrom);
        this.checkExpressionDynamicPart(expectedValue, OPERATIONNAME, false, true, false);
        if (this.indexRedirection != null && t != null) {
            t = t.getTypeRefdLast(timestamp);
            ArrayDimensions dimensions = new ArrayDimensions();
            while (t.getTypetype() == IType.Type_type.TYPE_ARRAY) {
                dimensions.add(((Array_Type)t).getDimension());
                t = ((Array_Type)t).getElementType().getTypeRefdLast(timestamp);
            }
            Statement.checkIndexRedirection(timestamp, this.indexRedirection, dimensions, this.anyfrom, "timer");
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        if (this.value == null) {
            return this.lastValue;
        }
        this.checkExpressionOperands(timestamp, expectedValue, referenceChain);
        if (this.getIsErroneous(timestamp)) {
            return this.lastValue;
        }
        if (this.isUnfoldable(timestamp, referenceChain)) {
            return this.lastValue;
        }
        this.lastValue = this.value;
        return this.lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.value instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.value)).updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        } else if (this.value != null) {
            throw new ReParseException();
        }
        if (this.indexRedirection != null) {
            this.indexRedirection.updateSyntax(reparser, false);
            reparser.updateLocation(this.indexRedirection.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.indexRedirection != null) {
            this.indexRedirection.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        return this.indexRedirection == null || this.indexRedirection.accept(v);
    }

    @Override
    public boolean returnsNative() {
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        if (this.indexRedirection != null) {
            return false;
        }
        return this.value.canGenerateSingleExpression();
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        this.value.generateCodeExpression(aData, expression, true);
        if (this.value.getValuetype() == IValue.Value_type.REFERENCED_VALUE) {
            ComponentRunningExpression.generateCodeExpressionOptionalFieldReference(aData, expression, ((Referenced_Value)this.value).getReference());
        }
        expression.expression.append(".running(");
        if (this.indexRedirection == null) {
            expression.expression.append("null");
        } else {
            Statement.generateCodeIndexRedirect(aData, expression, this.indexRedirection, this.getMyScope());
        }
        expression.expression.append(')');
    }
}

