/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core.makefile;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.SymbolicLinkHandler;
import org.eclipse.titan.designer.core.TITANBuilderResourceVisitor;
import org.eclipse.titan.designer.decorators.TITANDecorator;

public class ExternalMakefileGenerator {
    static final String EMPTY_STRING = "";
    static final String APOSTROPHE = "'";
    static final String BIN_DIRECTORY = "bin";
    static final String MAKEFILEGENERATOR = "ttcn3_makefilegen";

    public static List<String> createMakefileGeneratorCommand(IProject project) {
        boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        TITANBuilderResourceVisitor visitor = ProjectBasedBuilder.getProjectBasedBuilder(project).getResourceVisitor();
        Map<String, IFile> files = visitor.getFiles();
        Map<String, IFile> centralStorageFiles = visitor.getCentralStorageFiles();
        Map<String, IFile> referencedFiles = ProjectBasedBuilder.getProjectBasedBuilder(project).getFilesofReferencedProjects();
        ArrayList<String> command = new ArrayList<String>();
        IPreferencesService prefs = Platform.getPreferencesService();
        String pathOfTITAN = prefs.getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.TTCN3_INSTALL_DIR", EMPTY_STRING, null);
        Path makefilegenPath = new Path(pathOfTITAN + File.separatorChar + BIN_DIRECTORY + File.separatorChar + MAKEFILEGENERATOR);
        StringBuilder output = new StringBuilder();
        command.add(PathConverter.convert((String)makefilegenPath.toOSString(), (boolean)reportDebugInformation, (StringBuilder)output));
        TITANDebugConsole.println(output);
        String decoratorParametersLong = TITANDecorator.propertiesAsParameters(project, true);
        if (!EMPTY_STRING.equals(decoratorParametersLong)) {
            String[] parameters = decoratorParametersLong.split(" ");
            for (int i = 0; i < parameters.length; ++i) {
                command.add((String)parameters[i]);
            }
        }
        SymbolicLinkHandler.createSymlinks((IResource)project);
        for (String path : files.keySet()) {
            command.add(APOSTROPHE + path + APOSTROPHE);
        }
        IPath centralStorageDirectoryPath = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryPath(true);
        String centralStorageDirectory = centralStorageDirectoryPath.toOSString();
        for (String fileName : centralStorageFiles.keySet()) {
            IFile file = centralStorageFiles.get(fileName);
            IProject otherProject = file.getProject();
            IPath referencedCentralStorageDirectoryPath = ProjectBasedBuilder.getProjectBasedBuilder(otherProject).getWorkingDirectoryPath(true);
            String referencedCentralStorageDirectory = referencedCentralStorageDirectoryPath.toOSString();
            String relativePathToDirectory = PathUtil.getRelativePath((String)centralStorageDirectory, (String)referencedCentralStorageDirectory);
            Path relativePath = new Path(relativePathToDirectory);
            String path = relativePath.append(fileName).toOSString();
            output = new StringBuilder();
            command.add(APOSTROPHE + PathConverter.convert((String)path, (boolean)reportDebugInformation, (StringBuilder)output) + APOSTROPHE);
            TITANDebugConsole.println(output);
        }
        IPath workingDirectoryPath = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryPath(true);
        String workingDirectory = workingDirectoryPath.toOSString();
        for (String fileName : referencedFiles.keySet()) {
            IFile file = referencedFiles.get(fileName);
            IProject otherProject = file.getProject();
            IPath referencedWorkingDirectoryPath = ProjectBasedBuilder.getProjectBasedBuilder(otherProject).getWorkingDirectoryPath(true);
            String referencedWorkingDirectory = referencedWorkingDirectoryPath.toOSString();
            String relativePathToDirectory = PathUtil.getRelativePath((String)workingDirectory, (String)referencedWorkingDirectory);
            Path relativePath = new Path(relativePathToDirectory);
            String path = relativePath.append(fileName).toOSString();
            output = new StringBuilder();
            command.add(APOSTROPHE + PathConverter.convert((String)path, (boolean)reportDebugInformation, (StringBuilder)output) + APOSTROPHE);
            TITANDebugConsole.println(output);
        }
        return command;
    }
}

